/* summary -- print summary of data in file */

/* m.a. huckvale - feb 1986 */

/* version 1 */
/* version 1.1  - New WD item */
/* version 1.2 - new history field */
/* version 1.3 - december 1986
        - uses SPARPATH
*/
/* version 1.4 - EN and VU items */
/* version 1.5 - TR item */
/* version 2.0 - SFS */
/*--------------------------------------------------------------------------*/
/**MAN
.TH SUMMARY SFS1 UCL SFS
.SH NAME
summary, slook - print summary information about data sets in file
.SH SYNOPSIS
.B summary
(-i item) (-a item) (-l) file
.br
.B slook
(-i item) (-a item) (-l) file
.SH DESCRIPTION
.I summary
is a program to list summary information from the item headers of data sets stored
in the specified file.  The information printed is the item generic name, type, subtype,
size in frames, and history.  
.I slook
is a program to list text descriptions of data sets stored
in the specified file.  The information printed is the item generic name, type, subtype,
size in frames, and text label.
.PP  
Individual item types may be selected with the "-a" option.
Individual items may
be selected with the "-i" option.
.PP
.I Options
and their meanings are:
.TP 11
.B -I
Identify program and exit.
.TP 11
.BI -i item
Select first item matching item specification.
.TP 11
.BI -a type
Select all items matching item specification.
.TP 11
.B -l
Print long histories (default: short).
.SH VERSION/AUTHOR
2.0 - Mark Huckvale
*/
/*--------------------------------------------------------------------------*/

#define PROGNAME "summary"
#define PROGVERS "2.0s"
char *progname=PROGNAME;

/* global declarations */
#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <ctype.h>
#include <string.h>
#include "sfs.h"

/* item selection data */
#define MAXSELECT 20
struct {
	int	it;
	int	ty;
	char	*match;
	int	all;
} itab[MAXSELECT];
int	itcnt=0;
int	longhist=0;
#ifdef LOOK
int	look=1
#else
int	look=0;
#endif

#ifdef __STDC__
void reportitem(struct item_header *item,int num,char *exphist);
int itrequired(struct item_header *item,char *hist,int flag);
#else
void reportitem();
int itrequired();
#endif

/* main program */
void main(argc,argv)
int argc;
char *argv[];
{
        /* option decoding variables */
        extern int      optind;
        extern char     *optarg;
        int             errflg=0;
        char            c;
	/* file variables */
        int             dbfil;
        char            filename[SFSMAXFILENAME];
	/* matching variables */
	int		cnt=0;
	int		pass1=0;
	char		*exphist,*lab_store();
	struct item_header item;
	char		junk[16];

	/* check whether "summary" or "look" working */
	if (histmatch("*look*",argv[0],junk,junk,junk,junk,junk,junk,junk,junk,junk,junk)) look=1;
	if (histmatch("*LOOK*",argv[0],junk,junk,junk,junk,junk,junk,junk,junk,junk,junk)) look=1;
	if (histmatch("*summary*",argv[0],junk,junk,junk,junk,junk,junk,junk,junk,junk,junk)) look=0;
	if (histmatch("*SUMMARY*",argv[0],junk,junk,junk,junk,junk,junk,junk,junk,junk,junk)) look=0;
	progname = argv[0];

        /* decode switches */
        while ( (c = getopt(argc,argv,"Ii:a:l")) != EOF) switch (c) {
                case 'I' :      /* Identify */
                	if (look)
	                        fprintf(stderr,"%s: Summary of SFS file contents V%s\n","slook",PROGVERS);
			else
	                        fprintf(stderr,"%s: Summary of SFS file contents V%s\n",PROGNAME,PROGVERS);
                        exit(0);
                        break;
		case 'i' :	/* specific item */
			if (itspec(optarg,&itab[itcnt].it,&itab[itcnt].match) != 0)
				error("bad 'i' option : %s",optarg);
			if (strcmp(itab[itcnt].match,"0")==0) pass1++;
			itcnt++;
			break;
		case 'a' :	/* generic item */
			if (itspec(optarg,&itab[itcnt].it,&itab[itcnt].match) != 0)
				error("bad 'a' option : %s",optarg);
			if (strcmp(itab[itcnt].match,"0")==0)
				itab[itcnt].match = "*";
			itab[itcnt].all=1;
			itcnt++;
			break;
		case 'l' :	/* long histories */
			longhist++;
			break;
                case '?' :      /* unknown */
                        errflg++;
        }
        if (errflg || (argc<2)) {
		if (look) 
	                error("usage: %s (-I) (-i item) (-a item) file","slook");
		else
	                error("usage: %s (-I) (-i item) (-a item) (-l) file",PROGNAME);
	}

        /* get filename */
        if (optind < argc)
                strcpy(filename,sfsfile(argv[optind]));
        else
                error("no database file specified",NULL);

	/* check local file */
        if (strcmp(filename,argv[optind]) != 0)
                printf("summary of %s:\n",filename);

        /* open datafile */
        if ((dbfil = sfsopen(filename,"r",NULL)) < 0) {
                if (dbfil == -1)
                        error("cannot open %s",filename);
                else
                        error("access error on %s",filename);
        }

	/* first pass for specially selected items */
	if (pass1) {
	        while (sfsnextitem(dbfil,&item)) {
			exphist = lab_store(&item);
			itrequired(&item,exphist,0);
		}
		close(dbfil);
	        dbfil = sfsopen(filename,"r",NULL);
	}

        /* process data items */
        while (sfsnextitem(dbfil,&item)) {
		exphist = lab_store(&item);
		cnt++;
		if ((itcnt==0) || itrequired(&item,exphist,1))
	                /* report item header */
        	        reportitem(&item,cnt,exphist);
	}
	close(dbfil);

	/* that's all folks */
        exit(0);
}

/* report item header */
void reportitem(item,num,exphist)
struct item_header *item;
int     num;
char 	*exphist;
{
	extern	char	*sfsname[],*sfslabel[];
	char		*lab_gettext();
	char		*t;

	if (look && (item->datatype < 0)) return;

        printf("%2d. ",num);
        if ((item->datatype >= -MAXDATATYPE) && (item->datatype <= MAXDATATYPE)) 
                printf("%8s",sfsname[abs(item->datatype)]);
        else
                printf("type %3d",item->datatype);
        if (item->datatype < 0)
                printf(" -");
        else
                printf("  ");
	if (look)
		printf("(%s.%02d)",sfslabel[abs(item->datatype)],item->subtype);
        else if (abs(item->datatype) < 10)
                printf(" (%d.%02d)",abs(item->datatype),item->subtype);
        else
                printf("(%2d.%02d)",abs(item->datatype),item->subtype);
        printf("%6d frames",item->numframes);
	if (look) {
		t = lab_gettext(exphist);
		if (t != NULL)
		        printf(" of %s",t);
		else if (longhist)
		        printf(" from %s",exphist);
		else
		        printf(" from %s",item->history);
	}
	else {
		if (longhist)
		        printf(" from %s",exphist);
		else
		        printf(" from %s",item->history);
	}
        printf("\n");
}

/* check if item required */
int itrequired(item,hist,flag)
struct item_header 	*item;
char			*hist;
int			flag;		/* 0=first pass; 1=second pass */
{
	int	i,ty,req=0;
	char	junk[16];
	
	for (i=0;i<itcnt;i++) if ((itab[i].it==0) || (itab[i].it==item->datatype)) {
		if (itab[i].ty==item->subtype)
			req++;
		else if (isdigit(itab[i].match[0]) || (itab[i].match[0]=='-')) {
			ty=atoi(itab[i].match);
			if ((ty==-1) || (ty==item->subtype)) {
				if (itab[i].all==0) itab[i].ty=item->subtype;
				req++;
			}
			else if ((ty==0) && (flag==0)) {
				itab[i].it=abs(item->datatype);
				itab[i].ty=item->subtype;
			}
		}
		else if (itab[i].ty==0) {
			if (histmatch(itab[i].match,hist,junk,junk,junk,junk,junk,junk,junk,junk,junk,junk)==1) {
				if (itab[i].all==0) itab[i].ty=item->subtype;
				req++;
			}
		}
	}
	return(req);
}
