/* kspandrv -- K-SPAN driver */

/* M.A. Huckvale - July 1991 */

/* standard definitions */

/* operators */
#define NUL		-1
#define FIX		0
#define LIN		1
#define LOG		2

/* parameters */
#define PARM_F0   0
#define PARM_AV   1
#define PARM_OQ   2
#define PARM_SQ   3
#define PARM_TL   4
#define PARM_FL   5
#define PARM_DI   6
#define PARM_AH   7
#define PARM_AF   8
#define PARM_F1   9
#define PARM_B1   10
#define PARM_DF1  11
#define PARM_DB1  12
#define PARM_F2   13
#define PARM_B2   14
#define PARM_F3   15
#define PARM_B3   16
#define PARM_F4   17
#define PARM_B4   18
#define PARM_F5   19
#define PARM_B5   20
#define PARM_F6   21
#define PARM_B6   22
#define PARM_FNP  23
#define PARM_BNP  24
#define PARM_FNZ  25
#define PARM_BNZ  26
#define PARM_FTP  27
#define PARM_BTP  28
#define PARM_FTZ  29
#define PARM_BTZ  30
#define PARM_A2F  31
#define PARM_A3F  32
#define PARM_A4F  33
#define PARM_A5F  34
#define PARM_A6F  35
#define PARM_AB   36
#define PARM_B2F  37
#define PARM_B3F  38
#define PARM_B4F  39
#define PARM_B5F  40
#define PARM_B6F  41
#define PARM_ANV  42
#define PARM_A1V  43
#define PARM_A2V  44
#define PARM_A3V  45
#define PARM_A4V  46
#define PARM_ATV  47

#define NUM_PARM  48

/* routines */
#define AT(t)		_abstime=(t)
#define WAIT(t)		_abstime+=(t)
#define NOW		_abstime
#define SAVE		_push(_abstime)
#define RESTORE		_abstime=_pop()
#define GET(p,t)	_setval(p(-2,NUL),NUL,NUL,t)
#define FX(v,i)		_setval(PARM_F0 ,v,i,_abstime)
#define F0(v,i)		_setval(PARM_F0 ,v,i,_abstime)
#define AV(v,i)		_setval(PARM_AV ,v,i,_abstime)
#define OQ(v,i)		_setval(PARM_OQ ,v,i,_abstime)
#define SQ(v,i)		_setval(PARM_SQ ,v,i,_abstime)
#define TL(v,i)		_setval(PARM_TL ,v,i,_abstime)
#define FL(v,i)		_setval(PARM_FL ,v,i,_abstime)
#define DI(v,i)		_setval(PARM_DI ,v,i,_abstime)
#define AH(v,i)		_setval(PARM_AH ,v,i,_abstime)
#define AF(v,i)		_setval(PARM_AF ,v,i,_abstime)
#define F1(v,i)		_setval(PARM_F1 ,v,i,_abstime)
#define B1(v,i)		_setval(PARM_B1 ,v,i,_abstime)
#define DF1(v,i)	_setval(PARM_DF1,v,i,_abstime)
#define DB1(v,i)	_setval(PARM_DB1,v,i,_abstime)
#define F2(v,i)		_setval(PARM_F2 ,v,i,_abstime)
#define B2(v,i)		_setval(PARM_B2 ,v,i,_abstime)
#define F3(v,i)		_setval(PARM_F3 ,v,i,_abstime)
#define B3(v,i)		_setval(PARM_B3 ,v,i,_abstime)
#define F4(v,i)		_setval(PARM_F4 ,v,i,_abstime)
#define B4(v,i)		_setval(PARM_B4 ,v,i,_abstime)
#define F5(v,i)		_setval(PARM_F5 ,v,i,_abstime)
#define B5(v,i)		_setval(PARM_B5 ,v,i,_abstime)
#define F6(v,i)		_setval(PARM_F6 ,v,i,_abstime)
#define B6(v,i)		_setval(PARM_B6 ,v,i,_abstime)
#define FNP(v,i)	_setval(PARM_FNP,v,i,_abstime)
#define BNP(v,i)	_setval(PARM_BNP,v,i,_abstime)
#define FNZ(v,i)	_setval(PARM_FNZ,v,i,_abstime)
#define BNZ(v,i)	_setval(PARM_BNZ,v,i,_abstime)
#define FTP(v,i)	_setval(PARM_FTP,v,i,_abstime)
#define BTP(v,i)	_setval(PARM_BTP,v,i,_abstime)
#define FTZ(v,i)	_setval(PARM_FTZ,v,i,_abstime)
#define BTZ(v,i)	_setval(PARM_BTZ,v,i,_abstime)
#define A2F(v,i)	_setval(PARM_A2F,v,i,_abstime)
#define A3F(v,i)	_setval(PARM_A3F,v,i,_abstime)
#define A4F(v,i)	_setval(PARM_A4F,v,i,_abstime)
#define A5F(v,i)	_setval(PARM_A5F,v,i,_abstime)
#define A6F(v,i)	_setval(PARM_A6F,v,i,_abstime)
#define AB(v,i)		_setval(PARM_AB ,v,i,_abstime)
#define B2F(v,i)	_setval(PARM_B2F,v,i,_abstime)
#define B3F(v,i)	_setval(PARM_B3F,v,i,_abstime)
#define B4F(v,i)	_setval(PARM_B4F,v,i,_abstime)
#define B5F(v,i)	_setval(PARM_B5F,v,i,_abstime)
#define B6F(v,i)	_setval(PARM_B6F,v,i,_abstime)
#define ANV(v,i)	_setval(PARM_ANV,v,i,_abstime)
#define A1V(v,i)	_setval(PARM_A1V,v,i,_abstime)
#define A2V(v,i)	_setval(PARM_A2V,v,i,_abstime)
#define A3V(v,i)	_setval(PARM_A3V,v,i,_abstime)
#define A4V(v,i)	_setval(PARM_A4V,v,i,_abstime)
#define ATV(v,i)	_setval(PARM_ATV,v,i,_abstime)

#define LENGTH(t)	_maxlength(t)
#define CLEAR		_clearsynth()
#define FLUSH		_spanflush()

/* global parameters */
extern int	_abstime;

/* definition of SYNTH routine */
void SYNTH(char **param);

