/* spcc -- include file for SPC generated C source */

#include "SFSCONFG.h"
#include <stdio.h>
#include <math.h>

/* constants */
#define FALSE		0
#define TRUE		1

/* built-in types */
typedef FILE * filedesc;
typedef struct {
	int	len;
	struct {
		char 	*ar;
	} buf;
} string;
typedef struct {
	int	len;
	double	smr;
	struct {
		short 	*ar;
	} buf;
} waveform;

/* annotation structure - matches 'annotation_record' in annot.inc */
struct annotation_rec {
	int	sample;
	string	annot;
	struct annotation_rec *next;
};

/* track item data structure - matches 'tr_item' in track.inc */
typedef struct tr_item_rec {
	int	len;
	double	smr;
	double	*buf;
} tr_item_rec;

/* built-in functions */
#define	_ATAN(p)	atan((double)(p))
#define _COS(p)		cos((double)(p))
#define	_EOF(p)		_eof((filedesc)(p))
#define	_EOLN(p)	_eoln((filedesc)(p))
#define _EXP(p)		exp((double)(p))
#define	_IOERROR()	_ioerror()
#define	_LOG(p)		log((double)(p))
#define	_ODD(p)		((int)(p) & 0x1L)
#define	_PRED(p)	((int)(p)-1)
#define	_ROUND(p)	(((p)>0)?(int)((p)+0.5):(int)((p)-0.5))
#define	_SIN(p)		sin((double)(p))
#define	_SQRT(p)	sqrt((double)(p))
#define	_SUCC(p)	((int)(p)+1)
#define	_TRUNC(p)	((int)(p))

/* NULL definitions */
string stringNULL;
waveform waveformNULL;

/* function prototype macros */
#define ARGS1(type,arg1)		type arg1
#define ARGS2(type,arg1,arg2)		ARGS1(type,arg1),ARGS1(type,arg2)
#define ARGS3(type,arg1,arg2,arg3)	ARGS2(type,arg1,arg2),ARGS1(type,arg3)
#define ARGS4(type,arg1,arg2,arg3,arg4)	ARGS2(type,arg1,arg2),ARGS2(type,arg3,arg4)
#define ARGS5(type,arg1,arg2,arg3,arg4,arg5)	ARGS3(type,arg1,arg2,arg3),ARGS2(type,arg4,arg5)

/* function prototypes in pasfunc */
#ifdef __STDC__
void _new(char **,int);
void _dispose(char *);
int _iabs(int);
int _isqr(int);
double _rabs(double);
double _rsqr(double);
void _READ(filedesc,int,char *);
void _readln(filedesc);
int _eof(filedesc);
int _eoln(filedesc);
void _WRITE(filedesc,int,...);
void _writeln(filedesc);
void _fileclose(filedesc);
void _ioerrortrap(int);
filedesc _reset(string);
filedesc _rewrite(string);
int ioerrno(void);
void runerror(char *,...);
char  *strmalloc(int);
short * wavmalloc(int);
void wavcopy(short *,short *,int);
void _spush(string);
void _spushstr(char *);
void _spushchar(int);
void _ssave(string);
string _spop(void);
void _sassign(string *,string);
void _cassign(char *,string);
void _schar(int);
int _sord(string);
void _sarith(int);
int _scompare(int);
void _sfree(string);
void _wpush(waveform);
void _wsave(waveform);
waveform _wpop(void);
void _wassign(waveform *,waveform);
void _warith(int);
void _wfree(waveform);
#else
#define void
int _iabs();
int _isqr();
double _rabs();
double _rsqr();
filedesc _reset();
filedesc _rewrite();
char  *strmalloc();
short *wavmalloc();
string	_spop();
waveform _wpop();
#endif

/* function prototypes in sfsfunc.c */
#ifdef __STDC__
waveform newwaveform_(int,double);
void replaywaveform_(waveform *);
waveform recordwaveform_(int size,double rate);
waveform cutwaveform_(waveform *,int,int);
waveform filterwaveform_(waveform *win,int ftype,double flo,double fhi,int forder);
void pause_(double dur);
unsigned char sfsfile_(string);
unsigned char sfsitem_(string);
void abort_(string messg);
int speechsize_(void);
double speechrate_(void);
waveform speechload_(void);
waveform speechpart_(int,int);
void speechsave_(string fname,string hist,waveform *wave);
/* unsigned char loadannotations_(struct annotation_rec **baseptr,double samprate); */
int tracksize_(void);
double trackrate_(void);
tr_item_rec * trackload_(void);
tr_item_rec * trackpart_(int start,int stop);
/* void tracksave_(string fname,string hist,tr_item_rec *tr); */
/* void trackfree_(tr_item_rec *tr); */
#ifdef _MSC_VER
void srandom(int newseed);
int random(void);
#endif

#else
waveform newwaveform_();
void replaywaveform_();
waveform recordwaveform_();
waveform cutwaveform_();
waveform filterwaveform_();
void pause_();
unsigned char sfsfile_();
unsigned char sfsitem_();
void abort_();
int speechsize_();
double speechrate_();
waveform speechload_();
waveform speechpart_();
unsigned char speechsave_();
unsigned char loadannotations_();
int tracksize_();
double trackrate_();
tr_item_rec * trackload_();
tr_item_rec * trackpart_();
void tracksave_();
void trackfree_();
#endif

/* built-in variables */
int	gargc;
char	**gargv;
