{ tools.inc - basic speech tools for SPC course }

{ constants }
const
	PI=3.14159265358979323846;
	MAXSHORT=32767;
	REALWAVESIZE=16384;
	COMPLEXWAVESIZE=REALWAVESIZE;

{ types }
type
	complex=record re,im:real end;
	realwave=array[1..REALWAVESIZE] of real;
	complexwave=array[1..COMPLEXWAVESIZE] of complex;
	spectrum=array[0..COMPLEXWAVESIZE] of complex;

{ math functions }
external function _log10(val:real):real;
function log10(val:real):real;
begin
	if val > 1.0E-100 then
		log10 := _log10(val)
	else
		log10 := -100;
end;

{$I wave.inc }
{$I sfs.inc }
{$I annot.inc }
{$I speech.inc }
{$I complex.inc }
