/* gfbox -- draw a filled in rectangle */

#include <stdio.h>
#include "SFSCONFG.h"
#include "dig.h"
#include "digdata.h"
#include "digtable.h"

#ifdef __STDC__
void   digfillbox(int  bundle,float  trx,float  try,float  blx,float  bly)
#else
void	digfillbox(bundle,trx,try,blx,bly)
int 	bundle;			/* bundle number */
float 	trx,try;		/* coords of one corner */
float	blx,bly;		/* coords of diagonal corner */
#endif
{
	int x1,y1,x2,y2;

	x1 = xpix(trx);
	y1 = ypix(try);
	x2 = xpix(blx);
	y2 = ypix(bly);

	digfillboxp(bundle,x1,y1,x2,y2);
}

void	digfillboxp(bundle,trx,try,blx,bly)
int 	bundle;			/* bundle number */
int 	trx,try;		/* coords of one corner */
int	blx,bly;		/* coords of diagonal corner */
{

	(*digtable[digdata.select].fillrect)(bundle,trx,try,blx,bly);
}

#ifdef EMO
main()
{
	int	i,j;

	digstart(DIG_DEFAULT_TERM,NULL,1);
	digclearscreen();
#ifdef OLD_DEMO
	digscale(8.0,8.0,1);
	digbox(20,0.0,0.0,8.0,8.0);
	digorigin(0.5,0.5);
	for (i=0;i<8;i++) {
		for (j=0;j<4;j++) {
			diglinemode(1);
			digfillbox(24,-0.5,-0.5,0.5,0.5);
			diglinemode(0);
			digfillbox(0,-0.1,-0.1,0.1,0.1);
			digorigin(0.0,2.0);
		}
		if ((i%2)==0)
			digorigin(1.0,-7.0);
		else
			digorigin(1.0,-9.0);
	}
#else
	digscale(2.0,2.0,0);
	digfillbox(20,0.5,0.5,1.5,1.5);
	digfillbox(24,0.6,0.6,0.8,0.8);
	diglinemode(1);
	digfillbox(24,0.75,0.75,1.1,1.1);
	digline(21,0.75,0.75,1.1,1.1);
	digflush();
	digfillbox(24,0.9,0.9,1.25,1.25);
	digline(21,0.9,0.9,1.25,1.25);
	diglinemode(0);	
	digfillbox(24,1.2,1.2,1.4,1.4);
#endif
	digquit(15);
	exit(0);
}
#endif
