/* gline -- draw a graphics line */

#include "SFSCONFG.h"
#include <stdio.h>
#include <math.h>
#include "dig.h"
#include "digdata.h"
#include "digtable.h"

#define X1 digdata.clipxmin
#define X2 digdata.clipxmax
#define Y1 digdata.clipymin
#define Y2 digdata.clipymax

#define PBLEN 100			/* 50 plot vectors */
static int	oldbundle = -1;
static short	plotbuff[PBLEN],*plotptr = plotbuff;
static int	qreverse,qbun = -1,qx1,qx2,qy1,qy2;	/* one line queue */
void 		digiplot();
void		diglinep();
void		digflush();
static 		digdoplot();
static 		digflushs();

/* digline -- global routine for drawing lines */
#ifdef __STDC__
void   digline(int  bundle,float xstart,float ystart,float xend,float yend)
#else
void	digline (bundle,xstart,ystart,xend,yend)
int 	bundle;
float 	xstart,ystart,xend,yend;
#endif
{
	int x1,y1,x2,y2;

	/* Convert coordinates to pixels */
	x1 = xpix(xstart);
	y1 = ypix(ystart);
	x2 = xpix(xend);
	y2 = ypix(yend);

	/* draw pixel line */
	diglinep(bundle,x1,y1,x2,y2);
}

/* diglinep -- global routine for plotting pixel lines */
void	diglinep(bundle,x1,y1,x2,y2)
int 	bundle;
int 	x1,y1,x2,y2;
{
	int 		dy,dx,det;
	int 		temp;
	int		reverse;	/* line direction reverse */

	/* sort out the bundle numbers */
	if ( bundle > 100 ) 
		bundle = 100;
	else if ( bundle < 0 ) 
		bundle = 0;

	/* for convenience force line direction to be up/right */
	if ((x1+y1) > (x2+y2)) {
		temp = x1; 
		x1 = x2; 
		x2 = temp;
		temp = y1; 
		y1 = y2; 
		y2 = temp;
		reverse = 1;
	}
	else
		reverse = 0;

	/* Now clip the data */
	dx = x2 - x1;
	dy = y2 - y1;
	det = x1*y2 - x2*y1;
	if (dx > 0) {
		if (x1 < X1) {
			if (x2 < X1) return;		/* No plot */
			y1 = (2*(X1*dy-det) + dx)/(2*dx);
			x1 = X1;
		}
		if (x2 > X2) {
			if (x1 > X2) return;		/* no plot */
			y2 = (2*(X2*dy-det) + dx)/(2*dx);
			x2 = X2;
		}
	}
	else {
		if (x2 < X1) {
			if (x1 < X1) return;		/* No plot */
			y2 = (2*(X1*dy-det) + dx)/(2*dx);
			x2 = X1;
		}
		if (x1 > X2) {
			if (x2 > X2) return;		/* no plot */
			y1 = (2*(X2*dy-det) + dx)/(2*dx);
			x1 = X2;
		}
	}
	if (dy > 0) {
		if (y1 < Y1) {
			if (y2 < Y1) return;		/* No plot */
			x1 = (2*(Y1*dx+det) + dy)/(2*dy);
			y1 = Y1;
		}
		if (y2 > Y2) {
			if (y1 > Y2) return;		/* no plot */
			x2 = (2*(Y2*dx+det) + dy)/(2*dy);
			y2 = Y2;
		}
	}
	else {
		if (y2 < Y1) {
			if (y1 < Y1) return;		/* No plot */
			x2 = (2*(Y1*dx+det) + dy)/(2*dy);
			y2 = Y1;
		}
		if (y1 > Y2) {
			if (y2 > Y2) return;		/* no plot */
			x1 = (2*(Y2*dx+det) + dy)/(2*dy);
			y1 = Y2;
		}
	}

	/* Now see if it can be combined with the previous line */
	if (!dx && (bundle == qbun) && (qx1 == x1) && (qx2 == x1)
	    &&  (y2 >= qy1-1) && (qy2 >= y1-1)) {
		if (y1 < qy1) {
			qy1 = y1;
			if (reverse) qreverse = 1;
		}
		if (y2 > qy2) {
			qy2 = y2;
			if (!reverse) qreverse = 0;
		}
	}
	else if (!dy && (bundle == qbun) && (qy1 == y1) && (qy2 == y1)
	    &&  (x2 >= qx1-1) && (qx2 >= x1-1)) {
		if (x1 < qx1) {
			qx1 = x1;
			if (reverse) qreverse = 1;
		}
		if (x2 > qx2) {
			qx2 = x2;
			if (!reverse) qreverse = 0;
		}
	}
	else {
		if (qbun>=0) {		/* output old queue */
			if (qreverse) digdoplot(qbun,qx2,qy2,qx1,qy1);
			else digdoplot(qbun,qx1,qy1,qx2,qy2);
			qbun = -1;
		}
		if (dx && dy) {		/* not worth queueing */
			if (reverse) digdoplot(bundle,x2,y2,x1,y1);
			else digdoplot(bundle,x1,y1,x2,y2);
		}
		else {
			qbun = bundle;			/* save this one */
			qreverse = reverse;
			qx1 = x1;
			qx2 = x2;
			qy1 = y1;
			qy2 = y2;
		}
	}
}

/* digdoplot -- routine that manages line drawing on different devices */
static int digdoplot(bundle,x1,y1,x2,y2)
int bundle,x1,y1,x2,y2;
{

	/* check for continuation of polyline */
	if ((bundle == oldbundle) && (x1 == digdata.xpen) && (y1 == digdata.ypen)) 
		/* build up chain of lines */
		digiplot(x2,y2);
	else {
		/* flush old chain */
		if (oldbundle >= 0) digflushs();
		
		/* start new chain */
		oldbundle = bundle;
		*plotptr++ = x1;	/* always do the first point */
		*plotptr++ = y1;
		digdata.xpen = x1;
		digdata.ypen = y1;
		digiplot(x2,y2);	/* check for duplication */
	}
	return(0);
}

/* digiplot -- strings plot lines together */
void digiplot(x,y)
int x,y;
{
	if ((plotptr[-2] != x) || (plotptr[-1] != y)) {	
		/* only plot real lines */
		*plotptr++ = x;
		*plotptr++ = y;
		if (plotptr >= plotbuff + PBLEN) digflush();
		digdata.xpen = x;
		digdata.ypen = y;
	}
}

/* digflush -- global routine to flush string of lines */
void	digflush()
{
	/* add queue to chain */
	if (qbun >= 0) {
		digdoplot(qbun,qx1,qy1,qx2,qy2);
		qbun = -1;
	}
	/* flush the lines */
	digflushs();
}

/* digflushs -- routine that actually flushes strings of lines */
static int digflushs()
{
	if (oldbundle < 0) {
		fflush(digdata.outfile);
		return(0);		/* something to plot */
	}

	/* check for plot of a single dot */
	if (plotptr == plotbuff + 2) {
		/* duplicate to make a short line */
		*plotptr++ = plotbuff[0];
		*plotptr++ = plotbuff[1];
	}

	/* send string of lines to appropriate device */
	(*digtable[digdata.select].polyline)(oldbundle,plotbuff,plotptr-plotbuff);
	
	/* re-init buffer */
	plotptr = plotbuff;
	oldbundle = -1;
	return(0);
}

#ifdef EMO
main()
{
	digstart(DIG_DEFAULT_TERM,NULL,0) ;
	digscale (4.0,4.0,0);
	digorigin(2.0,2.0);
	/* draw limit box */
	digline(20,-2.0,-2.0,-2.0,2.0);
	digline(20,-2.0,2.0,2.0,2.0);
	digline(20,2.0,2.0,2.0,-2.0);
	digline(20,2.0,-2.0,-2.0,-2.0);
	/* draw little box in top left corner */
	digline(20,-2.0,1.8,-1.8,1.8);
	digline(20,-1.8,1.8,-1.8,2.0);

	/* set clip region */
	digclip(-1.0,-1.0,1.0,1.0);
	
	/* draw clip limit */
	digline(20,-1.0,-1.0,-1.0,1.0);
	digline(20,-1.0,1.0,1.0,1.0);
	digline(20,1.0,1.0,1.0,-1.0);
	digline(20,1.0,-1.0,-1.0,-1.0);

	/* draw rotated rectangle */
	digline(21,-1.3,-0.6,-0.6,1.3);
	digline(21,-0.6,1.3,1.3,0.6);
	digline(21,1.3,0.6,0.6,-1.3);
	digline(21,0.6,-1.3,-1.3,-0.6);

	digquit(1);
}


/*
#include <stdio.h>
main()
{
	int i;
	static int xx[] =  {
		254,254,254,254,255,254,254,254,
		255,254,254,254,254,255,255,255,
		255,255,255,255	};
	static int yy[] =  {
		398,398,398,398,399,399,399,399,
		399,399,399,400,400,400,400,400,
		400,400,401,401,401,401	};
#define NXY (sizeof(xx)/sizeof(int))

	digstart('\0',NULL,1);
	digscale((float) (digdata.nhoriz - 1), (float) (digdata.nvert - 1),0);
	for (i=1; i<NXY; i++) digline(20,254.0,(float) yy[i-1],
	    (float) xx[i], (float) yy[i]);
	digquit(1);
}
*/
#endif
