/* digitlab -- y-axis labels display for digitem library */

/* version 1.0 - M.A.Huckvale - May 1988 */

#include <stdio.h>
#include <fcntl.h>
#include <string.h>
#include "dig.h"
#include "digdata.h"
#include "digitem.h"

int digitemlabel(bundles,iyb,iyt,labels,labfirst,labnum)
int32	bundles;	/* colours: 10000*divisions + 100*labels + title */
int	iyb,iyt;	/* pixel y values */
char	*labels;	/* labels, separated by "|" */
int	labfirst;	/* first label number */
int	labnum;		/* # label positions */
{
	int	i,ixm1,ixm2,step;
	double	scaley;
	int	x,y;
	float	digtextlen();
	char	*token,lab[16];

	/* calc "ixm1" - left of small markers */
	ixm1 = digitab.ixl + digitab.ixoff - digdata.chwidth/2;
	/* calc "ixm2" - left of medium markers */
	ixm2 = digitab.ixl + digitab.ixoff - digdata.chwidth;

	/* get scale factors */
	scaley = (double)(iyt-iyb)/labnum;

	token=strtok(labels,"|");
	if (*token=='x') {
		step=atoi(token+1);
		token = strtok(0,"|");
	}
	else
		step=1;
	for (i=0;i<labfirst;i+=step) token = strtok(0,"|");
	for (i=0;(token && (i < labnum));i+=step) {
		y = (int)(iyb + ((double)i+0.5)*scaley);
		diglinep(digitab.dbun,ixm1,y,digitab.ixl+digitab.ixoff,y);
		if (*token) {
			lab[7]='\0';
			strncpy(lab,token,8);
			if (lab[7] != '\0') {
				lab[7]='+';
				lab[8]='\0';
			}
			x = (int)(ixm2 - digtextlen(lab)*digdata.xscale);
			y = (int)(iyb + ((double)i+0.5)*scaley - digdata.chheight/2);
			digtextp(digitab.dbun,x,y,lab);
		}
		token=strtok(0,"|");
	}

	return(0);
}

#ifdef EMO
digitlab(bundles,xl,yb,xr,yt,labels,labnum)
int	bundles,labnum;
float	xl,yb,xr,yt;
char	*labels;
{
	/* sort out bundles */
	digitbundle(bundles);

	/* init box */
	digitbox(xl,yb,xr,yt,0.0,1.0,DIGITEMBOX);

	/* draw labeled axis */
	digitemlabel(bundles,digitab.iyb,digitab.iyt,labels,labnum);
}

main ()
{

	digstart('\0',NULL,1);
	digscale(100.0,100.0,0);
	digclearscreen();

	digitlab(222120,  0.0,  0.0, 20.0,100.0,"bottom|top",2);
	digitlab(222120, 20.0,  0.0, 40.0, 90.0,"1|2|3|4|5|6|7|8|9",9);
	digitlab(222120, 40.0,  0.0, 60.0, 80.0,"1|10|100|1000|10000|100000|1000000|10000000|100000000",9);
/*
	digitfreq(222120, 60.0,  0.0, 80.0, 70.0,1.65,10.2,1);
	digitfreq(222120, 80.0, 10.0,100.0, 60.0,9.5,10.0,1);
	digitfreq(222120, 80.0, 60.0,100.0, 80.0,0.0,2.0,1);
*/
	digquit(15);
}
#endif
