/*  Copyright (C) Hummingbird Communications Ltd. 1990-1992    */

#ifndef EXTEND_H
#define EXTEND_H

extern char *XGetDefault();	    /* just in case not defined via the next
				       include */

#include "X11/Xlibint.h"

#define  sz_xReadDOSDirReq	   (sizeof (xReadDOSDirReq))
#define  X_ReadDOSDir		   eXt_major_code
#define  ReadDOSDir_num 	   1

#define  sz_xOpenDOSFileReq	   (sizeof (xOpenDOSFileReq))
#define  X_OpenDOSFile		   eXt_major_code
#define  OpenDOSFile_num	   2

#define  sz_xCloseDOSFileReq	   (sizeof (xCloseDOSFileReq))
#define  X_CloseDOSFile 	   eXt_major_code
#define  CloseDOSFile_num	   3

#define  sz_xReadDOSFileReq	   (sizeof (xReadDOSFileReq))
#define  X_ReadDOSFile		   eXt_major_code
#define  ReadDOSFile_num	   4

#define  sz_xWriteDOSFileReq	   (sizeof (xWriteDOSFileReq))
#define  X_WriteDOSFile 	   eXt_major_code
#define  WriteDOSFile_num	   5

#define  sz_xMakeDOSDirReq	   (sizeof (xMakeDOSDirReq))
#define  X_MakeDOSDir		   eXt_major_code
#define  MakeDOSDir_num		   6

#define  sz_xRemoveDOSDirReq	   (sizeof (xRemoveDOSDirReq))
#define  X_RemoveDOSDir 	   eXt_major_code
#define  RemoveDOSDir_num	   7

#define  sz_xGetDOSDirReq	   (sizeof (xGetDOSDirReq))
#define  X_GetDOSDir		   eXt_major_code
#define  GetDOSDir_num		   8

#define  sz_xChangeDOSDriveReq	   (sizeof (xChangeDOSDriveReq))
#define  X_ChangeDOSDrive	   eXt_major_code
#define  ChangeDOSDrive_num 	   9

#define  sz_xChangeDOSDirReq	   (sizeof (xChangeDOSDirReq))
#define  X_ChangeDOSDir 	   eXt_major_code
#define  ChangeDOSDir_num	   10

#define  sz_xDelDOSFileReq	   (sizeof (xDelDOSFileReq))
#define  X_DelDOSFile		   eXt_major_code
#define  DelDOSFile_num 	   11

#define  sz_xRenDOSFileReq	   (sizeof (xRenDOSFileReq))
#define  X_RenDOSFile		   eXt_major_code
#define  RenDOSFile_num		   12

#define  sz_xStartDOSReq	   (sizeof (xStartDOSReq))
#define  X_StartDOS		   eXt_major_code
#define  StartDOS_num		   13

#define  sz_xDOSLogReq		   (sizeof (xStartDOSReq))
#define  X_DOSLog		   eXt_major_code
#define  DOSLog_num		   14

#define  sz_xDOSPushReq 	   (sizeof (xStartDOSReq))
#define  X_DOSPush		   eXt_major_code
#define  DOSPush_num		   15

#define sz_xGetDiskInfoReq	   (sizeof (xGetDiskInfoReq))
#define X_GetDiskInfo		   eXt_major_code
#define GetDiskInfo_num 	   16

#define sz_xSetFileAttrReq	   (sizeof (xSetFileAttrReq))
#define X_SetFileAttr		   eXt_major_code
#define SetFileAttr_num 	   17

#define sz_xTouchFileReq	   (sizeof (xTouchFileReq))
#define X_TouchFile		   eXt_major_code
#define TouchFile_num		   18

#define sz_xIdentReq		   (sizeof (xIdentReq))
#define X_Ident 		   eXt_major_code
#define Ident_num		   19

#define sz_xBlockDeviceVectorReq   (sizeof (xBlockDeviceVectorReq))
#define X_BlockDeviceVector	   eXt_major_code
#define BlockDeviceVector_num	   20

#define sz_xPCintReq		   (sizeof (xPCintReq))
#define X_PCint 		   eXt_major_code
#define PCint_num		   21


/***************/

typedef struct {
    CARD8 reqType;
    CARD8 minorCode;
    CARD16 length B16;
    CARD32 DOSid B32;
    CARD32 pad1 B32;
    CARD16 pad2 B16;
    CARD8 pad3;
    CARD8 pad4;
} xStartDOSReq;

typedef struct {
    CARD8 reqType;
    CARD8 minorCode;
    CARD16 length B16;
    CARD32 DOSid B32;
    CARD32 pad1 B32;
    CARD16 pad2 B16;
    CARD8 pad3;
    CARD8 pad4;
} xDOSPushReq;

typedef struct {
    CARD8 reqType;
    CARD8 minorCode;
    CARD16 length B16;
    CARD32 DOSid B32;
    CARD32 pad1 B32;
    CARD16 pad2 B16;
    CARD8 attribute;
    CARD8 pad3;
} xReadDOSDirReq;

typedef struct {
    CARD8 reqType;
    CARD8 minorCode;
    CARD16 length B16;
    CARD32 DOSid B32;
    CARD32 fid B32;
    CARD16 pad1 B16;
    CARD8 binary;
    CARD8 write;
} xOpenDOSFileReq;

typedef struct {
    CARD8 reqType;
    CARD8 minorCode;
    CARD16 length B16;
    CARD32 DOSid B32;
    CARD32 fid B32;
    CARD16 pad1 B16;
    CARD8 binary;
    CARD8 write;
} xCloseDOSFileReq;

typedef struct {
    CARD8 reqType;
    CARD8 minorCode;
    CARD16 length B16;
    CARD32 DOSid B32;
    CARD32 fid B32;
    CARD16 nbytes B16;
    CARD8 pad1;
    CARD8 pad2;
} xReadDOSFileReq;

typedef struct {
    CARD8 reqType;
    CARD8 minorCode;
    CARD16 length B16;
    CARD32 DOSid B32;
    CARD32 fid B32;
    CARD16 nbytes B16;
    CARD8 pad1;
    CARD8 pad2;
} xWriteDOSFileReq;

typedef struct {
    CARD8 reqType;
    CARD8 minorCode;
    CARD16 length B16;
    CARD32 DOSid B32;
    CARD32 pad1 B32;
    CARD16 pad2 B16;
    CARD8 pad3;
    CARD8 pad4;
} xMakeDOSDirReq;

typedef struct {
    CARD8 reqType;
    CARD8 minorCode;
    CARD16 length B16;
    CARD32 DOSid B32;
    CARD32 pad1 B32;
    CARD16 pad2 B16;
    CARD8 pad3;
    CARD8 pad4;
} xRemoveDOSDirReq;

typedef struct {
    CARD8 reqType;
    CARD8 minorCode;
    CARD16 length B16;
    CARD32 DOSid B32;
    CARD32 pad1 B32;
    CARD16 pad2 B16;
    CARD8 pad3;
    CARD8 pad4;
} xGetDOSDirReq;

typedef struct {
    CARD8 reqType;
    CARD8 minorCode;
    CARD16 length B16;
    CARD32 DOSid B32;
    CARD32 pad1 B32;
    CARD16 pad2 B16;
    CARD8 drivenum;
    CARD8 pad3;
} xChangeDOSDriveReq;

typedef struct {
    CARD8 reqType;
    CARD8 minorCode;
    CARD16 length B16;
    CARD32 DOSid B32;
    CARD32 pad1 B32;
    CARD16 pad2 B16;
    CARD8 pad3;
    CARD8 pad4;
} xChangeDOSDirReq;

typedef struct {
    CARD8 reqType;
    CARD8 minorCode;
    CARD16 length B16;
    CARD32 DOSid B32;
    CARD32 pad1 B32;
    CARD16 pad2 B16;
    CARD8 pad3;
    CARD8 pad4;
} xDelDOSFileReq;

typedef struct {
    CARD8 reqType;
    CARD8 minorCode;
    CARD16 length B16;
    CARD32 DOSid B32;
    CARD32 pad1 B32;
    CARD16 pad2 B16;
    CARD8 pad3;
    CARD8 pad4;
} xRenDOSFileReq;

typedef struct {
    CARD8 reqType;
    CARD8 minorCode;
    CARD16 length B16;
    CARD32 DOSid B32;
    CARD32 readpos B32;
    CARD16 nbytes B16;
    CARD8 pad3;
    CARD8 pad4;
} xDOSLogReq;

typedef struct {
    CARD8 type;
    CARD8 pad1;
    CARD16 sequenceNumber B16;
    CARD32 length B32;
    CARD32 nextpos B32;
    CARD16 errno B16;
    CARD16 size B16;
    CARD8 pad2[16];
} xDOSReply;

typedef struct {
    CARD8 type;
    CARD8 pad1;
    CARD16 sequenceNumber B16;
    CARD32 pad2 B32;
    CARD32 pad3 B32;
    CARD16 errno B16;
    CARD16 pad4 B16;
    CARD16 version B16;
    CARD8 pad5[14];
} xDOSPushReply;

typedef struct {
    CARD8 type;
    CARD8 next;
    CARD16 sequenceNumber B16;
    CARD32 length B32;
    CARD32 size B32;
    CARD16 errno B16;
    CARD16 time B16;
    CARD16 date B16;
    CARD8  attribute;
    CARD8  name[13];
} xDOSDirReply;

typedef struct {
    CARD8 reqType;
    CARD8 minorCode;
    CARD16 length B16;
    CARD32 DOSid B32;
    CARD32 pad1 B32;
    CARD16 pad2 B16;
    CARD8 drivenum;
    CARD8 pad3;
} xGetDiskInfoReq;

typedef struct {
    CARD8 type;
    CARD8 pad1;
    CARD16 sequenceNumber B16;
    CARD32 length B32;
    CARD32 freeSpace B32;
    CARD16 errno B16;
    CARD16 pad2 B16;
    CARD16 pad3 B16;
    CARD16 pad4 B16;
    CARD32 totalSpace B32;
    CARD8 pad5[8];
} xGetDiskInfoReply;

typedef struct {
    CARD8 reqType;
    CARD8 minorCode;
    CARD16 length B16;
    CARD32 DOSid B32;
    CARD32 pad1 B32;
    CARD16 pad2 B16;
    CARD8 attr;
    CARD8 pad3;
} xSetFileAttrReq;

typedef struct {
    CARD8 reqType;
    CARD8 minorCode;
    CARD16 length B16;
    CARD32 DOSid B32;
    CARD32 ymd B32;	    /* (year << 16) | (months << 8) | day */
    CARD16 hours B16;
    CARD8 mins;
    CARD8 secs;
} xTouchFileReq;

typedef struct {
    CARD8 reqType;
    CARD8 minorCode;
    CARD16 length B16;
    CARD32 DOSid B32;
    CARD32 pad1 B32;
    CARD16 pad2 B16;
    CARD8 pad3;
    CARD8 pad4;
} xIdentReq;

typedef struct {
    CARD8 type;
    CARD8 version;
    CARD16 sequenceNumber B16;
    CARD32 length B32;
    CARD32 pad1 B32;
    CARD16 errno B16;
    CARD16 userPathSize B16;
    CARD16 fileSystemSize B16;
    CARD8 pad2[14];
} xIdentReply;

typedef struct {
    CARD8 reqType;
    CARD8 minorCode;
    CARD16 length B16;
    CARD32 DOSid B32;
    CARD32 pad1 B32;
    CARD16 pad2 B16;
    CARD8 pad3;
    CARD8 pad4;
} xBlockDeviceVectorReq;

typedef struct {
    CARD8 type;
    CARD8 pad0;
    CARD16 sequenceNumber B16;
    CARD32 length B32;
    CARD32 vector B32;
    CARD16 errno B16;
    CARD16 pad1 B16;
    CARD16 pad2 B16;
    CARD8  pad3[14];
} xBlockDeviceVectorReply;

typedef struct {
    CARD8 reqType;
    CARD8 minorCode;
    CARD16 length B16;
    CARD32 DOSid B32;
    CARD32 dataLen B32;
    CARD16 control B16;
    CARD8 status;
    CARD8 func;
} xPCintReq;

typedef struct {
    CARD8 type;
    CARD8 pad0;
    CARD16 sequenceNumber B16;
    CARD32 length B32;
    CARD32 dataLen B32;
    CARD16 errno B16;
    CARD16 control B16;
    CARD8  status;
    CARD8  pad3[15];
} xPCintReply;



/*  structure used to represent an option */

struct OptionDef {
    char *name; 	    /* name of parm */
    short NeedText;	    /* true if must be followed by text */
    short found;	    /* flag to set if the option is found */
    char *data; 	    /* address of pointer to data if text is true */
};

/*  structure used to represent a DOS dir entry on a linked list */

struct linkage {
    xDOSDirReply r;
    struct linkage *next;
};

/*  maximum buffer size */

#define MAXBUF	8192
#define DEFBUF	1024

#define upper(c) (((c) >= 'a' && (c) <= 'z') ? ((c) - 'a' + 'A') : (c))
#define lower(c) (((c) >= 'A' && (c) <= 'Z') ? ((c) - 'A' + 'a') : (c))

#endif
