/* sfsclose -- close fid opened with sfsopen */

/* version 1.0 - August 1987 */

#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "sfs.h"
#include "sfsdata.h"

int	sfsclose(fid)
int		fid;
{
	/* check fid opened */
	if ((fid < 0) ||
	    (fid > MAXFILES) ||
	    (!sfsdata[fid]))
		return(-1);

	/* check no linked fids */
	if (sfsdata[fid]->lfid) sfsclose(sfsdata[fid]->lfid);

	/* lose sfsdata */
	free(sfsdata[fid]);
	sfsdata[fid]=NULL;

	/* close channel */
	return(close(fid));
}
