# Makefile for Speech Filing System
#
# Unix make and cc for Solaris
#
# Building Instructions:
# 1. set up machine configuration in include/SFSCONFG.h
# 2. set up SFS home directory and environment below
# 3. set up library lists for standard, graphics and audio below
# 4. make a 'bin' and 'lib' directory in home directory
# 5. type 'make -f makefile.unx' at top level directory for general compile
#
# change definition of SFS to base directory
SFS 	= /opt/sfs
#
# select make program
MAKE = make -f makefile.unx
# select C compiler
CC = gcc
# change definitions of CFLAGS and libraries
CFLAGS	= -g -I$(SFS)/include -I/usr/openwin/include -I/usr/demo/SOUND/include
# standard libraries
SLIB	= $(SFS)/lib/libdsp.a $(SFS)/lib/libsfs.a -lm
# audio libraries
ALIB	= -L/usr/openwin/lib -lX11 /usr/demo/SOUND/lib/libaudio.a -lm
# graphics libraries
GLIB	= $(SFS)/lib/libdigit.a $(SFS)/lib/libdig.a $(SFS)/lib/libsfs.a $(SFS)/lib/libdsp.a \
		-L/usr/openwin/lib -lX11
#
# make all components
all:	libsfs.ok libdig.ok libdigit.ok libdsp.ok util.ok ucl.ok \
	lang/sml.ok lang/spc.ok lang/span.ok \
	contrib/teach.ok contrib/ucl.ok contrib/asr.ok \
	contrib/kspan.ok contrib/htk.ok contrib/coch.ok
#
# separate components
DOMAKE	= $(MAKE) CC="$(CC)" CFLAGS="$(CFLAGS)" SFS="$(SFS)" SLIB="$(SLIB)" ALIB="$(ALIB)" GLIB="$(GLIB)"
libsfs.ok:
	@ cd libsfs ; $(DOMAKE)
libdig.ok:
	@ cd libdig ; $(DOMAKE) 
libdigit.ok:
	@ cd libdigit ; $(DOMAKE) 
libdsp.ok:
	@ cd libdsp ; $(DOMAKE) 
util.ok:
	@ cd util ; $(DOMAKE)
ucl.ok:
	@ cd ucl ; $(DOMAKE)
lang/sml.ok:
	@ cd lang/sml ; $(DOMAKE)
lang/spc.ok:
	@ cd lang/spc ; $(DOMAKE)
lang/span.ok:
	@ cd lang/span ; $(DOMAKE)
contrib/teach.ok:
	@ cd contrib/teach ; $(DOMAKE)
contrib/ucl.ok:
	@ cd contrib/ucl ; $(DOMAKE)
contrib/asr.ok:
	@ cd contrib/asr ; $(DOMAKE)
contrib/kspan.ok:
	@ cd contrib/kspan ; $(DOMAKE)
contrib/htk.ok:
	@ cd contrib/htk ; $(DOMAKE)
contrib/coch.ok:
	@ cd contrib/coch ; $(DOMAKE)
manpages:
	@ cd man; $(DOMAKE)

