/* srusyn11 -- filter definitions for 11kHz synthesizer */

#define SRATE	11000		/* sample rate */
#define CRATEF	2750		/* formant control rate */
#define CRATEX	1100		/* excitation control rate */
#define FRATE	100		/* frame rate */
#define FSAMP	110		/* # samples/frame */
#define CSAMP	51		/* # samples/control segment */

/* half a filter section */
#define HALFSECTION120(out,x0,x1,x2,b0,b1,b2) { \
	register float tmp; \
	tmp = x0 - b1 * x1; \
	out = x1 = tmp; \
}
#define HALFSECTION122(out,x0,x1,x2,b0,b1,b2) { \
	register float tmp; \
	tmp = x0 - b1 * x1 - b2 * x2; \
	x2 = x1; \
	out = x1 = tmp; \
}
#define HALFSECTION222(out,x0,x1,x2,b0,b1,b2) { \
	register float tmp; \
	tmp = b0 * x0 - b1 * x1 - b2 * x2; \
	x2 = x1; \
	out = x1 = tmp; \
}

/* full filter section */
#define SECTION12020(out,x0,x1,x2,b0,b1,b2,a1,a2) {\
	register float tmp; \
	tmp = x0 - b1 * x1; \
	out = tmp + a1 * x1; \
	x1 = tmp; \
}
#define SECTION12221(out,x0,x1,x2,b0,b1,b2,a1,a2) {\
	register float tmp; \
	tmp = x0 - b1 * x1 - b2 * x2; \
	out = tmp + a1 * x1 + x2; \
	x2 = x1; \
	x1 = tmp; \
}
#define SECTION122_10(out,x0,x1,x2,b0,b1,b2,a1,a2) {\
	register float tmp; \
	tmp = x0 - b1 * x1 - b2 * x2; \
	out = tmp - x1; \
	x2 = x1; \
	x1 = tmp; \
}
#define SECTION222_10(out,x0,x1,x2,b0,b1,b2,a1,a2) {\
	register float tmp; \
	tmp = b0 * x0 - b1 * x1 - b2 * x2; \
	out = tmp - x1; \
	x2 = x1; \
	x1 = tmp; \
}
#define SECTION22221(out,x0,x1,x2,b0,b1,b2,a1,a2) {\
	register float tmp; \
	tmp = b0 * x0 - b1 * x1 - b2 * x2; \
	out = tmp + a1 * x1 + x2; \
	x2 = x1; \
	x1 = tmp; \
}
#define SECTION200_10(out,x0,x1,x2,b0,b1,b2,a1,a2) {\
	register float tmp; \
	tmp = b0 * x0; \
	out = tmp - x1; \
	x1 = tmp; \
}
#define SECTION22022(out,x0,x1,x2,b0,b1,b2,a1,a2) {\
	register float tmp; \
	tmp = b0 * x0 - b1 * x1; \
	out = tmp + a1 * x1 + a2 * x2; \
	x2 = x1; \
	x1 = tmp; \
}
#define SECTION22222(out,x0,x1,x2,b0,b1,b2,a1,a2) {\
	register float tmp; \
	tmp = b0 * x0 - b1 * x1 - b2 * x2; \
	out = tmp + a1 * x1 + a2 * x2; \
	x2 = x1; \
	x1 = tmp; \
}

/* Excitation control smoothing filter */
#define EXCF(out,x0,x1,x2) \
	HALFSECTION222(out,x0,x1,x2,0.005906528,-1.8462921,0.8521986)

/* Formant control smoothing filter */
#define FCSF(out,x0,x1,x2) \
	HALFSECTION222(out,x0,x1,x2,0.01036742,-1.7963590,0.8067264)

/* Voiced excitation low pass filters */
#define VELPF1(out,x0,x1,x2) \
	SECTION22221(out,x0,x1,x2,0.0109455,-1.5453652,0.9386455,-1.2804510,1.0)
#define VELPF2(out,x0,x1,x2) \
	SECTION12221(out,x0,x1,x2,1.0,-1.5368902,0.7920242,-0.9188553,1.0)
#define VELPF3(out,x0,x1,x2) \
	SECTION12221(out,x0,x1,x2,1.0,-1.5652816,0.6434150,1.4773386,1.0)
#define VELPF4(out,x0,x1) \
	SECTION12020(out,x0,x1,0.0,1.0,-0.9988583,0.0,-0.9126601,0.0)

/* Output weighting filter */
#define OWF1(out,x0,x1,x2) \
	SECTION22221(out,x0,x1,x2,0.18,1.6282390,0.9006455,1.9286317,1.0)
#define OWF2(out,x0,x1,x2) \
	SECTION12221(out,x0,x1,x2,1.0,1.2842269,0.6567826,1.9901074,1.0)
#define OWF3(out,x0,x1,x2) \
	SECTION12221(out,x0,x1,x2,1.0,0.5930815,0.3196004,1.8350098,1.0)
#define OWF4(out,x0,x1,x2) \
	SECTION12221(out,x0,x1,x2,1.0,-0.2742624,0.0759047,-0.1497423,1.0)
#define OWF5(out,x0,x1) \
	HALFSECTION120(out,x0,x1,x2,1.0,-0.6938031,0.0)

/* mixing filters */
#define MIXF1(out,x0,x1,x2) \
	SECTION22022(out,x0,x1,x2,0.3946751,-0.8570803,0.0,-1.8605548,0.8094960)
#define MIXF2(out,x0,x1) \
	SECTION200_10(out,x0,x1,x2,0.5051416,0.0,0.0,1.0,0.0)
#define MIXF3(out,x0,x1) \
	SECTION200_10(out,x0,x1,x2,0.5051416,0.0,0.0,1.0,0.0)
#define MIXF4V(out,x0,x1,x2) \
	SECTION222_10(out,x0,x1,x2,0.2084334,1.3144111,0.7957426,1.0,0.0)
#define MIXF4UV1(out,x0,x1,x2) \
	SECTION22222(out,x0,x1,x2,0.1330524,0.7021969,0.6332063,0.7604341,0.8377198)
#define MIXF4UV2(out,x0,x1,x2) \
	SECTION122_10(out,x0,x1,x2,1.0,0.5171979,0.8425185,1.0,0.0)
#define MIXF4UV3(out,x0,x1,x2) \
	HALFSECTION122(out,x0,x1,x2,1.0,1.0790422,0.8425185)



