/* wadcli - Win audio client - command-line version */

/* Mark Huckvale - University College London */

/* version 1.0 - April 1997 */

#define PROGNAME "wadcli"
#define PROGVERS "1.0"
char *progname=PROGNAME;

#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <errno.h>
#include <fcntl.h>
#include <signal.h>
#include <string.h>
#include <sys/stat.h>
#include <errno.h>

#define SOCKET int
#define INVALID_SOCKET -1
#define SOCKET_ERROR -1
#define closesocket close
int WSAGetLastError() { return errno; }
#define REVERSE(x) (((x & 0xFF000000)>>24)|((x&0xFF0000)>>8)|((x&0xFF00)<<8)|((x&0xFF)<<24))

/* transfer block size */
#define WAD_BUFF_SIZE	4000

/* transfer block magic number */
#define WAD_XFER_MAGIC	0x7761642E

/* transfer block */
struct wad_xfer_rec {
	int		magic;			/* magic number */
	int		totbytes;		/* total # bytes in payload */
	int		srate;			/* sample rate */
	int		nbyte;			/* number bytes/sample */
	int		nchan;			/* number channels */
	int		flags;			/* flags */
	unsigned char buff[WAD_BUFF_SIZE];
};

#ifdef __STDC__
void swapbuf(unsigned char *buf,int len)
#else
void swapbuf(buf,len)
unsigned char *buf;
int len;
#endif
{
	int	i;
	unsigned char b;
	
	for (i=0;i<len;i=i+2) {
		b = *buf;
		*buf = *(buf+1);
		*(buf+1) = b;
		buf+=2;
	}
}

#ifdef __STDC__
int sendblock(SOCKET s,unsigned char *buf,int len)
#else
int sendblock(s,buf,len)
SOCKET s;unsigned char *buf;int len;
#endif
{
	int	cnt;
	int	tot=0;

	while (len>0) {
		cnt = send(s,buf,len,0);
		if (cnt < 0)
			return(cnt);
		else {
			buf += cnt;
			len -= cnt;
			tot += cnt;
		}
	}
	return(tot);
}

#ifdef __STDC__
int process(char *name,FILE *ip,int srate,int nbyte,int nchan)
#else
int process(name,ip,srate,nbyte,nchan)
char *name;FILE *ip;int srate;int nbyte;int nchan;
#endif
{
	struct hostent	*hp,def;
	struct in_addr defaddr;
	char	*alist[1];
	struct servent *sp;
	struct sockaddr_in sin;
	SOCKET	s;
	struct wad_xfer_rec wxr;
	int		len;

	signal(SIGPIPE,SIG_IGN);
	
	/* get host IP address */
	if (!(hp=gethostbyname(name))) {
		defaddr.s_addr = inet_addr(name);
		if (defaddr.s_addr == -1) {
			fprintf(stderr,"unknown host: '%s'\n",name);
			return(1);
		}
		def.h_name = name;
		def.h_addr_list = alist;
		def.h_addr = (char *)&defaddr;
		def.h_length = sizeof(struct in_addr);
		def.h_addrtype = AF_INET;
		def.h_aliases = 0;
		hp = &def;
	}

	/* get finger daemon address */
	if (!(sp = getservbyname("finger","tcp"))) {
		fprintf(stderr,"finger: unknown service\n");
		return(1);
	}

	/* open socket */
	sin.sin_family = hp->h_addrtype;
	memcpy((char *)&sin.sin_addr, hp->h_addr, hp->h_length);
	sin.sin_port = sp->s_port;
	if ((s = socket(hp->h_addrtype,SOCK_STREAM,0)) == INVALID_SOCKET) {
		fprintf(stderr,"socket error %d\n",WSAGetLastError());
		return(1);
	}

	/* make connections */
/*	printf("[%s]\n",hp->h_name); */
	if (connect(s,(struct sockaddr *)&sin,sizeof(sin)) == SOCKET_ERROR) {
		fprintf(stderr,"connect error %d\n",WSAGetLastError());
		closesocket(s);
		return(1);
	}

	/* send data */
	while ((len=fread(wxr.buff,1,WAD_BUFF_SIZE,ip))>0) {
#if SFSMACHINE==0
		wxr.magic = REVERSE(WAD_XFER_MAGIC);
		wxr.totbytes = REVERSE(len);
		wxr.srate = REVERSE(srate);
		wxr.nbyte = REVERSE(nbyte);
		wxr.nchan = REVERSE(nchan);
		swapbuf(wxr.buff,len);
#else
		wxr.magic = WAD_XFER_MAGIC;
		wxr.totbytes = len;
		wxr.srate = srate;
		wxr.nbyte = nbyte;
		wxr.nchan = nchan;
#endif

		if (sendblock(s,(char *)&wxr,sizeof(wxr))!=sizeof(wxr)) {
			fprintf(stderr,"socket write error\n");
			closesocket(s);
			return(1);
		}

	}

	/* and exit */
	closesocket(s);
	return(0);
}

/* main program */
#ifdef __STDC__
void main(int argc,char **argv)
#else
void main(argc,argv)
int argc;char **argv;
#endif
{
	extern char	*optarg;
	extern int	optind;
	int		c,errflg=0;
 
	char		hostname[256];
	int		srate=20000;
	int		nbyte=2;
	int		nchan=1;
	FILE		*ip;
	char		*p;
	
	if ((p=getenv("DISPLAY"))!=NULL) strcpy(hostname,p);
	if ((p=strchr(hostname,':'))!=NULL) *p='\0';

	while ((c=getopt(argc,argv,"I:r:c:h:"))!=EOF) switch (c) {
	case 'I':
		fprintf(stderr,"%s: Win32 Audio Replay Client Vs%s\n",
			PROGNAME,PROGVERS);
		exit(0);
	case 'r':
		srate = atoi(optarg);
		break;
	case 'c':
		nchan = atoi(optarg);
		break;
	case 'h':
		strcpy(hostname,optarg);
		break;
	default:
		errflg++;
	}
	if (errflg)
		error("usage: %s (-h hostname) (-r rate) (-c chan) (rawfile)",PROGNAME);
		
	/* process file or standard input */
	if (optind < argc) {
		if ((ip=fopen(argv[optind],"rb"))==NULL)
			error("could not open '%s'",argv[optind]);
		process(hostname,ip,srate,nbyte,nchan);
		fclose(ip);
	}
	else
		process(hostname,stdin,srate,nbyte,nchan);

	exit(0);
}
