/* patch -- utility to patch item headers */

/* m.a. huckvale - february 1988 */

/* version 1.0 */

/*--------------------------------------------------------------------------*/
/**MAN
.TH PATCH SFS8 UCL
.SH NAME
patch - utility to patch fields in item headers
.SH SYNOPSIS
.B patch
-i item [patch options] file
.SH DESCRIPTION
.I patch
is a specialist utility to patch fields in item headers.  It may be of
use in saving data from otherwise corrupt files, or allowing re-use
of data without re-calculation, merely to correct some minor fault.
.PP
WARNING: It is possible to corrupt files with this utility.
.PP
.I Options
and their meanings are:
.TP 16
.B -I
Identify program and exit.
.TP 16
.BI -i item
Item number of data set to be patched.
.TP 16
.BI -h history
New text for history field.
.TP 16
.BI -p params
New text for params field.
.TP 16
.BI -o itemno
New datatype and subtype for item.
.TP 16
.BI -f floating
New value for "floating" flag.
.TP 16
.BI -D datasize
New datasize field.
.TP 16
.BI -F framesize
New framesize value.
.TP 16
.BI -n numframes
New numframes value.
.TP 16
.BI -d frameduration
New frameduration value.
.TP 16
.BI -P datapresent
New datapresent flag value.
.TP 16
.BI -O offset
New offset value.
.TP 16
.BI -c comment
New comment text.
.TP 16
.BI -w windowsize
Mew windowsize value.
.TP 16
.BI -v overlap
new overlap value.
.TP 16
.BI -l lxsync
New value for "lxsync" flag.
.TP 16
.BI -m machine
New value for machine type, 0=big endian, 1=little endian.
.SH VERSION/AUTHOR
1.0 - Mark Huckvale
.SH BUGS
Cannot change processdate or length fields.
*/
/*--------------------------------------------------------------------------*/

#define PROGNAME "patch"
#define PROGVERS "1.0"
char	*progname=PROGNAME;

/* global declarations */
#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include "sfs.h"
#include "sfsdata.h"
#define FALSE	0
#define TRUE	1

/* global data */
struct item_header item;

/* program parameters */
struct {
	int	change;
	char	*value;
} history,PARAMS,comment;
struct {
	int	change;
	int32	value;
} datatype,subtype,floating,datasize,framesize,
  numframes,datapresent,windowsize,overlap,lxsync,machine;
struct {
	int	change;
	double	value;
} frameduration,offset;

/* main program */
void main(argc,argv)
int argc;
char *argv[];
{
	/* option decoding */
	extern int	optind;
	extern char	*optarg;
	int		errflg=0;
	int		intype=0;
	char		*ty,*insubtype="0";
	char		c;
	double		atof();
	/* file variables */	
	char		filename[SFSMAXFILENAME];
	int		fid,ofid;

	/* decode switches */
	while ( (c = getopt(argc,argv,"Ii:h:p:o:f:D:F:n:d:P:O:c:w:v:l:m:")) != EOF )
		switch (c) {
		case 'I' :	/* Identify */
			fprintf(stderr,"%s: patch item headers V%s\n",PROGNAME,PROGVERS);
			exit(0);
			break;
		case 'i' : 	/* item number */
			if (itspec(optarg,&intype,&insubtype) != 0)
				error("illegal item specifier %s",optarg);
			break;
		case 'h' :	/* new history */
			history.change=TRUE;
			history.value=optarg;
			break;
		case 'p' :	/* new params field */
			PARAMS.change=TRUE;
			PARAMS.value=optarg;
			break;
		case 'o' :	/* new item number */
			if (itspec(optarg,&datatype.value,&ty) != 0)
				error("illegal item specifier %s",optarg);
			datatype.change=TRUE;
			subtype.change=TRUE;
			subtype.value=atoi(ty);
			break;
		case 'f' : 	/* new floating flag */
			floating.change=TRUE;
			floating.value=atoi(optarg);
			break;
		case 'D':	/* new datasize value */
			datasize.change=TRUE;
			datasize.value=atoi(optarg);
			break;
		case 'F':	/* new framesize value */
			framesize.change=TRUE;
			framesize.value=atoi(optarg);
			break;
		case 'n':	/* new numframes value */
			numframes.change=TRUE;
			numframes.value=atoi(optarg);
			break;
		case 'd':	/* new frameduration value */
			frameduration.change=TRUE;
			frameduration.value=atof(optarg);
			break;
		case 'P':	/* new data present flag */
			datapresent.change=TRUE;
			datapresent.value=atoi(optarg);
			break;
		case 'O':	/* new offset value */
			offset.change=TRUE;
			offset.value=atof(optarg);
			break;
		case 'c':	/* new comment */
			comment.change=TRUE;
			comment.value=optarg;
			break;
		case 'w':	/* new windowsize value */
			windowsize.change=TRUE;
			windowsize.value=atoi(optarg);
			break;
		case 'v':	/* new overlap value */
			overlap.change=TRUE;
			overlap.value=atoi(optarg);
			break;
		case 'l':	/* new lxsync value */
			lxsync.change=TRUE;
			lxsync.value=atoi(optarg);
			break;
		case 'm':	/* new machine value */
			machine.change=TRUE;
			machine.value=atoi(optarg);
			break;
		case '?' :	/* unknown */
			errflg++;
	}
	if (errflg || (argc<3))
		error("usage: %s (-I) -i item (-h history) (-p params) (-o item) (-f floating) (-D datasize) (-F framesize) (-n numframes) (-d frameduration) (-O offset) (-c comment) (-w windowsize) (-v overlap) (-l lxsync) (-m machine) file",PROGNAME);

	/* check item type was given */
	if (intype==0)
		error("no item selected",NULL);

	/* get filename */
	if (optind < argc)
		strcpy(filename,sfsfile(argv[optind]));
	else
		error("no data file specified",NULL);

	/* open datafile */
	if ((fid=sfsopen(filename,"w",NULL)) < 0) {
		if (fid==-1)
			error("cannot find file '%s'",filename);
		else
			error("access error on '%s'",filename);
	}

	/* locate input item */
	if (!sfsitem(fid,intype,insubtype,&item))
		error("unable to find input item in '%s'",filename);

	/* open file for update at item header location */
#ifdef DOS
	if ((ofid=open(filename,O_RDWR | O_BINARY)) < 0)
#else
	if ((ofid=open(filename,O_RDWR)) < 0)
#endif
		error("unable to open '%s' for update",filename);
	lseek(ofid,sfsdata[fid]->datastart-sizeof(struct item_header),0);

	/* fix header as specification */
	/* strings */
	if (history.change) strncpy(item.history,history.value,256);
	if (PARAMS.change) strncpy(item.params,PARAMS.value,128);
	if (comment.change) strncpy(item.comment,comment.value,20);

	/* integers */
	if (datatype.change) item.datatype=datatype.value;
	if (subtype.change) item.subtype=subtype.value;
	if (floating.change) item.floating=floating.value;
	if (datasize.change) item.datasize=datasize.value;
	if (framesize.change) item.framesize=framesize.value;
	if (numframes.change) item.numframes=numframes.value;
	if (datapresent.change) item.datapresent=datapresent.value;
	if (windowsize.change) item.windowsize=windowsize.value;
	if (overlap.change) item.overlap=overlap.value;
	if (lxsync.change) item.lxsync=lxsync.value;
	if (machine.change) item.machine=machine.value;
	item.machine = ((item.machine & 0xFF)<<24) + ((item.machine & 0xFF)<<16) + ((item.machine & 0xFF)<<8) + (item.machine & 0xFF);

	/* doubles */
	if (frameduration.change) item.frameduration=frameduration.value;
	if (offset.change) item.offset=offset.value;

	/* write header back */
#if defined(SUN4) || defined(HP)
	sun4unswap((int32 *)&item);
#endif
	if (write(ofid,&item,sizeof(struct item_header)) != sizeof(struct item_header))
		error("write error on '%s'",filename);

	/* close and exit */
	close(ofid);
	sfsclose(fid);
	exit(0);
}
