/* dbits -- database file access routines for SML */

/* global declarations */
#include "SFSCONFG.h"
#include <stdio.h>
#include "sml.h"

/* open file and load main header */
int opendbfile(f,clr)
char	*f;	/* filename */
int	clr;	/* clear sub types flag */
{
	int	i;

	/* open sfs file */
	strcpy(dbfilename,f);
	if ((dbfid=sfsopen(dbfilename,"r",&head)) < 0) {
		if (filereport) {
			if (dbfid==-1)
				fprintf(stderr,"%s: unable to open %s\n",progname,f);
			else
				fprintf(stderr,"%s: access error on %s\n",progname,f);
		}
		return(1);
	}

	/* initialise sub-types to command line specs */
	if (clr) for (i=1;i<=MAXDATATYPE;i++) ittype[i] = cltype[i];
	return(0);
}

/* load annotations */
int loadann()
{
	struct an_rec	*annot;
	int		i;
	double		fdur;

	if (dbitem[AN_TYPE].load == 0) {
		if (sfsitem(dbfid,AN_TYPE,(ittype[AN_TYPE])?ittype[AN_TYPE]:"*",
			&dbitem[AN_TYPE].item)) {
			ittype[AN_TYPE]=dbitem[AN_TYPE].item.history;
			annot = (struct an_rec *) sfsbuffer(&dbitem[AN_TYPE].item,1);
			anntab = (struct anntab_entry *) Calloc(dbitem[AN_TYPE].item.numframes,sizeof(struct anntab_entry));
			anncnt=0;
			fdur=dbitem[AN_TYPE].item.frameduration;
			for (i=0;sfsread(dbfid,i,1,annot);i++) {
				anntab[anncnt].time=annot->posn*fdur;
				anntab[anncnt].length=annot->size*fdur;
				anntab[anncnt].ann=(char *) Malloc(strlen(annot->label)+1);
				strcpy(anntab[anncnt].ann,annot->label);
				anncnt++;
			}
			Free((char *)annot);
			dbitem[AN_TYPE].load++;
			/* post-process annotation intervals */
			for (i=0;i<anncnt-1;i++) {
				if ((anntab[i].time + anntab[i].length) >= anntab[i+1].time)
					anntab[i].length = 0.999999*(anntab[i+1].time - anntab[i].time);
			}
			return(0);
		}
		return(1);
	}
	return(0);
}

/* locate subtype of next item of given type */
int loadnextit(it,ty)
int	it;
int	ty;
{
	int	i;
	struct item_header item;

	i = sfsitem(dbfid,0,"*",&item);
	while (i) {
		if ((item.datatype==it) && (item.subtype>ty)) {
			unloadit(it);
			ittype[it]=item.history;
			return(loadit(it));
		}
		i = sfsnextitem(dbfid,&item);
	}
	return(1);
}

/* load item from file */
int loadit(it)
int	it;
{
	/* check correct item not already loaded */
	if (dbitem[it].load) {
		if (ittype[it]==dbitem[it].item.history)
			return(0);
		else
			unloadit(it);
	}
	/* load item */
	if (it==AN_TYPE)
		return(loadann());
	else if ((it==LX_TYPE) || (it==WD_TYPE) || 
		 (it==DI_TYPE) || (it==EN_TYPE) || 
		 (it==PC_TYPE)) {
		if (!sfsitem(dbfid,it,(ittype[it])?ittype[it]:"*",&dbitem[it].item))
			return(1);
		dbitem[it].u.ptr = NULL;
		dbitem[it].load++;
	}
	else {
		if (!sfsitem(dbfid,it,(ittype[it])?ittype[it]:"*",&dbitem[it].item))
			return(1);
		if ((dbitem[it].u.ptr = sfsbuffer(&dbitem[it].item,dbitem[it].item.numframes))==NULL) {
			runtimewarning("cannot get buffer for item in '%s'",dbfilename);
			return(1);
		}
		if (sfsread(dbfid,0,dbitem[it].item.numframes,dbitem[it].u.ptr)!=dbitem[it].item.numframes) {
			runtimewarning("read error for item in '%s'",dbfilename);
			return(1);
		}
		dbitem[it].load++;
	}
	ittype[it]=dbitem[it].item.history;
	return(0);
}

/* unload an item */
void unloadit(it)
int	it;
{
	int	i;
	if (!dbitem[it].load) return;
	if (it==AN_TYPE) {
		for (i=0;i<anncnt;i++) Free(anntab[i].ann);
		anncnt=0;
		Free((char *)anntab);
	}
	else {
		if (dbitem[it].u.ptr) Free(dbitem[it].u.ptr);
	}
	if (ittype[it]==dbitem[it].item.history) ittype[it]=NULL;
	strcpy(dbitem[it].item.history,"");
	dbitem[it].load=0;
}

/* load phonetic dictionary */
int loadlpdict()
{
	FILE	*ip;
	int	i;

	if (lpdictload == 0) {
		ip = fopen(dictionary,"r");
		if (ip == NULL) 
			error("unable to access phonetic dictionary: %s",dictionary);
		fscanf(ip,"%d",&lpdictlen);
		if ((lpdictlen <= 0) || (lpdictlen > MAXATTR))
			error("error reading phonetic dictionary: %s",dictionary);
		for (i=0;i<lpdictlen;i++) {
			fscanf(ip,"%s%*d%*d%*d%*d%lf%lf\n",lpdict[i].aname,&(lpdict[i].A),&(lpdict[i].B));
			if ((strcmp(lpdict[i].aname,"") == 0) || (lpdict[i].A == 0.0))
				error("error reading phonetic dictionary: %s",dictionary);
		}
		lpdictload++;
	}
	return(0);
}
	
/* close a database file */
void closedbfile()
{
	int	i;

	/* unload everything */
	for (i=1;i<=MAXDATATYPE;i++) unloadit(i);

	/* close the file */
	sfsclose(dbfid);
}

