program fftest;

{$I tools.inc }
{$I dft.inc }

var
	fname:string;
	wv:waveform;
	rwv:realwave;
	spect:realspectrum;
	i,len:integer;

begin
	write(error,'Enter SFS filename : ');
	readln(fname);
	if not SFSFile(fname) then
		abort('not an SFS file');
	if not SFSItem('sp') then
		abort('no speech item');

	wv := SpeechPart(SpeechSize div 2,127+SpeechSize div 2);
	rwv := HammingWindow(wv);
	len := DFT(rwv,128,spect);	

	for i:=0 to len - 1 do 
		writeln(round(0.5*i*wv._rate/len),trunc(20*log10(spect[i])));
	writeln;

end.
