function ilist=sfsfile(fname,func)
% SFSFILE performs file level operations on an SFS file.
%
%   ilist=SFSFILE('file.sfs') will return a list of the item numbers
%   of the data sets present in file.sfs.  These numbers may be used
%   to read the data sets using the function SFSGETITEM. If the file
%   does not exist an error code is returned.  If the file is empty,
%   a zero-length array is returned.
%
%   status=SFSFILE('file.sfs','create') will attempt to create a
%   new SFS file called file.sfs.  If the file already exists, an 
%   error is returned.
%
%   status=SFSFILE('file.sfs','empty') will empty file.sfs of all its
%   current contents.  The main file header is retained.
%
%   See also: SFSFILE(), SFSGETITEM(), SFSNEWITEM(), SFSPUTITEM()
