/* output -- 'C' code generation for SPC */

/* Mark Huckvale - University College London - April 1991 */

/* external definitions */
#include "SFSCONFG.h"
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include <malloc.h>
#include "spc.h"

/* global output file */
extern FILE *op;

/* output buffering */
#define SIZE_STRING_STACK 32
struct string_rec {
	char			*str;
	struct string_rec	*next;
} *sstack[SIZE_STRING_STACK];
int	sstackptr;
struct string_rec *sstacklast[SIZE_STRING_STACK];
static int	suspend=0;

/* suspend output */
void outputoff()
{
	suspend++;
}
void outputon()
{
	suspend--;
}

/* push buffering */
void pushoutputbuffer()
{
	sstackptr++;
	if (sstackptr >= SIZE_STRING_STACK)
		spcerror("output stack overflow",NULL);
	sstacklast[sstackptr] = NULL;
}

/* pop buffering */
void popoutputbuffer()
{
	struct string_rec *s,*t;

	s = sstack[sstackptr];
	sstack[sstackptr]=NULL;
	sstackptr--;
	if (sstackptr < 0)
		spcerror("output stack underflow",NULL);
	else if (sstackptr==0) {
		/* copy to output */
		while (s) {
			fputs(s->str,op);
			t = s;
			s = s->next;
			free(t->str);
			free(t);
		}
		sstacklast[sstackptr+1]=NULL;
	}
	else {
		/* copy up one level */
		if (sstacklast[sstackptr])
			sstacklast[sstackptr]->next = s;
		else
			sstack[sstackptr] = s;
		sstacklast[sstackptr] = sstacklast[sstackptr+1];
		sstacklast[sstackptr+1]=NULL;
	}
}

/* kill current buffer */
void killoutputbuffer() 
{
	struct string_rec *s,*t;

	s = sstack[sstackptr];
	sstack[sstackptr]=NULL;
	sstackptr--;
	if (sstackptr < 0)
		spcerror("output stack underflow",NULL);
	else {
		/* kill output */
		while (s) {
			t = s;
			s = s->next;
			free(t->str);
			free(t);
		}
		sstacklast[sstackptr+1]=NULL;
	}
}

void swapoutputbuffer()
{
	struct string_rec *temp;

	temp=sstack[sstackptr];
	sstack[sstackptr] = sstack[sstackptr-1];
	sstack[sstackptr-1] = temp;

	temp=sstacklast[sstackptr];
	sstacklast[sstackptr] = sstacklast[sstackptr-1];
	sstacklast[sstackptr-1] = temp;
}

void rot3outputbuffer()
{
	struct string_rec *temp;

	temp=sstack[sstackptr-2];
	sstack[sstackptr-2] = sstack[sstackptr-1];
	sstack[sstackptr-1] = sstack[sstackptr];
	sstack[sstackptr] = temp;

	temp=sstacklast[sstackptr-2];
	sstacklast[sstackptr-2] = sstacklast[sstackptr-1];
	sstacklast[sstackptr-1] = sstacklast[sstackptr];
	sstacklast[sstackptr] = temp;
}

/* do output buffering */
void outputstr(s)
char	*s;
{
	char	*strsave();

	if (suspend)
		/* do nothing */;
	else if (sstackptr==0) {
		if (!s || !*s)
			fputs("<<NULL>>",op);
		else
			fputs(s,op);
	}
	else if (sstacklast[sstackptr]) {
		if ((sstacklast[sstackptr]->next =
		    (struct string_rec *)malloc(sizeof(struct string_rec)))==NULL)
			spcerror("out of memory",NULL);
		sstacklast[sstackptr] = sstacklast[sstackptr]->next;
		if (!s || !*s)
			sstacklast[sstackptr]->str = strsave("<<NULL>>");
		else
			sstacklast[sstackptr]->str = strsave(s);
		sstacklast[sstackptr]->next = NULL;
	}
	else {
		if ((sstack[sstackptr] = (struct string_rec *)malloc(sizeof(struct string_rec)))==NULL)
			spcerror("out of memory",NULL);
		sstacklast[sstackptr] = sstack[sstackptr];
		if (!s || !*s)
			sstacklast[sstackptr]->str = strsave("<<NULL>>");
		else
			sstacklast[sstackptr]->str = strsave(s);
		sstacklast[sstackptr]->next = NULL;
	}
}

static char	temp[1024];
void output(str)
char	*str;
{
	sprintf(temp,"%s ",str);
	outputstr(temp);
}

void outputint(val)
int	val;
{
	sprintf(temp,"%d",val);
	outputstr(temp);
}

void outputcstring(str)
char	*str;
{
	char	*p;
	p=temp;
	*p++ ='"';
	while (*str) {
		if ((*str=='"') || (*str=='\\'))
			*p++ = '\\';
		*p++ = *str++;
	}
	*p++ ='"';
	*p='\0';
	outputstr(temp);
}

/* print current input line number */
void fileline(lineno)
int	lineno;
{
	extern char	filename[];
	char		buf[128];

	if (lineno==0) lineno=1;
	sprintf(buf,"\n#line %d \"%s\"\n",lineno,filename);
	outputstr(buf);
}

/* print a procedure break line */
void procomment(title)
char *title;
{
	int	len;
	int	i;
	len = (72-strlen(title))/2;
	outputstr("\n/*");
	for (i=0;i<len;i++) outputstr("-");
	outputstr(" ");
	outputstr(title);
	outputstr(" ");
	for (i=0;i<len;i++) outputstr("-");
	outputstr("*/\n");
}

/* print a comment */
#ifdef __STDC__
#include <stdarg.h>
void comment(char *fmt,...)
{
	va_list		arg_ptr;
	
	/* print message */
	outputstr(" /* ");
	va_start(arg_ptr,fmt);
	vsprintf(temp,fmt,arg_ptr);
	va_end(arg_ptr);
	outputstr(temp);
	outputstr(" */ ");
}
#else
#include <varargs.h>
comment(va_alist)
va_dcl
{
	va_list		arg_ptr;
	char		*fmt;
	
	/* print message */
	outputstr(" /* ");
	va_start(arg_ptr);
	fmt = va_arg(arg_ptr,char *);
	vsprintf(temp,fmt,arg_ptr);
	va_end(arg_ptr);
	outputstr(temp);
	outputstr(" */ ");
}
#endif

