/* spc.y -- yacc description for SPC */
/* version 1.0 */

%{
#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#if (defined(DJGPP1) || defined(DJGPP2) || defined(MSC32))
#include <process.h>
#endif
#include "spc.h"

/* global decoding states */
int32	enumcnt;
short	basetype;
Symbol *Filevar;
Symbol *basesym[3];
int	basecnt;
extern int lno;

/* context control */
Symbol *context,*constack[32];
int	parmnostack[32];
int	basecntstack[32];
int	constptr;
#define PUSHCONTEXT	{ constack[constptr]=context; parmnostack[constptr] = parmno; basecntstack[constptr++] = basecnt; }

#define POPCONTEXT	{ parmno=parmnostack[--constptr]; context=constack[constptr]; basecnt = basecntstack[constptr]; }

/* parameter control */
int	parmvar;	/* parameter is VAR=1 or PTR=2 */
int	parmno;		/* parameter number */
int	pcnt;		/* param count in repeat section */

%}

/* ignore ambiguity introduced by if-then-else */
%expect 1

/* YACC token identification */
%token	ABS_TOK
%token	ARRAY_TOK
%token	BEGIN_TOK
%token	CASE_TOK
%token	CHR_TOK
%token	CLOSE_TOK
%token	CONST_TOK
%token	DO_TOK
%token	DOWNTO_TOK
%token	ELSE_TOK
%token	END_TOK
%token	EXTERNAL_TOK
%token	FILE_TOK
%token	FOR_TOK
%token	FUNCTION_TOK
%token	IF_TOK
%token	IN_TOK
%token	GOTO_TOK
%token	LABEL_TOK
%token	OF_TOK
%token	NEW_TOK
%token	NIL_TOK
%token	ORD_TOK
%token	PROCEDURE_TOK
%token	PROGRAM_TOK
%token	READ_TOK
%token	READLN_TOK
%token	RECORD_TOK
%token	REPEAT_TOK
%token	RESET_TOK
%token	REWRITE_TOK
%token	SET_TOK
%token	SQR_TOK
%token	STR_TOK
%token	THEN_TOK
%token	TO_TOK
%token	TYPE_TOK
%token	UNTIL_TOK
%token	VAR_TOK
%token	WHILE_TOK
%token	WITH_TOK
%token	WRITE_TOK
%token	WRITELN_TOK

%token	SUBRANGE_TOK
%token	INTEGER_NUMBER
%token	REAL_NUMBER
%token	CHAR
%token	STRING
%token	UNDEF_VAR
%token	CONST_VAR
%token	CONST_STRING
%token	CONST_CHAR
%token	TYPE_VAR
%token	VARIABLE_VAR
%token	FUNCTION_VAR
%token	PROCEDURE_VAR
%token	FIELD_VAR
%token	FILE_VAR

/* arithmetic expressions */
%right	ASSIGN_TOK
%right	'.'
%left	':'
%left	OR_TOK
%left	AND_TOK
%left	GT_TOK GE_TOK LT_TOK LE_TOK '=' NE_TOK
%left	'+' '-'
%left	'*' '/' DIV_TOK MOD_TOK
%left	UNARYMINUS NOT_TOK

/* trying to define a program */
%start Program
%%

/* Definition of SPC grammar */
Program:	
		PROGRAM_TOK
		UNDEF_VAR
		';'				{ fileline(@1.first_line);
						  outputstr("/* SPC output */\n");
						  outputstr("char *progname=");
						  outputcstring($2->name);
						  outputstr(";\n#include \"spcc.h\"\n"); }
		Blockfuncpart			{ procomment("main");
						  outputstr("void main(int argc,char *argv[])\n");
						  outputstr("{\n");
						  outputstr("gargc = argc;\n");
						  outputstr("gargv = argv;\n");
						}
		Blockcodepart
		'.'				{ outputstr("}\n"); 
						  procomment("ends"); }
		|
		PROGRAM_TOK
		UNDEF_VAR
		'('	
		FILE_VAR
		')'
		';'				{ fileline(@1.first_line);
						  outputstr("/* SPC output */\n");
						  outputstr("char *progname=");
						  outputcstring($2->name);
						  outputstr(";\n#include \"spcc.h\"\n"); }
		Blockfuncpart			{ procomment("main");
						  outputstr("void main(int argc,char *argv[])\n");
						  outputstr("{\n");
						  outputstr("gargc = argc;\n");
						  outputstr("gargv = argv;\n");
						}
		Blockcodepart
		'.'				{ outputstr("}\n");
						  procomment("ends"); }
		|
		PROGRAM_TOK
		UNDEF_VAR
		'('	
		FILE_VAR
		','
		FILE_VAR
		')'
		';'				{ fileline(@1.first_line);
						  outputstr("/* SPC output */\n");
						  outputstr("char *progname=");
						  outputcstring($2->name);
						  outputstr(";\n#include \"spcc.h\"\n"); }
		Blockfuncpart			{ procomment("main");
						  outputstr("void main(int argc,char *argv[])\n");
						  outputstr("{\n");
						  outputstr("gargc = argc;\n");
						  outputstr("gargv = argv;\n");
						}
		Blockcodepart
		'.'				{ outputstr("}\n");
						  procomment("ends"); }
		;

Blockdefpart:
		Label_declaration_part
		Constant_definition_part
		Type_definition_part
		Variable_declaration_part
		;

Blockfuncpart:
		Procedure_and_function_declaration_part
		;

Blockcodepart:
		Compound_statement
		;

Label_declaration_part:
		/* empty */
		|
		LABEL_TOK
		Label_number_list
		';'
		;

Label_number_list:
		error				{ if (parsefail("error in label number definition",&@1)) YYABORT; }
		|
		INTEGER_NUMBER
		|
		Label_number_list
		','
		INTEGER_NUMBER
		;

Constant_definition_part:
		/* empty */
		|
		CONST_TOK			{ fileline(@1.first_line);
						  output("\n#define"); }
		Constant_definition_list
		';'				{ outputstr("\n"); }
		;

Constant_definition_list:
		error				{ if (parsefail("error in constant definition",&@1)) YYABORT; }
		|
		Constant_definition
		|
		Constant_definition_list
		';'				{ output("\n#define"); }
		Constant_definition
		;

Constant_definition:
		UNDEF_VAR			{ output($1->cname); }
		'='
		Constant			{ $1->etype=(int)$4;
						  if ($1->etype==(int)EXPSTR)
							$1->type=CONST_STRING;
						  else if ($1->etype==(int)EXPCHAR)
							$1->type=CONST_CHAR;
						  else
							$1->type=CONST_VAR;
						  $1->status = CONSTANT;
						  comment("ExpType=%d",$1->etype); }
		;

Constant:
		INTEGER_NUMBER			{ outputstr($1->cname);
						  $$=EXPINT; }
		|
		Sign
		INTEGER_NUMBER %prec UNARYMINUS	{ outputstr($2->cname);
						  $$=EXPINT; }
		|
		REAL_NUMBER			{ outputstr($1->name);
						  $$=EXPREAL; }
		|
		Sign
		REAL_NUMBER %prec UNARYMINUS	{ outputstr($2->name);
						  $$=EXPREAL; }
		|
		CONST_VAR			{ output($1->cname);
						  $$=(Symbol *)(long)($1->etype); }
		|
		Sign 
		CONST_VAR %prec UNARYMINUS	{ output($2->cname);
						  $$=(Symbol *)(long)($2->etype); }
		|
		CHAR				{ outputstr("'");
						  outputstr($1->cname);
						  output("'");
						  $$=EXPCHAR; }
		|
		STRING				{ outputcstring($1->cname);
						  $$=EXPSTR; }
		;

Sign:
		'+'				{ outputstr("+"); }
		|
		'-'				{ outputstr("-"); }
		;

Type_definition_part:
		/* empty */
		|
		TYPE_TOK			{ fileline(@1.first_line); }
		Type_definition_list
		';'				{ outputstr(";\n"); }
		;

Type_definition_list:
		error				{ if (parsefail("error in type definition",&@1)) YYABORT; }
		|
		Type_definition
		|
		Type_definition_list
		';'				{ outputstr(";\n"); }
		Type_definition
		;

Type_definition:
		UNDEF_VAR
		'='				{ pushoutputbuffer();
						  $1->type = TYPE_VAR;
						  context = $1;
						  basecnt=0;
						  basesym[0]=(Symbol *)0;
						  basesym[1]=(Symbol *)0;
						  basesym[2]=(Symbol *)0;
						  output("typedef"); }
		Type				{ outputstr($1->cname);
						  $1->etype = (int)$4;
						  $1->btype = basetype;
						  $1->basesym[0]=basesym[0];
						  $1->basesym[1]=basesym[1];
						  $1->basesym[2]=basesym[2];
						  basetype=0;
						  basecnt=0;
						  basesym[0]=(Symbol *)0;
						  basesym[1]=(Symbol *)0;
						  basesym[2]=(Symbol *)0;
						  popoutputbuffer();
						  comment("ExpType=%d",$1->etype); }
		;

Type:		Simple_type			{ $$=$1; }
		|
		Structured_type			{ $$=$1; }
		|
		Pointer_type			{ $$=$1; }
		;

Simple_type:
		Scalar_type			{ $$=$1; }
		|
		Subrange_type			{ $$=$1; }
		|
		TYPE_VAR			{ output($1->cname);
						  $$=(Symbol *)(long)($1->etype);
						  basetype=$1->btype; 
						  if (basecnt==0) {
							  basesym[0]=$1->basesym[0];
							  basesym[1]=$1->basesym[1];
							  basesym[2]=$1->basesym[2]; 
						  } }
		;

Scalar_type:
		'('
						{ enumcnt=0;
						  pushoutputbuffer(); }
		Scalar_list
		')'				{ outputstr("\n");
						  swapoutputbuffer();
						  popoutputbuffer();
						  output("int32");
						  $$=EXPINT; }
		;

Scalar_list:
		UNDEF_VAR			{ output("\n#define");
						  output($1->cname);
						  $1->type = CONST_VAR;
						  outputint(enumcnt++); }
		|
		Scalar_list
		','
		UNDEF_VAR			{ output("\n#define");
						  output($3->cname);
						  $3->type = CONST_VAR;
						  outputint(enumcnt++); }
		;
	
Subrange_type:
						{ outputoff(); }
		Constant
		SUBRANGE_TOK
		Constant
						{ outputon();
						  output("int32");
						  $$=EXPINT; }
		;

Structured_type:
		Array_type			{ $$=EXPADDR; }
		|
		Record_type			{ $$=EXPADDR; }
		|
		Set_type			{ $$=EXPADDR; }
		|
		File_type			{ $$=EXPADDR; }
		;

Array_type:
		ARRAY_TOK
						{ output("struct {");
						  pushoutputbuffer();
						  basecnt=0;
						  basesym[0]=(Symbol *)0;
						  basesym[1]=(Symbol *)0;
						  basesym[2]=(Symbol *)0; }
		'['				{ outputstr("["); }
		Array_index_type_list
		']'				{ outputstr("+1];"); }
		OF_TOK				{ pushoutputbuffer(); }
		Type				{ outputstr("ar");
						  swapoutputbuffer();
						  popoutputbuffer();
						  popoutputbuffer();
						  output("}");
						  if (!basesym[0])
							comment("no base symbol");
						  else
						  	comment("basesymbol=%s",basesym[0]->cname);
						  basetype=(short)(long)$10; }
		;

Array_index_type_list:
		Array_index_type		{ basesym[basecnt++]=$1; }
		|
		Array_index_type_list
		','				{ outputstr("+1]["); }
		Array_index_type		{ basesym[basecnt++]=$4; }
		;

Array_index_type:
		INTEGER_NUMBER
		SUBRANGE_TOK
		INTEGER_NUMBER			{ outputstr($3->cname);
						  outputstr("-");
						  outputstr($1->cname);
						  if (atoi($1->cname)==0)
							$$=(Symbol *)0;
						  else
							$$=$1; }
		|
		INTEGER_NUMBER
		SUBRANGE_TOK
		CONST_VAR			{ outputstr($3->cname); 
						  outputstr("-");
						  outputstr($1->cname);
						  if (atoi($1->cname)==0)
							$$=(Symbol *)0;
						  else
							$$=$1; }
		|
		CONST_VAR
		SUBRANGE_TOK
		INTEGER_NUMBER			{ outputstr($3->cname);
						  outputstr("-");
						  outputstr($1->cname);
						  $$=$1; }
		|
		CONST_VAR
		SUBRANGE_TOK
		CONST_VAR			{ outputstr($3->cname); 
						  outputstr("-");
						  outputstr($1->cname);
						  $$=$1; }
		;

Record_type:
		RECORD_TOK			{ output("struct");
						  if (context) output(context->cname);
						  outputstr("{\n"); }
		Record_field_list
		END_TOK				{ if ($3==NULL)
							outputstr(";");
						  output("}"); }
		;

Record_field_list:
		Record_section			{ $$=$1; }
		|
		Record_field_list
		';'				{ outputstr(";\n"); }
		Record_section			{ $$=$4; }
		;

Record_section:
		/* empty */			{ $$=(Symbol *)1; }
		|
						{ pushoutputbuffer(); }
		Identifier_list
		':'				{ pushoutputbuffer(); }
		Type				{ swapoutputbuffer();
						  popoutputbuffer();
						  popoutputbuffer();
						  comment("ExpType=%d",(int)$5);
						  comment("BaseType=%d",(int)basetype);
						  setvaretype((int)EXPNULT,(int)$5,basetype,basesym);
						  basetype=0; 
						  basecnt=0;
						  basesym[0]=(Symbol *)0;
						  basesym[1]=(Symbol *)0;
						  basesym[2]=(Symbol *)0;
						  $$=NULL; }
		;

Identifier_list:
		UNDEF_VAR			{ outputstr($1->cname);
						  $1->type = FIELD_VAR;
						  $1->etype = (int)EXPNULT; }
		|
		Identifier_list
		','
		UNDEF_VAR			{ outputstr(",");
						  outputstr($3->cname);
						  $3->type = FIELD_VAR;
						  $3->etype = (int)EXPNULT; }
		;

Set_type:
		SET_TOK
		OF_TOK
		Simple_type			{ if (warning(&@1,"set types not supported","")) YYABORT;
						  $$=EXPADDR; }
		;

File_type:
		FILE_TOK
		OF_TOK
		Type				{ if (warning(&@1,"file types not supported","")) YYABORT;
						  $$=EXPADDR; }
		;

Pointer_type:
		'^'
		TYPE_VAR			{ if (context==$2) output("struct");
						  output($2->cname);
						  output("*");
						  basetype=(short)$2->etype;
						  $$=EXPPTR; }
		;

Variable_declaration_part:
		/* empty */
		|
		VAR_TOK				{ fileline(@1.first_line);
						  context=NULL; } 
		Variable_declaration_list
		';'				{ outputstr(";\n"); }
		;

Variable_declaration_list:
		error				{ if (parsefail("error in variable declaration",&@1)) YYABORT; }
		|
		Variable_declaration
		|
		Variable_declaration_list
		';'				{ outputstr(";\n"); }
		Variable_declaration
		;

Variable_declaration:
						{ pushoutputbuffer(); }
		Variable_identifier_list
		':'				{ pushoutputbuffer();
						  basecnt=0;
						  basesym[0]=(Symbol *)0;
						  basesym[1]=(Symbol *)0;
						  basesym[2]=(Symbol *)0;
						  context=NULL; }
		Type				{ swapoutputbuffer(); 
						  popoutputbuffer();
						  popoutputbuffer();
						  comment("ExpType=%d",(int)$5);
						  setvaretype((int)EXPNULV,(int)$5,basetype,basesym); }
		;

Variable_identifier_list:
		Def_undef_var			{ outputstr($1->cname);
						  $1->type = VARIABLE_VAR;
						  $1->etype = (int)EXPNULV; }
		|
		Variable_identifier_list
		','
		Def_undef_var			{ outputstr(",");
						  outputstr($3->cname);
						  $3->type = VARIABLE_VAR;
						  $3->etype = (int)EXPNULV; }
		;

Def_undef_var:
		UNDEF_VAR			{ $$=$1; }
		|
		VARIABLE_VAR			{ $$=dupsymbol($1);
						  if (!symblockcheck($$,$1))
							if (warning(&@1,"duplicate symbol: ",$$->name)) YYABORT; }
		;

Procedure_and_function_declaration_part:
		/* empty */
		|
		Procedure_or_function_declaration
		Procedure_and_function_declaration_part
		;

Procedure_or_function_declaration:
		LABEL_TOK
		Label_number_list
		';'
		|
		CONST_TOK			{ fileline(@1.first_line);
						  output("\n#define"); }
		Constant_definition_list
		';'				{ outputstr("\n"); }
		|
		TYPE_TOK			{ fileline(@1.first_line); }
		Type_definition_list
		';'				{ outputstr(";\n"); }
		|
		VAR_TOK				{ fileline(@1.first_line); } 
		Variable_declaration_list
		';'				{ outputstr(";\n"); }
		|
		Procedure_declaration
		';'
		|
		Function_declaration 
		';'
		;

Procedure_declaration:
		Procedure_heading		{ pushoutputbuffer(); }
		Blockdefpart	
		BEGIN_TOK			{ pushoutputbuffer();
						  outputstr("{\n");
						  swapoutputbuffer();
						  popoutputbuffer();
						  popoutputbuffer();
						  symblockinit();
						  fileline(@4.first_line); }
		Statement_list
		END_TOK				{ if ($6==NULL)
							outputstr(";\n");
						  $$=(Symbol *)1;
						  symblockend();
						  outputstr("}\n"); }
		|
		EXTERNAL_TOK
		External_procedure_heading	{ symblockcancel(); }
		;

Procedure_heading:
		PROCEDURE_TOK
		UNDEF_VAR
		';'				{ procomment($2->name);
						  fileline(@1.first_line);
						  output("void");
						  outputstr($2->cname);
						  outputstr("()\n");
						  $2->type=PROCEDURE_VAR;
						  symblockstart(); }
		|
		PROCEDURE_TOK
		UNDEF_VAR
		'('				{ procomment($2->name);
						  fileline(@1.first_line);
						  output("void");
						  outputstr($2->cname);
						  outputstr("(");
						  $2->type=PROCEDURE_VAR;
						  context=$2;
						  parmno=0;
						  parmvar=0;
						  symblockstart(); }
		Formal_parameter_list
		')'
		';'				{ outputstr(")\n");
						  parmvar=0; }
		;

Formal_parameter_list:
		Formal_parameter_section
		|
		Formal_parameter_list
		';'				{ outputstr(","); }
		Formal_parameter_section
		;

Formal_parameter_section:
		Parameter_group
		|
		VAR_TOK				{ parmvar=1; }
		Parameter_group			{ parmvar=0; }
		;

Parameter_group:
						{ pushoutputbuffer();
						  pcnt=0; }
		Parameter_variable_identifier_list
		':'
		Parameter_group_type
		;

Parameter_group_type:
		TYPE_VAR			{ pushoutputbuffer();
						  outputstr("ARGS");
						  outputint(pcnt);
						  outputstr("(");
						  outputstr($1->cname);
						  outputstr(",");
						  swapoutputbuffer(); 
						  popoutputbuffer();
						  popoutputbuffer();
						  outputstr(")");
						  comment("ExpType=%d",$1->etype);
						  setvaretype((int)EXPNULV,$1->etype,$1->btype,$1->basesym); }
		|
		'^'
		TYPE_VAR			{ pushoutputbuffer();
						  outputstr("ARGS");
						  outputint(pcnt);
						  outputstr("(");
						  outputstr($2->cname);
						  outputstr(",*");
						  swapoutputbuffer(); 
						  popoutputbuffer();
						  popoutputbuffer();
						  outputstr(")");
						  comment("ExpType=%d",$2->etype);
						  setvaretype((int)EXPNULV,(int)EXPPTR,$2->etype,$2->basesym);
						  setparamtype(context,parmno-pcnt,parmno-1,2);
						}
		;

Parameter_variable_identifier_list:
		Def_undef_var			{ if (parmvar==1)
						  	outputstr("*");
						  outputstr($1->cname);
						  $1->type = VARIABLE_VAR;
						  $1->etype = (int)EXPNULV;
						  addparamtype(context,parmno++,parmvar);
						  if (parmvar==1) 
							$1->status=ADRPAR;
						  else
							$1->status=VALPAR; 
						  pcnt++; }
		|
		Parameter_variable_identifier_list
		','
		Def_undef_var			{ outputstr(",");
						  if (parmvar==1)
						  	outputstr("*");
						  outputstr($3->cname);
						  $3->type = VARIABLE_VAR;
						  $3->etype = (int)EXPNULV;
						  if (parmvar==1) 
							$3->status=ADRPAR;
						  else
							$3->status=VALPAR;
						  addparamtype(context,parmno++,parmvar);
						  pcnt++; }
		;

External_procedure_heading:
		PROCEDURE_TOK
		UNDEF_VAR			{ procomment($2->name);
						  fileline(@1.first_line);
						  output("void");
						  outputstr($2->cname);
						  outputstr("(");
						  outputstr("\n#ifdef __STDC__\n");
						  outputstr("void\n");
						  outputstr("#endif\n");
						  outputstr(");\n");
						  $2->type=PROCEDURE_VAR;
						  symblockstart(); }
		|
		PROCEDURE_TOK
		UNDEF_VAR
		'('				{ fileline(@1.first_line);
						  output("void");
						  outputstr($2->cname);
						  outputstr("(");
						  $2->type=PROCEDURE_VAR;
						  context=$2;
						  parmno=0;
						  parmvar=0;
						  symblockstart();
						  outputstr("\n#ifdef __STDC__\n"); }
		External_formal_parameter_list
		')'				{ outputstr("\n#endif\n");
						  outputstr(");\n");
						  parmvar=0; }
		;

External_formal_parameter_list:
		External_formal_parameter_section
		|
		External_formal_parameter_list
		';'				{ outputstr(","); }
		External_formal_parameter_section
		;

External_formal_parameter_section:
		External_parameter_group
		|
		VAR_TOK				{ parmvar=1; }
		External_parameter_group	{ parmvar=0; }
		;

External_parameter_group:
						{ pushoutputbuffer(); }
		External_parameter_variable_identifier_list
		':'
		External_parameter_group_type
		;

External_parameter_group_type:
		TYPE_VAR			{ killoutputbuffer();
						  outputnullvar((int)EXPNULV,$1->cname);
						  setvaretype((int)EXPNULV,(int)($1->etype),$1->btype,$1->basesym); }
		|
		'^'
		TYPE_VAR			{ killoutputbuffer();
						  outputnullvar((int)EXPNULV,$2->cname);
						  outputstr(" *");
						  setvaretype((int)EXPNULV,(int)EXPPTR,$2->etype,$2->basesym); 
						  setparamtype(context,parmno-1,parmno-1,2);
						}
		;

External_parameter_variable_identifier_list:
		Def_undef_var			{ $1->type = VARIABLE_VAR;
						  $1->etype = (int)EXPNULV;
						  addparamtype(context,parmno++,parmvar);
						  if (parmvar==1) 
							$1->status=ADRPAR;
						  else
							$1->status=VALPAR; 
						} 
		|
		External_parameter_variable_identifier_list
		','
		Def_undef_var			{ $3->type = VARIABLE_VAR;
						  $3->etype = (int)EXPNULV;
						  if (parmvar==1) 
							$3->status=ADRPAR;
						  else
							$3->status=VALPAR;
						  addparamtype(context,parmno++,parmvar);
						 }
		;

Function_declaration:
		Function_heading		{ pushoutputbuffer(); }
		Blockdefpart	
		BEGIN_TOK			{ pushoutputbuffer();
						  outputstr("{\n");
						  swapoutputbuffer();
						  popoutputbuffer();
						  popoutputbuffer();
						  output($1->cname);
						  outputstr("_funcreturn");
						  if ($1->etype==(int)EXPSTR)
							outputstr(";\n_funcreturn=stringNULL");
						  else if ($1->etype==(int)EXPWAVE)
							outputstr(";\n_funcreturn=waveformNULL");
						  outputstr(";\n");
						  symblockinit();
						  fileline(@4.first_line); }
		Statement_list
		END_TOK				{ if ($6==NULL)
							outputstr(";\n");
						  $$=(Symbol *)1;
						  symblockend();
						  outputstr("return(_funcreturn);\n");
						  outputstr("}\n"); }
		|
		EXTERNAL_TOK
		External_function_heading	{ symblockcancel(); }
		;

Function_heading:
		FUNCTION_TOK
		UNDEF_VAR
		':'
		TYPE_VAR
		';'				{ procomment($2->name);
						  fileline(@1.first_line);
						  output($4->cname);
						  outputstr($2->cname);
						  outputstr("()\n");
						  $2->type=FUNCTION_VAR;
						  $2->etype=$4->etype; 
						  $$=$4;
						  symblockstart(); }
		|
		FUNCTION_TOK
		UNDEF_VAR
		'('				{ procomment($2->name);
						  fileline(@1.first_line);
						  pushoutputbuffer();
						  outputstr($2->cname);
						  outputstr("(");
						  $2->type=FUNCTION_VAR;
						  context=$2;
						  parmno=0;
						  parmvar=0;
						  symblockstart(); }
		Formal_parameter_list
		')'
		':'
		TYPE_VAR
		';'				{ $2->etype=$8->etype;
						  $2->type=FUNCTION_VAR;
						  outputstr(")\n");
						  pushoutputbuffer();
						  output($8->cname);
						  swapoutputbuffer();
						  popoutputbuffer();
						  popoutputbuffer();
						  $$=$8;
						  parmvar=0; }
		;

External_function_heading:
		FUNCTION_TOK
		UNDEF_VAR
		':'
		TYPE_VAR			{ fileline(@1.first_line);
						  output($4->cname);
						  outputstr($2->cname);
						  outputstr("(");
						  outputstr("\n#ifdef __STDC__\n");
						  outputstr("void");
						  outputstr("\n#endif\n");
						  outputstr(");\n");
						  $2->type=FUNCTION_VAR;
						  $2->etype=$4->etype; 
						  $$=$4;
						  symblockstart(); }
		|
		FUNCTION_TOK
		UNDEF_VAR
		'('				{ fileline(@1.first_line);
						  pushoutputbuffer();
						  outputstr($2->cname);
						  outputstr("(");
						  $2->type=FUNCTION_VAR;
						  context=$2;
						  parmno=0;
						  parmvar=0;
						  symblockstart();
						  outputstr("\n#ifdef __STDC__\n"); }
		External_formal_parameter_list
		')'
		':'
		TYPE_VAR			{ $2->etype=$8->etype;
						  $2->type=FUNCTION_VAR;
						  outputstr("\n#endif\n");
						  outputstr(");\n");
						  pushoutputbuffer();
						  output($8->cname);
						  swapoutputbuffer();
						  popoutputbuffer();
						  popoutputbuffer();
						  $$=$8;
						  parmvar=0; }
		;

Compound_statement:
		BEGIN_TOK			{ outputstr("{"); }
		Statement_list
		END_TOK				{ if ($3==NULL)
							outputstr(";\n");
						  outputstr("}\n");
						  $$=(Symbol *)1; }
		;

Statement_list:
		Statement			{ $$=$1; }
		|
		Statement_list
		';'				{ if ($1==NULL)
							outputstr(";"); }
		Statement			{ $$=$4; }
		|
		error ';'			{ if (parsefail("error in statement",&@1)) YYABORT;
						  $$=(Symbol *)0; }
		Statement			{ $$=$4; }
		;

Statement:
		Unlabelled_statement		{ $$=$1; }
		|
		INTEGER_NUMBER			
		':'				{ outputstr("label_");
						  outputstr($1->name);
						  output(":"); }
		Unlabelled_statement		{ $$=$4; }
		;

Unlabelled_statement:
		Simple_statement		{ $$=$1; }
		|
		Structured_statement		{ $$=$1; }
		;

Simple_statement:
		Assignment_statement		{ $$=$1; }
		|
		Procedure_statement		{ $$=$1; }
		|
		File_IO_statement		{ $$=$1; }
		|
		Read_statement			{ $$=$1; }
		|
		Write_statement			{ $$=$1; }
		|
		Goto_statement			{ $$=$1; }
		|
		Empty_statement			{ $$=$1; }
		;

Assignment_statement:
						{ pushoutputbuffer(); }
		Variable
		ASSIGN_TOK			{ pushoutputbuffer(); }
		Expression			{ comment("AssType=%d",(int)$2);
						  comment("ExpType=%d",(int)$5);
						  if ((int)$2==(int)$5)
							/* assignment ok */;
						  else if (($2==EXPREAL) && ($5==EXPINT))
							/* assignment ok */;
#if 0
						  else if (($2==EXPCHAR) && ($5==EXPSTR))
							/* assignment ok */;
#endif
						  else
							if (warning(&@5,"assignment type mismatch","")) YYABORT; 
						  if ($5==EXPSTR) {
							pushoutputbuffer();
							fileline(@2.first_line);
#if 0 
							if ($2==EXPCHAR)
								outputstr("_cassign(&(");
							else
#endif
								outputstr("_sassign(&(");
							rot3outputbuffer();
							outputstr("),(");
							rot3outputbuffer();
							popoutputbuffer();
							popoutputbuffer();
							popoutputbuffer();
							outputstr(",_spop()))");
						  }
						  else if ($5==EXPWAVE) {
							pushoutputbuffer();
							fileline(@2.first_line);
							outputstr("_wassign(&(");
							rot3outputbuffer();
							outputstr("),(");
							rot3outputbuffer();
							popoutputbuffer();
							popoutputbuffer();
							popoutputbuffer();
							outputstr(",_wpop()))");
						  }
						  else {
							pushoutputbuffer();
							fileline(@2.first_line);
							rot3outputbuffer();
							outputstr(" = ");
							rot3outputbuffer();
							popoutputbuffer();
							popoutputbuffer();
							popoutputbuffer();
						  }
						  $$=NULL; }
		|
		FUNCTION_VAR
		ASSIGN_TOK			{ fileline(@1.first_line);
						  comment("ExpType=%d",(int)$1->etype);
						  if ($1->etype==(int)EXPSTR)
							outputstr("_sassign(&_funcreturn,(");
						  else if ($1->etype==(int)EXPWAVE)
							outputstr("_wassign(&_funcreturn,(");  
						  else
							outputstr("_funcreturn = "); 
						  comment("FuncType=%d",$1->etype); }
		Expression			{ if ($1->etype==(int)$4)
							/* assignment ok */;
						  else if (($1->etype==(int)EXPREAL) && ($4==EXPINT))
							/* assignment ok */;
#if 0
						  else if (($1->etype==(int)EXPCHAR) && ($4==EXPSTR))
							/* assignment ok */;
#endif
						  else
							if (warning(&@4,"assignment type mismatch","")) YYABORT;
						  comment("ExpType=%d",(int)$4);
						  if ($1->etype==(int)EXPSTR)
							  outputstr(",_spop()))");
						  else if ($1->etype==(int)EXPWAVE)
							  outputstr(",_wpop()))");
						  $$=NULL; }

		;

Variable:
		VARIABLE_VAR			{ if ($1->status==ADRPAR)
							outputstr("*");
						  outputstr($1->cname); 
						  $$=(Symbol *)(long)($1->etype); }
		|
		Component_variable		{ $$=$1; }
		|
		Referenced_variable		{ $$=$1; }
		|
		UNDEF_VAR			{ if (warning(&@1,"%s: not declared",$1->name)) YYABORT; }
		;

Component_variable:
		Indexed_variable		{ $$=$1; }
		|
		Field_designator		{ $$=$1; }
		;

Indexed_variable:
		VARIABLE_VAR
		'['				{ if (!$1->btype && warning(&@1,"%s: not an array",$1->name)) YYABORT;
						  if ($1->etype==(int)EXPPTR) {
						  	if ($1->status==ADRPAR) {
								outputstr("(*");
								outputstr($1->cname);
								outputstr(")");
							}
							else
								outputstr($1->cname);
						  }
						  else {
							outputstr($1->cname);
						  	if ($1->status==ADRPAR)
								outputstr("->");
							else
								outputstr(".");
						  	if (($1->etype==(int)EXPSTR) || ($1->etype==(int)EXPWAVE))
								outputstr("buf.");
						 	outputstr("ar"); 
						  }
						  outputstr("[");
						  PUSHCONTEXT;
						  context = $1;
						  basecnt = 0; }
		Index_list
		']'				{ outputstr("]"); }
		Field_option			{ POPCONTEXT; 
						  $$=$7; }
		;

Index_list:
						{ PUSHCONTEXT; }
		Expression			{ POPCONTEXT;
						  if (context->basesym[basecnt]) {
							outputstr("-");
							outputstr(context->basesym[basecnt]->cname);
						  }
						  basecnt++; }
		|
		Index_list
		','				{ outputstr("]["); 
						  PUSHCONTEXT; }
		Expression			{ POPCONTEXT;
						  if (context->basesym[basecnt]) {
							outputstr("-");
							outputstr(context->basesym[basecnt]->cname);
						  }
						  basecnt++; }
		|
		Index_list
		']'
		'['				{ outputstr("]["); 
						  PUSHCONTEXT; }
		Expression			{ POPCONTEXT;
						  if (context->basesym[basecnt]) {
							outputstr("-");
							outputstr(context->basesym[basecnt]->cname);
						  }
						  basecnt++; }
		;

Field_option:
		/* empty */			{ $$=(Symbol *)(long)(context->btype); }
		|
		'.'				{ context=(Symbol *)NULL; }
		Field_selector_list		{ $$=$3; }
		;

Field_designator:
		VARIABLE_VAR
		'.'				{ outputstr($1->cname);
						  PUSHCONTEXT;
						  context=$1; }
		Field_selector_list		{ POPCONTEXT;
						  $$=$4; }
		;

Field_selector_list:
		Field_selector			{ $$=$1; }
		|
		Field_selector_list
		'.'
		Field_selector			{ $$=$3; }
		;

Field_selector:
		FIELD_VAR			{ if (context && ((context->status==ADRPAR) ||
						      (context->etype==(int)EXPPTR)))
							outputstr("->");
						  else
							outputstr(".");
						  output($1->cname); 
						  $$=(Symbol *)(long)($1->etype); }
		|
		FIELD_VAR
		'['				{ if (context && ((context->status==ADRPAR) ||
						      (context->etype==(int)EXPPTR)))
							outputstr("->");
						  else
							outputstr(".");
						  outputstr($1->cname);
						  if ($1->etype!=(int)EXPPTR)
							outputstr(".ar");
						  PUSHCONTEXT;
						  context=$1;
						  basecnt=0;
#if 0
						  comment("field context=%s",context->cname);
						  if (!context->basesym[0])
							comment("no base symol");
						  else
							comment("base symbol=%s",context->basesym[0]->cname);
#endif
						  outputstr("["); }
		Index_list
		']'				{ POPCONTEXT;
						  context=(Symbol *)NULL;
						  outputstr("]");
						  $$=(Symbol *)(long)($1->btype); }
		|
		FIELD_VAR
		'^'				{ if (context && ((context->status==ADRPAR) ||
						      (context->etype==(int)EXPPTR)))
							outputstr("->");
						  else
							outputstr(".");
						  outputstr($1->cname);
						  $$=(Symbol *)(long)($1->btype); }
		;

Referenced_variable:
		VARIABLE_VAR
		'^'				{ outputstr("*");
						  output($1->cname);
						  $$=(Symbol *)(long)($1->btype); }
		|
		VARIABLE_VAR
		'^'
		'.'				{ if ($1->status==ADRPAR)
							outputstr("(*");
						  outputstr($1->cname);
						  if ($1->status==ADRPAR)
							  outputstr(")");
						  PUSHCONTEXT;
						  context=$1; }
		Field_selector_list		{ POPCONTEXT;
						  $$=$5; }
		;

Expression:
		Simple_expression		{ $$=$1; }
		|
		Simple_expression
		Relational_operator		{ if ($1 == EXPSTR)
							outputstr(","); }
		Simple_expression		{ if ((int)$1==(int)$4)
							/* assignment ok */;
						  else if ((($1==EXPINT) || ($1==EXPREAL)) && 
							   (($4==EXPINT) || ($4==EXPREAL)))
							/* assignment ok */;
#if 0
						  else if (($1==EXPCHAR) && ($4==EXPSTR))
							/* assignment ok */;
#endif
						  else
							if (warning(&@4,"mixed types in expression","")) YYABORT;
						  if ($1==EXPSTR) {
							  outputstr(",_scompare(");
							  outputint((int32)(int)$2);
							  outputstr(")");
						  }
						  $$=EXPBOOL; }
		;

Relational_operator:
		'='				{ if ($0==EXPSTR)
							$$=(Symbol *)'=';
						  else
							outputstr("=="); }
		|
		NE_TOK				{ if ($0==EXPSTR)
							$$=(Symbol *)NE_TOK;
						  else
							outputstr("!="); }
		|
		LT_TOK				{ if ($0==EXPSTR)
							$$=(Symbol *)LT_TOK;
						  else
							outputstr("<"); }
		|
		LE_TOK				{ if ($0==EXPSTR)
							$$=(Symbol *)LE_TOK;
						  else
							outputstr("<="); }
		|
		GT_TOK				{ if ($0==EXPSTR)
							$$=(Symbol *)GT_TOK;
						  else
							outputstr(">"); }
		|
		GE_TOK				{ if ($0==EXPSTR)
							$$=(Symbol *)GE_TOK;
						  else
							outputstr(">="); }
		|
		IN_TOK
		;

Simple_expression:
		Term				{ $$=$1; }
		|
		Simple_expression
		Adding_operator			{ if (($1 == EXPSTR) || ($1==EXPWAVE))
							outputstr(","); }
		Term				{ if ((int)$1==(int)$4)
							/* assignment ok */;
						  else if ((($1==EXPINT) || ($1==EXPREAL)) && 
							   (($4==EXPINT) || ($4==EXPREAL)))
							/* assignment ok */;
#if 0
						  else if (($1==EXPCHAR) && ($4==EXPSTR))
							/* assignment ok */;
#endif
						  else
							if (warning(&@4,"mixed types in expression","")) YYABORT;
						  if ($1==EXPSTR) {
							  outputstr(",_sarith(");
							  outputint((int32)(int)$2);
							  outputstr(")");
						  }
						  else if ($1==EXPWAVE) {
							  outputstr(",_warith(");
							  outputint((int32)(int)$2);
							  outputstr(")");
						  }
						  if (($1==EXPREAL) || ($4==EXPREAL))
							$$=EXPREAL;
						  else
						  	$$=$1; }
		;

Adding_operator:
		'+'				{ if (($0==EXPSTR) || ($0==EXPWAVE))
							$$=(Symbol *)'+';
						  else
							outputstr("+"); }
		|
		'-'				{ if (($0==EXPSTR) || ($0==EXPWAVE)) {
							if (warning(&@1,"unsupported operator","")) YYABORT;
						  }
						  else
							outputstr("-"); }
		|
		OR_TOK				{ if (($0==EXPSTR) || ($0==EXPWAVE))
							$$=(Symbol *)OR_TOK;
						  else
							outputstr(" || "); }
		;

Term:
		Factor				{ $$=$1; }
		|
		Term
		Multiplying_operator		{ if ($1 == EXPSTR)
							outputstr(","); }
		Factor				{ if ((int)$1==(int)$4)
							/* assignment ok */;
						  else if ((($1==EXPINT) || ($1==EXPREAL)) && 
							   (($4==EXPINT) || ($4==EXPREAL)))
							/* assignment ok */;
#if 0
						  else if (($1==EXPCHAR) && ($4==EXPSTR))
							/* assignment ok */;
#endif
						  else
							if (warning(&@4,"mixed types in expression","")) YYABORT;
						  if ($1==EXPSTR) {
							  outputstr(",_sarith(");
							  outputint((int32)(int)$2);
							  outputstr(")");
						  }
						  if (($1==EXPREAL) || ($2==EXPREAL) || ($4==EXPREAL))
							$$=EXPREAL;
						  else
						  	$$=$1; }
		;

Multiplying_operator:
		'*'				{ if (($0==EXPSTR) || ($0==EXPWAVE)) {
							if (warning(&@1,"unsupported operator","")) YYABORT;
						  }
						  else
							outputstr("*");
						  $$=$0; }
		|
		'/'				{ if (($0==EXPSTR) || ($0==EXPWAVE)) {
							if (warning(&@1,"unsupported operator","")) YYABORT;
						  }
						  else
							outputstr("/(double)"); 
						  $$=EXPREAL; }
		|
		DIV_TOK				{ if (($0==EXPSTR) || ($0==EXPWAVE)) {
							if (warning(&@1,"unsupported operator","")) YYABORT;
						  }
						  else
							outputstr("/(int32)");
						  $$=EXPINT; }
		|
		MOD_TOK				{ if (($0==EXPSTR) || ($0==EXPWAVE)) {
							if (warning(&@1,"unsupported operator","")) YYABORT;
						  }
						  else
							outputstr("%"); 
						  $$=EXPINT; }
		|
		AND_TOK				{ $$=$0;
						  if ($0==EXPSTR)
							$$=(Symbol *)AND_TOK;
						  else if ($0==EXPWAVE) {
							if (warning(&@1,"unsupported operator","")) YYABORT;
						  }
						  else
							outputstr(" && "); }
		;

Factor:
						{ pushoutputbuffer(); }
		Variable			{ $$=$2;
						  if (parmvar==1)
							popoutputbuffer();
						  else if ($2==EXPSTR) {
							pushoutputbuffer();
						 	outputstr("_spush(");
							swapoutputbuffer();
							popoutputbuffer();
							popoutputbuffer();
							outputstr(")"); 
						  }
#if 0
						  else if ($2==EXPCHAR) {
							pushoutputbuffer();
						 	outputstr("_spushstr(");
							swapoutputbuffer();
							popoutputbuffer();
							popoutputbuffer();
							outputstr(")");
							$$=EXPSTR;
						  }
#endif
						  else if ($2==EXPWAVE) {
							pushoutputbuffer();
						 	outputstr("_wpush(");
							swapoutputbuffer();
							popoutputbuffer();
							popoutputbuffer();
							outputstr(")"); 
						  }
						  else
							popoutputbuffer(); 
						}
		|
		Unsigned_constant		{ $$=$1; }
		|
		'('				{ outputstr("("); }
		Expression
		')'				{ outputstr(")"); 
						  $$=$3; }
		|
		'('
		error				{ if (parsefail("error in expression",&@2)) YYABORT; }
		')'
		|
						{ pushoutputbuffer(); }
		Function_designator		{ $$=$2;
						  if ($2==EXPSTR) {
							pushoutputbuffer();
						 	outputstr("_ssave(");
							swapoutputbuffer();
							popoutputbuffer();
							popoutputbuffer();
							outputstr(")"); 
						  }
#if 0
						  else if ($2==EXPCHAR) {
							pushoutputbuffer();
						 	outputstr("_spushchar(");
							swapoutputbuffer();
							popoutputbuffer();
							popoutputbuffer();
							outputstr(")");
							$$=EXPSTR;
						  }
#endif
						  else if ($2==EXPWAVE) {
							pushoutputbuffer();
						 	outputstr("_wsave(");
							swapoutputbuffer();
							popoutputbuffer();
							popoutputbuffer();
							outputstr(")"); 
						  }
						  else
							popoutputbuffer(); 
						}
		|
		ORD_TOK
		'('				{ outputstr("(int32)("); }
		Expression
		')'				{ outputstr(")");
						  $$=EXPINT; }
		|
		Set
		|
		'-'				{ outputstr("-"); }
		Factor %prec UNARYMINUS		{ $$=$3; }
		|
		NOT_TOK				{ outputstr("!("); }
		Factor %prec NOT_TOK		{ outputstr(")");
						  if ($3!=EXPBOOL)
							if (warning(&@3,"NOT operator on Boolean only","")) YYABORT;
						  $$=EXPBOOL; }
		|
						{ outputstr("_spushstr("); }
		String_constant			{ outputstr(")");
						  $$=EXPSTR }
		|
		CONST_CHAR			{ outputstr($1->cname);
						  $$=EXPCHAR; }
		|
		CHR_TOK
		'('				{ outputstr("(char)("); }
		Expression
		')'				{ outputstr(")"); 
						  $$=EXPCHAR; }
		|
		STR_TOK
		'('				{ outputstr("_spushchar("); }
		Expression
		')'				{ outputstr(")"); 
						  $$=EXPSTR; }
		|
		ABS_TOK
		'('				{ pushoutputbuffer(); }
		Expression
		')'				{ pushoutputbuffer();
						  if ($4==EXPINT)
							outputstr("_iabs(");
						  else if ($4==EXPREAL)
							outputstr("_rabs(");
						  else
							if (warning(&@4,"ABS of non numeric value","")) YYABORT;
						  swapoutputbuffer();
						  popoutputbuffer();
						  popoutputbuffer();
						  outputstr(")");
						  $$=$4; }
		|
		SQR_TOK
		'('				{ pushoutputbuffer(); }
		Expression
		')'				{ pushoutputbuffer();
						  if ($4==EXPINT)
							outputstr("_isqr(");
						  else if ($4==EXPREAL)
							outputstr("_rsqr(");
						  else
							if (warning(&@4,"SQR of non numeric value","")) YYABORT;
						  swapoutputbuffer();
						  popoutputbuffer();
						  popoutputbuffer();
						  outputstr(")");
						  $$=$4; }
		;
		
Unsigned_constant:
		CONST_VAR			{ output($1->cname);
						  $$=(Symbol *)(long)($1->etype); }
		|
		INTEGER_NUMBER			{ outputstr($1->cname);
						  $$=EXPINT; }
		|
		REAL_NUMBER			{ outputstr($1->name);
						  $$=EXPREAL; }
		|
		NIL_TOK				{ outputstr("NULL");
						  $$=EXPPTR; }
		|
		CHAR				{ outputstr("(char)'");
						  outputstr($1->cname);
						  outputstr("'");
						  $$=EXPCHAR; }
		;

String_constant:
		STRING				{ outputcstring($1->cname); }
		|
		CONST_STRING			{ outputstr($1->cname); }
		;

Function_designator:
		FUNCTION_VAR			{ outputstr($1->cname);
						  outputstr("()");
						  $$=(Symbol *)(long)($1->etype); }
		|
		FUNCTION_VAR
		'('				{ outputstr($1->cname);
						  outputstr("(");
						  PUSHCONTEXT;
						  context=$1;
						  parmno=0;
						  parmvar=getparamtype(context,parmno);
						  if (parmvar==1) outputstr("&");
						  outputstr("("); }
		Actual_parameter_list
		')'				{ outputstr("))");
						  $$=(Symbol *)(long)($1->etype);
						  POPCONTEXT;
						  parmvar=0; }
		;

Actual_parameter_list:
		Actual_parameter		{ parmvar=getparamtype(context,++parmno); }
		|
		Actual_parameter_list
		','				{ outputstr("),");
						  if (parmvar==1) outputstr("&");
						  outputstr("("); }
		Actual_parameter		{ parmvar=getparamtype(context,++parmno); }
		;

Actual_parameter:
		FILE_VAR			{ outputstr($1->cname);
						  $$=EXPFILE; }
		|
		Expression			{ if (($1==EXPSTR) && (parmvar==0))
							outputstr(",_spop()");
						  else if (($1==EXPWAVE) && (parmvar==0))
							outputstr(",_wpop()");
						  else if (($1==EXPADDR) && (parmvar==2))
							outputstr(".ar");
						  $$=$1; }
		;

Set:
		'['
		Element_list
		']'
		;

Element_list:
		/* empty */
		|
		Element
		|
		Element_list
		','
		Element
		;

Element:
		Expression
		|
		Expression
		SUBRANGE_TOK
		Expression
		;

Procedure_statement:
		PROCEDURE_VAR			{ fileline(@1.first_line);
						  outputstr($1->cname);
						  outputstr("()");
						  $$=NULL; }
		|
		PROCEDURE_VAR
		'('				{ fileline(@1.first_line);
						  outputstr($1->cname);
						  outputstr("(");
						  PUSHCONTEXT;
						  context=$1;
						  parmno=0;
						  parmvar=getparamtype(context,parmno);
						  if (parmvar==1) outputstr("&");
						  outputstr("("); }
		Actual_parameter_list
		')'				{ outputstr("))");
						  POPCONTEXT; 
						  $$=NULL;
						  parmvar=0; }
		|
		NEW_TOK
		'('
		VARIABLE_VAR
		')'				{ outputstr("_new((char **)&");
						  outputstr($3->cname);
						  outputstr(",sizeof(*");
						  outputstr($3->cname);
						  outputstr("))");
						  $$=NULL;
						}
		;

File_IO_statement:
		RESET_TOK
		'('
		FILE_VAR
		')'				{ fileline(@1.first_line);
						  outputstr("rewind(");
						  outputstr($3->cname);
						  outputstr(")");
						  $$=NULL; }
		|
		RESET_TOK
		'('
		FILE_VAR
		','				{ fileline(@1.first_line);
						  outputstr($3->cname);
						  outputstr("=_reset(("); }
		Expression
		')'				{ if ($6!=EXPSTR)
							if (warning(&@6,"string expression only","")) YYABORT;
						  outputstr(",_spop()");
						  outputstr("))");
						  $$=NULL; }
		|
		REWRITE_TOK
		'('
		FILE_VAR
		')'				{ fileline(@1.first_line);
						  outputstr("rewind(");
						  outputstr($3->cname);
						  outputstr(")");
						  $$=NULL; }
		|
		REWRITE_TOK
		'('
		FILE_VAR
		','				{ fileline(@1.first_line);
						  outputstr($3->cname);
						  outputstr("=_rewrite(("); }
		Expression
		')'				{ if ($6!=EXPSTR)
							if (warning(&@6,"string expression only","")) YYABORT;
						  outputstr(",_spop()");
						  outputstr("))");
						  $$=NULL; }
		|
		CLOSE_TOK
		'('
		FILE_VAR
		')'				{ fileline(@1.first_line);
						  outputstr("_fileclose(");
						  outputstr($3->cname);
						  outputstr(")");
						  $$=NULL; }
		;

Read_statement:
		READ_TOK			{ fileline(@1.first_line);
						  output("{");
						  Filevar=lookupsymbol("input"); }
		'('
		Read_parameters
		')'				{ outputstr("}\n"); 
						  $$=(Symbol *)1; }
		|
		READLN_TOK			{ fileline(@1.first_line);
						  output("{");
						  Filevar=lookupsymbol("input"); }
		'('
		Read_parameters
		')'				{ outputstr("_readln(");
						  outputstr(Filevar->cname);
						  outputstr("); }\n");
						  $$=(Symbol *)1; }
		|
		READLN_TOK			{ fileline(@1.first_line);
						  output("_readln(stdin)");
						  $$=NULL; }
		;

Read_parameters:
		FILE_VAR			{ Filevar=$1; }
		|
		FILE_VAR			{ Filevar=$1; }
		','
		Read_variable_list
		|
		Read_variable_list
		;

Read_variable_list:
		Read_variable
		|
		Read_variable_list
		','
		Read_variable
		;

Read_variable:
						{ pushoutputbuffer(); }
		Variable			{ pushoutputbuffer();
						  outputstr("_READ(");
						  outputstr(Filevar->cname);
						  outputstr(",");
						  outputint((int32)(int)$2);
						  outputstr(",(char *)&(");
						  swapoutputbuffer();
						  popoutputbuffer();
						  popoutputbuffer();
						  output("));"); }
		;

Write_statement:
		WRITE_TOK			{ fileline(@1.first_line);
						  output("{"); 
						  Filevar=lookupsymbol("output"); }
		'('
		Write_parameters
		')'				{ outputstr("}\n");
						  $$=(Symbol *)1; }
		|
		WRITELN_TOK			{ fileline(@1.first_line);
						  output("{");
						  Filevar=lookupsymbol("output"); }
		'('
		Write_parameters
		')'				{ outputstr("_writeln(");
						  outputstr(Filevar->cname);
						  outputstr("); }\n");
						  $$=(Symbol *)1; }
		|
		WRITELN_TOK			{ fileline(@1.first_line);
						  output("_writeln(stdout)");
						  $$=NULL; }
		;

Write_parameters:
		FILE_VAR			{ Filevar=$1; }
		|
		FILE_VAR			{ Filevar=$1; }
		','
		Write_variable_list
		|
		Write_variable_list
		;

Write_variable_list:
		Write_variable
		|
		Write_variable_list
		','
		Write_variable
		;

Write_variable:
						{ pushoutputbuffer(); }
		Write_item			{ pushoutputbuffer();
						  outputstr("_WRITE(");
						  outputstr(Filevar->cname);
						  outputstr(",");
						  outputint((int32)(int)$2);
						  outputstr(",(");
						  swapoutputbuffer();
						  popoutputbuffer();
						  popoutputbuffer();
						  output(");"); }
		;

Write_item:
		Expression			{ if ($1==EXPINT)
							outputstr("),16L,0L");
						  else if ($1==EXPSTR)
							outputstr(",_spop()),0L,0L");
						  else if ($1==EXPWAVE) {
							if (warning(&@1,"cannot print waveforms","")) YYABORT;
						  }
						  else if (($1==EXPBOOL) || ($1==EXPCHAR))
							outputstr("),0L,0L");
						  else
							outputstr("),16L,8L");
						  $$=$1; }
		|
		Expression
		':'				{ if ($1==EXPSTR)
							outputstr(",_spop()");
						  outputstr("),"); }
		Write_field_width		{ if ($4==NULL) {
							if ($1==EXPREAL)
								outputstr(",8L");
							else
								outputstr(",0L");
						  }
						  $$=$1; }
		;

Write_field_width:
		Expression			{ $$=NULL; }
		|
		Expression
		':'				{ outputstr(","); }
		Expression			{ $$=EXPINT; }
		;
		
Goto_statement:
		GOTO_TOK
		INTEGER_NUMBER			{ fileline(@1.first_line);
						  output("goto");
						  outputstr("label_");
						  outputstr($2->name);
						  $$=NULL; }
		;

Empty_statement:
		/* empty */			{ outputstr(";\n");
						  $$=(Symbol *)1; }
		;

Structured_statement:
		Compound_statement		{ $$=$1; }
		|
		Conditional_statement		{ $$=$1; }
		|
		Repetitive_statement		{ $$=$1; }
		|
		With_statement			{ $$=$1; }
		;

Conditional_statement:
		If_statement			{ $$=$1; }
		|
		Case_statement			{ $$=$1; }
		;

If_statement:
		IF_TOK				{ fileline(@1.first_line);
						  outputstr("if ("); }
		Expression			{ if ($3!=EXPBOOL)
							if (warning(&@3,"Boolean expression expected","")) YYABORT; }
		THEN_TOK			{ outputstr(")\n"); }
		Statement			{ if ($7==NULL)
							outputstr(";\n"); }
		Else_part			{ $$=$9; }
		;

Else_part:
		/* empty */			{ $$=(Symbol *)1; }
		|
		ELSE_TOK			{ outputstr("\nelse\n"); }
		Statement			{ $$=$3; }
		;

Case_statement:
		CASE_TOK			{ fileline(@1.first_line);
						  outputstr("switch ((int)"); }
		Expression
		OF_TOK				{ outputstr(") {\n"); }
		Case_list
		END_TOK				{ outputstr("}\n");
						  $$=(Symbol *)1; }
		;

Case_list:
		Case_element
		|
		Case_list
		';'				{ outputstr("break;\n"); }
		Case_element
		;

Case_element:
		/* empty */
		|
		Case_label_list
		':'
		Statement			{ if ($3==NULL)
							outputstr(";\n"); }
		;

Case_label_list:
		Case_label
		|
		Case_label_list
		','
		Case_label
		;

Case_label:
						{ output("case"); }
		Constant			{ outputstr(":\n"); }
		;

Repetitive_statement:
		While_statement			{ $$=$1; }
		|
		Repeat_statement		{ $$=$1; }
		|
		For_statement			{ $$=$1; }
		;

While_statement:
		WHILE_TOK			{ fileline(@1.first_line);
						  outputstr("while ("); }
		Expression			{ if ($3!=EXPBOOL)
							if (warning(&@3,"Boolean expression expected","")) YYABORT; }
		DO_TOK				{ outputstr(")\n"); }
		Statement			{ $$=$7; }
		;

Repeat_statement:
		REPEAT_TOK			{ fileline(@1.first_line);
						  outputstr("do {\n"); }
		Statement_list
		UNTIL_TOK			{ if ($3==NULL)
							outputstr(";\n");
						  outputstr("} while (!("); }
		Expression			{ if ($6!=EXPBOOL)
							if (warning(&@6,"Boolean expression expected","")) YYABORT;
						  outputstr("))");
						  $$=NULL; }
		;

For_statement:
		FOR_TOK
		VARIABLE_VAR			/* THIS SHOULD BE Variable !!!! */
		ASSIGN_TOK			{ if ($2->etype!=(int)EXPINT)
							if (warning(&@2,"only integer variable supported","")) YYABORT;
						  fileline(@1.first_line);
						  outputstr("for (");
						  outputstr($2->cname);
						  outputstr("="); }
		Expression			{ outputstr(";");
						  outputstr($2->cname); }
		Up_down				{ if ((int)($7) > 0)
							outputstr("<=");
						  else
							outputstr(">="); 
						  outputstr("("); }
		Expression
		DO_TOK				{ outputstr(");");
						  outputstr($2->cname);
						  if ((int)($7) > 0)
						  	outputstr("++)\n");
						  else
							outputstr("--)\n"); }
		Statement			{ $$=$12; }
		;

Up_down:
		TO_TOK				{ $$=(Symbol *)1; }
		|
		DOWNTO_TOK			{ $$=(Symbol *)-1; }
		;

With_statement:
		WITH_TOK
		Record_variable_list
		DO_TOK
		Statement			{ if (warning(&@1,"with statement not supported","")) YYABORT; }
		;

Record_variable_list:
		VARIABLE_VAR
		|
		Record_variable_list
		','
		VARIABLE_VAR
		;
%%

/* local includes */
#include <string.h>

/* global variables */
char	filename[80];
FILE	*ip;
FILE	*op;
FILE	*ep;
int	lno;
int	errcnt;
int	errcomments;
int	conly=0;

/* 'C' compiler command line */
char	*cargv[50];
int	cargc=0;

/* compiler command - has sfsbase() as arguments */
char 	*comparg[8]={
#ifdef DJGPP2
	"redir -eo",
#endif
#ifdef MSC32
	"cl -Zp -W3 -WX -I%s\\include",
	"-I%s\\msc32inc -D_POSIX_ -D__STDC__ -DWIN32",
#else
	"gcc -Werror -Wall -I%s/include",
	"-L%s/lib",
#endif
};

/* standard linkage */
char	*stdlink[8]={
#ifdef MSC32
	"%s\\lib\\spc.lib",
#else
	"-lspc -lm",
#endif
};

/* extended linkage - from makefile (use SPCLINK for extra libs) */
char	*xtdlink[8]={
#ifdef MSC32
	"%s\\lib\\spc.lib",
	"%s\\lib\\dig.lib",
	"%s\\lib\\dsp.lib",
	"%s\\lib\\sfs.lib",
#else
	"-lspc -ldig -ldsp -lsfs",
#endif
#ifdef SPCLINK
	SPCLINK,
#endif
#ifndef MSC32
	"-lm",
#endif
};

/* Executable extensions */
char *exextn={
#if defined(DJGPP1) || defined(DJGPP2) || defined(MSC32)
	".exe"
#else
	""
#endif
};

/* system call buffer */
char systemcall[1024];

#include "SFSCONFG.h"
char *sfsbase()
{
	char 		*s;
	static char 	*t = SFS_BASE_DIRECTORY;

	if ((s=getenv("SFSBASE"))) 
		return(s);
	else 
		return(t);
}

/* add string components to carg array */
void addstring(char *str)
{
	char	*p,*strsave();

	p = strtok(str," ");
	while (p && *p) {
		cargv[cargc++] = strsave(p);
		p = strtok(NULL," ");
	}
}

/* main program */
void main(argc,argv)
int	argc;
char	*argv[];
{
	int		optind;
	char		basename[80];
	char		extname[16];
	char		pfilename[80];
	char		cfilename[80];
	char		ofilename[80];
	char		efilename[80];
#if defined(DJGPP1) || defined(MSC32)
	char		outfilename[80]; 
#endif
	char		xfilename[80]; 
	char		*p,*strsave();
	int		spcextensions=0;
	int		i;
	int		toterrs=0;
	char		tempbuf[256];
#if (defined(DJGPP1) || defined(DJGPP2) || defined(MSC32))
	int		oldout,fid;
#endif

	xfilename[0]='\0';

	/* initialise C command line */
	for (i=0;comparg[i];i++) {
		sprintf(tempbuf,comparg[i],sfsbase());
		addstring(tempbuf);
	}

	/* scan compiler agruments */
	for (optind=1;optind<argc;optind++) {
		if (argv[optind][0]=='-') {
			/* a switch of some kind */
			switch (argv[optind][1]) {
			case 'I':	/* identify */
				fprintf(stderr,"%s: Speech Pascal Compiler V%s\n",
					PROGNAME,PROGVERS);
				exit(0);
			case 'C':	/* translate to c only */
				conly++;
				break;
			case 'D':
				yydebug++;
				break;
			default:
				/* pass any other flags over to C command line */
				cargv[cargc++] = strsave(argv[optind]);
				break;
			}
		}
		else {
			/* a filename */
			/* get base part and extension */
			strcpy(basename,argv[optind]);
			strcpy(extname,"");
			if ((p=strrchr(basename,'.'))!=NULL) {
				*p = '\0';
				strcpy(extname,p+1);
			}

			/* do action */
			if (strcmp(extname,"pas")==0) {
				/* standard Pascal */
				strcpy(pfilename,argv[optind]);
				strcpy(cfilename,basename);
				strcat(cfilename,".c");
				strcpy(ofilename,basename);
#ifdef MSC32
				strcat(ofilename,".obj");
#else
				strcat(ofilename,".o");
#endif
				strcpy(efilename,basename);
				strcat(efilename,".err");
				if (!xfilename[0]) {
					strcpy(xfilename,basename);
					strcat(xfilename,exextn);
				}
				toterrs += translate(argv[optind],cfilename,efilename);
				cargv[cargc++] = strsave(cfilename);
			}
			else if (strcmp(extname,"spc")==0) {
				/* Speech extended Pascal */
				strcpy(pfilename,argv[optind]);
				strcpy(cfilename,basename);
				strcat(cfilename,".c");
				strcpy(ofilename,basename);
#ifdef MSC32
				strcat(ofilename,".obj");
#else
				strcat(ofilename,".o");
#endif
				strcpy(efilename,basename);
				strcat(efilename,".err");
				if (!xfilename[0]) {
					strcpy(xfilename,basename);
					strcat(xfilename,exextn);
				}
				toterrs += translate(argv[optind],cfilename,efilename);
				cargv[cargc++] = strsave(cfilename);
				spcextensions++;
			}
			else {
				/* pass anything else on to 'C' compiler */
				cargv[cargc++] = strsave(argv[optind]);
				spcextensions++;
			}
		}
	}

	/* stop here if any errors */
	if (toterrs) {
		sprintf(systemcall,"mergerr %s %s",pfilename,efilename);
		system(systemcall);
		unlink(efilename);
		exit(1);
	}
	if (conly) {
		unlink(efilename);
		exit(0);
	}

	/* put in mandatory link components */
	if (spcextensions) {
		for (i=0;xtdlink[i];i++) {
			sprintf(tempbuf,xtdlink[i],sfsbase());
			addstring(tempbuf);
		}
	}
	else {
		for (i=0;stdlink[i];i++) {
			sprintf(tempbuf,stdlink[i],sfsbase());
			addstring(tempbuf);
		}
	}

	/* put output name */
#ifdef MSC32
//	sprintf(outfilename,"/out:%s.exe",basename);
//	cargv[cargc++] = outfilename;
#else
	cargv[cargc++] = "-o";
#if DJGPP1
	sprintf(outfilename,"%s.out",basename);
	cargv[cargc++] = outfilename;
#else
	cargv[cargc++] = xfilename;
#endif
#endif

	/* OK call 'C' compiler with stdout > spc.err */
#if (defined(DJGPP1) || defined(DJGPP2) || defined(MSC32))
#ifdef SHOW
	for (i=0;i<cargc;i++) printf("%s ",cargv[i]);
	printf("\n");
#endif
	unlink("spc.err");
	fid=open("spc.err",O_CREAT|O_WRONLY,0664);
	oldout = dup(1);
	dup2(fid,1);
#ifdef _MSC_VER
	i = _spawnvp(_P_WAIT,cargv[0],cargv);
#else
	i = spawnvp(P_WAIT,cargv[0],cargv);
#endif
	dup2(oldout,1);
	close(fid);
#else
	strcpy(systemcall,cargv[0]);
	for (i=1;i<cargc;i++) {
		strcat(systemcall," ");
		strcat(systemcall,cargv[i]);
	}
	strcat(systemcall," 2>&1");
	strcat(systemcall," >spc.err");

#ifdef SHOW
puts(systemcall); 
#endif
	i=system(systemcall);
#endif

	/* check for compiler errors */
	if (i) {
		printfile("spc.err");
		sprintf(systemcall,"mergerr %s spc.err",pfilename);
#ifdef SHOW
puts(systemcall); 
#endif
		system(systemcall);
		unlink("spc.err");
		exit(1);
	}

#ifdef DJGPP1
	/* create protected mode .EXE */
	sprintf(systemcall,"coff2exe %s",outfilename);
#ifdef SHOW
puts(systemcall);
#endif
	system(systemcall);
	unlink(outfilename);
#endif

	/* all is well */
	fprintf(stderr,"No errors\n");
	if (errcomments) {
		sprintf(systemcall,"mergerr %s",pfilename);
#ifdef SHOW
puts(systemcall); 
#endif
		system(systemcall);
	}
	unlink("spc.err");
	unlink(cfilename);
	unlink(efilename);
	unlink(ofilename);
	exit(0);
}

int translate(pasf,cf,errf)
char	*pasf;
char	*cf;
char	*errf;
{

	/* open files */
	strcpy(filename,pasf);
	if ((ip=fopen(filename,"r"))==NULL)
		spcerror("unable to open '%s'",filename);
	if ((op=fopen(cf,"w"))==NULL)
		spcerror("unable to open '%s'",cf);
	if ((ep=fopen(errf,"w"))==NULL)
		spcerror("unable to open '%s'",errf);

	errcnt=0;

	resetlex();
	initsymbol();
	yyparse();

	fclose(ip);
	fclose(op);

	if (errcnt==0) {
		fclose(ep);
		unlink(errf);
	}
	else if (errcnt > 20) {
		fprintf(stderr,"%s(%d) more than 20 errors\n",
			filename,lno);
		fprintf(ep,"%s(%d) more than 20 errors\n",
			filename,lno);
		fclose(ep);
	}
	else {
		fprintf(stderr,"%s(%d) %d error%s\n",
			filename,lno,errcnt,(errcnt==1)?"":"s");
		fprintf(ep,"%s(%d) %d error%s\n",
			filename,lno,errcnt,(errcnt==1)?"":"s");
		fclose(ep);
	}

	return(errcnt);
}

/* concatenate files */
void concat(sf1,sf2,df)
char	*sf1;
char	*sf2;
char	*df;
{
	FILE	*ip;
	FILE	*op;
	char	buf[4096];
	int	siz;

	if ((op=fopen(df,"wb"))==NULL)
		spcerror("could not open '%s'",df);
	if ((ip=fopen(sf1,"rb"))==NULL)
		spcerror("could not open '%s'",sf1);
	while ((siz=fread(buf,1,4096,ip)) > 0) {
		if (fwrite(buf,1,siz,op) != siz)
			spcerror("write error on '%s'",df);
	}
	fclose(ip);
	if ((ip=fopen(sf2,"rb"))==NULL)
		spcerror("could not open '%s'",sf2);
	while ((siz=fread(buf,1,4096,ip)) > 0) {
		if (fwrite(buf,1,siz,op) != siz)
			spcerror("write error on '%s'",df);
	}
	fclose(ip);
	fclose(op);
}

/* print a file to standard output */
void printfile(fname)
char *fname;
{
	FILE	*ip;
	int	c;

	if ((ip=fopen(fname,"r"))==NULL) {
		fprintf(stderr,"could not open '%s'",fname);
		fclose(ip);
		return;
	}

	while ((c=getc(ip))!=EOF)
		putchar(c);

	fclose(ip);
}

/* error and warning routines */
/* yacc error routine */
void yyerror(s)
char	*s;
{
	fprintf(stderr,"%s(%d) syntax error in line\n",filename,lno);
	fprintf(ep,"%s(%d) syntax error in line\n",filename,lno);
	errcnt++;
}

int parsefail(s,yylloc)
char	*s;
YYLTYPE	*yylloc;
{
	fprintf(stderr,"%s(%d,%d) %s\n",filename,
				yylloc->first_line,yylloc->first_column,s);
	fprintf(ep,"%s(%d,%d) %s\n",filename,
				yylloc->first_line,yylloc->first_column,s);
	if (errcnt++ > 20)
		return(1);
	else
		return(0);
}

/* print a warning message */
int warning(yylloc,s,t)
YYLTYPE *yylloc;
char	*s,*t;
{
	fprintf(stderr,"%s(%d,%d) ",filename,
				yylloc->first_line,yylloc->first_column);
	fprintf(stderr,s,t);
	fprintf(stderr,"\n");
	fprintf(ep,"%s(%d,%d) ",filename,
				yylloc->first_line,yylloc->first_column);
	fprintf(ep,s,t);
	fprintf(ep,"\n");
	if (errcnt++ > 20)
		return(1);
	else
		return(0);
}

/* print error and die */
void spcerror(s,t)
char	*s,*t;
{
	fprintf(stderr,"%s: ",PROGNAME);
	fprintf(stderr,s,t);
	fprintf(stderr,"\n");
	exit(1);
}
