/*--------------------------------------------------------------------------

COMBINE.C - merge speech items from two SFS files.

Andrew Simpson - University College London

--------------------------------------------------------------------------*/

#define PROGNAME "combine"
#define PROGVERS "1.0"
char	*progname=PROGNAME;

#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include "sfs.h"   

/* level constants */
#define MAXSAMPLE 32767.0
#define TRUE -1
#define FALSE 0

/* manifest constants */
#define BUFSIZE	4096

/* global data */
struct item_header itemS,itemN,newitem;
short	 buffS[BUFSIZE];
short	 buffN[BUFSIZE];
short	 newbuff[BUFSIZE];
char	filenameS[SFSMAXFILENAME],filenameN[SFSMAXFILENAME];

 /* main program */

void main(argc,argv)
int argc;
char *argv[];

{
   /* local variables */
   extern int	optind;		/* option index */
   extern char	*optarg;	/* option argument */
   int c,errflg=0;		/* option char */
   int it,itS=SP_TYPE,itN=SP_TYPE;
   char	*ty,*tyS="0",*tyN="0";
   int	fidS,fidN=-1,newfid;
   int  lenS,lenN,i,sample,maxSample=0;
	int	j;
	
   /* decode switches */
   while ( (c = getopt(argc,argv,"Ii:s:n:N:")) != EOF )
     switch (c)
       {
       case 'I':
       		fprintf(stderr,"%s: Combine (sum) two speech signals V%s\n",
       			PROGNAME,PROGVERS);
       		exit(0);
	 /* signal item */
       case 'i' :
       case 's' :
	 if (itspec(optarg,&it,&ty) == 0)
	   {
	     if (it == SP_TYPE)
	       {
		 itS = it;
		 tyN = ty;
	       }
	   else
	     error("unsuitable item specification %s",optarg);
	   }
	 else
	   error("illegal item specification %s",optarg);
	 break;

       case 'n':
	 strncpy(filenameN,optarg,SFSMAXFILENAME);
	 if ((fidN=sfsopen(filenameN,"r",NULL)) < 0)
	   {
	     if (fidN==-1)
	       error("unable to find noise file '%s'",filenameN);
	     else
	       error("access error on noise file '%s'",filenameN);
	   }
	 break;


	 /* item number in the noise file */
       case 'N' :
	 if (itspec(optarg,&it,&ty) == 0)
	   {
	     if (it == SP_TYPE)
	       {
		 itN = it;
		 tyN = ty;
	       }
	   else
	     error("unsuitable noise file item specification %s",optarg);
	   }
	 else
	   error("illegal noise file item specification in %s",optarg);
	 break;

       case '?' :	/* unknown */
	 errflg++;
       }

   if (errflg || (argc<2))
     error("usage: %s (-i signal_item) -n noise_file (-N noise_item) filename",PROGNAME);

     if (fidN < 0)
     	error("second filename not specified with '-n' switch");
     	
   /* get filenameS */
   if (optind < argc)
     strcpy(filenameS,sfsfile(argv[optind]));
   else
     error("no data file specified",NULL);
   
   /* open file */
   if ((fidS=sfsopen(filenameS,"w",NULL)) < 0)
     {
       if (fidS==-1)
	 error("unable to find signal file '%s'",filenameS);
       else
	 error("access error on '%s'",filenameS);
     }
   
   /* locate input item */
   if (!sfsitem(fidS,itS,tyS,&itemS))
     error("unable to find signal file input item in '%s'",filenameS);
   
   if (!sfsitem(fidN,itN,tyN,&itemN))
     error("unable to find noise file input item in '%s'",filenameN);
   
   /* check that they have the same sampling rates */
   if (itemS.frameduration != itemN.frameduration)
     error("signal and noise items have different sampling rates");

   /* create output item header */
   sfsheader(&newitem,itemS.datatype,itemS.floating,
	     itemS.datasize,itemS.framesize,
	     itemS.frameduration,itemS.offset,
	     itemS.windowsize,itemS.overlap,itemS.lxsync);
   sprintf(newitem.history,"%s(%d.%02d;file=%s,item=%d.%02d)",
	   PROGNAME,
	   itemS.datatype,itemS.subtype,
	   filenameN,itemN.datatype,itemN.subtype);

   /* open output channel */
   if ((newfid=sfschannel(filenameS,&newitem)) < 0)
     error("unable to open output file",NULL);
 
   for (i=0;
	(lenS=sfsread(fidS,i,BUFSIZE,buffS))>0;
	i+=lenS)
     {
       lenN=sfsread(fidN,i,lenS,buffN);	/* get matching block */
       for (j=lenN;j<lenS;j++) buffN[j]=0; /* use zero if too short */
       
       for (sample=0;sample<lenS;sample++)
	 if (abs(newbuff[sample]=buffS[sample]+buffN[sample])
	     >MAXSAMPLE) {
	     	maxSample = buffS[sample]+buffN[sample];
	        error("combined signal clipped (%d)",maxSample);
	 }

       /* write out result of processing */
       if (sfswrite(newfid,lenS,newbuff) != lenS)
	 error("write error on output file",NULL);
     }

   /* update file */
   if (!sfsupdate(filenameS))
     error("update error on %s",filenameS);
	exit(0);
 }
