/* sml.y -- yacc description for SML */
/* version 2.2s */

%{
#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include "sml.h"
%}

/* YACC token identification */
%token	VARTOK,STATTOK,FILETOK,STRINGTOK,INIT,MAIN,SUMMARY,FUNCTOK,RETURNTOK
%token	IFTOK,ELSETOK,WHILETOK,FORTOK,PRINTTOK,INPUTTOK,INPUTLINETOK,FIELD
%token	WITHTOK,WITHNTOK,WITHINTOK,CLEARTOK,ABORTTOK
%token	SWITCHTOK,CASETOK,RANGETOK,PATTERNTOK,DEFAULTTOK
%token	LOBOUNDTOK,HIBOUNDTOK,TRACEONTOK,TRACEOFFTOK
%token	LIBTOK, BREAKTOK
%token	NUMBER,STRING,DUMMYPAR
%token	VAR,STATVAR,STRVAR,FILEVAR
%token	ARRAY,STATARRAY,STRARRAY
%token	FUNCTION,SFUNCTION
%token	UNDEF

/* arithmetic expressions */
%right	'='
%right	UPDATE
%right	'.'
%left	CONCAT SCONCAT
%left	':'
%left	OR
%left	AND
%left	GT GE LT LE EQ NE
%left	'+' '-'
%left	'*' '/' '%'
%left	UNARYMINUS NOT

/* trying to define a program */
%start Program
%%

/* Definition of SML grammar */
Program:	Funcblock
		Globalblock
		Initblock
		Globalblock
		Mainblock
		Globalblock
		Summaryblock			{ code(STOP); }
		;
Funcblock:	/* empty */
		| Funcblock Globalblock Function
		;
Initblock:	/* empty */
		| INIT '{' Localblock Statements '}' '\n'
						{ clearlocals(); }
		;
Mainblock:	/* empty */
		| MAIN '{' 			{ mainpc=pc;
						code(NEXTIPFILE);
						code(STOP);
						globalflag = LOCAL; }
				Localblock 
						{ maindata=$4; }
				Statements '}' '\n'
						{ code(CLOSEDOWN);
						code(maindata);
						code(GOTO);
						code(mainpc);
						memory[mainpc+1] = pc;
						clearlocals(); }
		;
Summaryblock:	/* empty */
		| SUMMARY '{' 
		  Localblock Statements '}' '\n'
						{ clearlocals(); }
		;
Globalblock:					{ globalflag=GLOBAL;
						dummysym();
						code(BLOCK); 
						code(scnt); 
						$$=scnt; }
				Globals
				 		{ setblock($1); 
						globalflag=UNDECLARED; }
		;
Globals:	/* empty */
		| Globals '\n'
		| Globals Vardec
		| Globals Statdec
		| Globals Filedec
		| Globals Stringdec
		;
Localblock:					{ globalflag = LOCAL;
						dummysym();
						code(BLOCK);
						code(scnt);
						$$=scnt; }
				Locals
				 		{ setblock($1);
						globalflag=UNDECLARED; }
		;
Locals:		/* empty */
		| Locals '\n'
		| Locals Vardec
		| Locals Statdec
		| Locals Stringdec
		/* error trapping */
		| Locals Filedec		{ yyerror("illegal local file"); }
		;
Vardec:		VARTOK 				{ vardecflag = VAR; }
				Varlist '\n'	
						{ vardecflag=UNDEF; }
		;
Statdec:	STATTOK 			{ vardecflag = STATVAR; }
				Varlist '\n'	
						{ vardecflag=UNDEF; }
		;
Stringdec:	STRINGTOK 			{ vardecflag = STRVAR; }
				Varlist '\n' 
						{ vardecflag=UNDEF; }
		;
Filedec:	FILETOK 			{ vardecflag = FILEVAR; }
				Filelist '\n'	
						{ vardecflag=UNDEF; }
		;
Varlist:	Varitem
		| Varlist ',' Varitem
		;
Varitem:	UNDEF				{ settype($1,vardecflag,globalflag); }
		| UNDEF '[' NUMBER ':' NUMBER ']'
						{ setarrtype($1,$3,$5,vardecflag,globalflag); }
		;
Filelist:	Fileitem
		| Filelist ',' Fileitem
		;
Fileitem:	UNDEF				{ settype($1,FILEVAR,globalflag); }
		;
Function:	FUNCTOK VARTOK 			{ vardecflag=VAR; }
					UNDEF Funcdec
						{ code(GOTO);
						$$=pc; 
						code(STOP); 
						setfunctype($4,FUNCTION,pc);
						currfunc=$4; }
					Funcbody
						{ code(RETURN);
						code(STOP);
						clearlocals();
						memory[$6]=pc;
						currfunc=0; }
		| FUNCTOK STRINGTOK 		{ vardecflag=STRVAR; }
					UNDEF Funcdec
						{ code(GOTO);
						$$=pc; 
						code(STOP);
						setfunctype($4,SFUNCTION,pc);
						currfunc=$4; }
					Funcbody
						{ code(SRETURN);
						code(STOP);
						clearlocals();
						memory[$6]=pc;
						currfunc=0; }
		| LIBTOK 			{ vardecflag=VAR; }
				UNDEF '\n'
						{ looklib($3);
						vardecflag=UNDEF; }
		;
Funcdec:	'(' Dumparblock ')' Adrparblock
		;
Funcbody:	'{' Valparblock 
						{ checkpars(); }
					Statements '}' '\n'
		;
Dumparblock:					{ vardecflag=DUMMYPAR;
						globalflag=LOCAL;  }
					Dumpars
						{ vardecflag=UNDEF;
						globalflag=UNDECLARED; }
		;
Dumpars:	/* empty */
		| UNDEF				{ settype($1,vardecflag,globalflag); }
		| Dumpars ',' UNDEF		{ settype($3,vardecflag,globalflag); }
		;
Adrparblock:					{ globalflag = ADRPAR;
						dummysym();
						code(BLOCK);
						code(scnt);
						$$=scnt; }
				Adrpars
				 		{ setblock($1);
						globalflag=UNDECLARED; }
		;
Adrpars:	/* empty */
		| Adrpars '\n'
		| Adrpars Varpardec
		| Adrpars Statpardec
		| Adrpars Stringpardec
		| Adrpars Filepardec
		;
Valparblock:					{ globalflag = VALPAR;
						dummysym();
						code(BLOCK);
						code(scnt);
						$$=scnt; }
				Valpars
				 		{ setblock($1);
						globalflag=UNDECLARED; }
		;
Valpars:	/* empty */
		| Valpars '\n'
		| Valpars Varpardec
		| Valpars Statpardec
		| Valpars Stringpardec
		;
Varpardec:	VARTOK				{ vardecflag=VAR; }
					Varparlist '\n'
						{ vardecflag=UNDEF; }
		;
Statpardec:	STATTOK				{ vardecflag=STATVAR; }
					Varparlist '\n'
						{ vardecflag=UNDEF; }
		;
Stringpardec:	STRINGTOK			{ vardecflag=STRVAR; }
					Varparlist '\n'
						{ vardecflag=UNDEF; }
		;
Filepardec:	FILETOK				{ vardecflag=FILEVAR; }
					Fileparlist '\n'
						{ vardecflag=UNDEF; }
		;
Varparlist:	Varparitem
		| Varparlist ',' Varparitem
		;
Fileparlist:	Fileparitem
		| Fileparlist ',' Fileparitem
		;
Varparitem:	UNDEF				{ settype($1,vardecflag,LOCAL); }
		| UNDEF '[' NUMBER ':' NUMBER ']'
						{ setarrtype($1,$3,$5,vardecflag,LOCAL); }
		| DUMMYPAR			{ settype($1,vardecflag,globalflag); }
		| DUMMYPAR '[' ']'		{ setarrtype($1,0,0,vardecflag,globalflag); }
		;
Fileparitem:	UNDEF				{ settype($1,FILEVAR,LOCAL); }
		| DUMMYPAR			{ settype($1,FILEVAR,ADRPAR); }
		;
Statements:	/* empty */
		| Statements '\n'
		| Statements Statement
		/* error trapping */
		| Statements ';'		{ yyerror("illegal ';'"); }
		;
Statement:	Assignment
		| Conditional
		| Whileloop
		| Forloop
		| Switchstat
		| With
		| Printstat
		| Inputstat
		| Clear
		| Abort
		| Function
		| Return
		| Traces
		| Break
		| '{' Statements '}' Newline
		/* error trapping */
		| error '\n'			{ yyerrok; }
		;
Newline:	/* empty */
		| Newline '\n'
		;
Return:		RETURNTOK '(' expr ')'		{ checkreturn(currfunc,FUNCTION);
						code(EXIT); }
		| RETURNTOK '(' strexpr ')'	{ checkreturn(currfunc,SFUNCTION);
						code(EXIT); }
		;
Traces:		TRACEONTOK			{ code(TRACEON); }
		| TRACEOFFTOK			{ code(TRACEOFF); }
		;
Break:		BREAKTOK			{ code(BREAK); }
		;
Assignment:	VAR '=' 			{ code(ADDRVAR);
						code($1); }
					expr
						{ code(STOREVAR); }
		| STRVAR '=' 			{ code(ADDRSTR);
						code($1); }
					strexpr
						{ code(STORESTR); }
		| STATVAR UPDATE 		{ code(ADDRSTAT);
						code($1); }
					expr
						{ code(UPDATESTAT); }
		| ARRAY '[' expr ']' '='
						{ code(ADDRELEMENT);
						code($1); }
					expr
						{ code(STOREVAR); }
		| STRARRAY '[' expr ']' '=' 
						{ code(ADDRSTRELEMENT);
						code($1); }
					strexpr
						{ code(STORESTR); }
		| STATARRAY '[' expr ']' UPDATE 
						{ code(ADDRSTATELEMENT);
						code($1); }
					expr
						{ code(UPDATESTAT); }
		| FILEVAR '=' FILEVAR		{ code(ASSNFILE);
						  code($1);
						  code($3); }
		/* error trapping */
		| STATVAR '=' expr		{ yyerror("cannot assign to 'stat' variable"); }
		;
Printstat:	PRINTTOK 			{ outputvar=lookup("stdout"); }
					Printlist
		| PRINTTOK '#' FILEVAR	 	{ outputvar=$3; }
					Printlist

		;
Inputstat:	INPUTTOK 			{ inputvar=lookup("stdin");
						code(INPUTLINE);
						code(inputvar); }
					Inputlist
		| INPUTTOK '#' FILEVAR	 	{ inputvar=$3; 
						code(INPUTLINE);
						code(inputvar); }
					Inputlist

		| INPUTLINETOK 			{ inputvar=lookup("stdin"); 
						code(INPUTLINE);
						code(inputvar); }
					Inputlineitem
		| INPUTLINETOK '#' FILEVAR	 { inputvar=$3; 
						code(INPUTLINE);
						code(inputvar); }
					Inputlineitem
		;
Conditional:	If Cond Then Statement End End	{ memory[$1] = $3;
						memory[$1+1] = $5;
						memory[$1+2] = $6; }
		|  If Cond Then Statement End
			ELSETOK Statement End	{ memory[$1] = $3;
						memory[$1+1] = $5;
						memory[$1+2] = $8; }
		;
Whileloop:	While Cond Then Statement End	{ memory[$1] = $3;
						memory[$1+1] = $5; }
		;
Forloop:	FORTOK '(' Statement ';'
			For condexpr End ';'
			Then Statement End ')'
			Then Statement End	{ memory[$5] = $13;
						memory[$5+1] = $9;
						memory[$5+2] = $15; }
		;
If:		IFTOK				{ code(CONDITION);
						$$ = pc;
						code(STOP);
						code(STOP);
						code(STOP); }
		;
While:		WHILETOK			{ code(WHILECODE);
						$$ = pc;
						code(STOP);
						code(STOP); }
		;
For:		/* empty */			{ code(FORCODE);
						$$ = pc;
						code(STOP);
						code(STOP);
						code(STOP); }
		;
Cond:		'(' condexpr ')'		{ code(STOP); }
		;
Then:		/* empty */			{ $$ = pc; }
		;
End:		/* empty */			{ code(STOP);
						$$ = pc; }
		;
Switchstat:	SWITCHTOK '(' 
						{ code(SWITCH);
						code(STOP);
						$$=pc;
						code(STOP); }
				Switchrest
						{ code(STOP);
						memory[$3]=pc;
						switchtype=ppop(); }
		;
Switchrest:					{ $$=pc; }
				expr ')'
						{ ppush(switchtype);
						switchtype=VAR;
						code(STOP);
						memory[$1-2]=pc; }
				'{' Switchblocks '}'
		| 				{ $$=pc; }
				strexpr ')'
						{ ppush(switchtype);
						switchtype=STRVAR;
						code(STOP);
						memory[$1-2]=pc; }
				'{' Switchblocks '}'
		;
Switchblocks:	/* empty */
		| Switchblocks '\n'
		| Switchblocks Switchblock
		;
Switchblock:	CASETOK NUMBER ':'
						{ if (switchtype!=VAR)
							yyerror("bad case");
						code(CASE);
						code($2);
						$$=pc;
						code(STOP); }
				Statement
						{ code(STOP);
						memory[$4]=pc; }
		| CASETOK STRING ':'
						{ if (switchtype!=STRVAR)
							yyerror("bad case");
						code(STRCASE);
						code($2);
						$$=pc;
						code(STOP); }
				Statement
						{ code(STOP);
						memory[$4]=pc; }
		| PATTERNTOK STRING ':'
						{ if (switchtype!=STRVAR)
							yyerror("bad case");
						if (patcomp($2)!=0)
							yyerror("bad regular expression");
						code(PATCASE);
						code($2);
						$$=pc;
						code(STOP); }
				Statement
						{ code(STOP);
						memory[$4]=pc; }
		| RANGETOK NUMBER ':' NUMBER ':'
						{ if (switchtype!=VAR)
							yyerror("bad case");
						code(RANGECASE);
						code($2);
						code($4);
						$$=pc;
						code(STOP); }
				Statement
						{ code(STOP);
						memory[$6]=pc; }
		| DEFAULTTOK ':'
						{ code(DEFCASE); }
				Statement
						{ code(STOP); }
		;
With:		Withhead Statement End		{ memory[$1] = $3; }
		;
Withhead:	WITHTOK '(' strexpr ')'		{ code(WITH);
						$$ = pc;
						code(STOP); }
		| WITHNTOK '(' strexpr ',' expr ')'
						{ code(WITHN);
						$$ = pc;
						code(STOP); }
		| WITHINTOK '(' expr ',' expr ')'
						{ code(WITHIN);
						$$ = pc;
						code(STOP); }
		;
Printlist:	Printitem
		| Printlist ',' Printitem
		;
Inputlist:	Inputitem
		| Inputlist ',' Inputitem
		;
Printitem:	expr				{ code(PRINTVAL);
						code(outputvar); }
		| expr ':' expr			{ code(PRINTVAL1);
						code(outputvar); }
		| expr ':' expr ':' expr	{ code(PRINTVAL2);
						code(outputvar); }
		| strexpr			{ code(PRINTSTR);
						code(outputvar); }
/*
		| strexpr ':' expr		{ code(PRINTSTR1);
						code(outputvar); }
*/
		;
Inputitem:	VAR				{ code(ADDRVAR);
						code($1);
						code(READVAL); }
		| STRVAR			{ code(ADDRSTR);
						code($1); 
						code(READSTR); }
		| ARRAY	'[' expr ']'		{ code(ADDRELEMENT);
						code($1);
						code(READVAL); }
		| STRARRAY '[' expr ']'		{ code(ADDRSTRELEMENT);
						code($1);
						code(READSTR); }
		;
Inputlineitem:	STRVAR				{ code(ADDRSTR);
						code($1); 
						code(READLINE); }
		| STRARRAY '[' expr ']'		{ code(ADDRSTRELEMENT);
						code($1);
						code(READLINE); }
		;
Clear:		CLEARTOK '(' VAR ')'		{ code(CLEAR); code($3); }
		| CLEARTOK '(' STATVAR ')'	{ code(CLEAR); code($3); }
		| CLEARTOK '(' STRVAR ')'	{ code(CLEAR); code($3); }
		| CLEARTOK '(' ARRAY ')'
						{ code(CLEARARRAY); code($3); }
		| CLEARTOK '(' STATARRAY ')'
						{ code(CLEARARRAY); code($3); }
		| CLEARTOK '(' STRARRAY ')'
						{ code(CLEARARRAY); code($3); }
		| CLEARTOK '(' ARRAY '[' expr ']' ')'
						{ code(CLEARELEMENT); code($3); }
		| CLEARTOK '(' STATARRAY '[' expr ']' ')'
						{ code(CLEARELEMENT); code($3); }
		| CLEARTOK '(' STRARRAY '[' expr ']' ')'
						{ code(CLEARELEMENT); code($3); }
		;
Abort:		ABORTTOK '(' strexpr ')'	{ code(ABORT); }
		;
Function:	func				{ code(ABORTTEST); }
		;
func:		FUNCTION '(' 			{ ppush(currfunc);
						currfunc=$1;
						ppush(parnum);
						parnum=$1; }
					Paramlist ')'	
						{ checkcall($1,parnum);
						parnum=ppop();
						currfunc=ppop();
						code(CALL); code($1); }
		;
sfunc:		SFUNCTION '(' 			{ ppush(currfunc);
						currfunc=$1;
						ppush(parnum);
						parnum=$1; }
					Paramlist ')'	
						{ checkcall($1,parnum);
						parnum=ppop();
						currfunc=ppop();
						code(CALL); code($1); }
		;
Paramlist:	/* empty */
		| Param
		| Paramlist ',' Param
		;
Param:		VAR				{ code(ADDRVAR);
						code($1);
						callcode(&parnum,VAR,LOADVAR,currfunc); }
		| ARRAY '[' expr ']'		{ code(ADDRELEMENT);
						code($1);
						callcode(&parnum,VAR,LOADVAR,currfunc); }
		| ARRAY				{ code(ADDRARRAY);
						code($1);
						callcode(&parnum,ARRAY,STOP,currfunc); }
		| STRVAR			{ code(ADDRSTR);
						code($1);
						callcode(&parnum,STRVAR,LOADSTR,currfunc); }
		| STRARRAY '[' expr ']'		{ code(ADDRSTRELEMENT);
						code($1);
						callcode(&parnum,STRVAR,LOADSTR,currfunc); }
		| STRARRAY			{ code(ADDRSTRARRAY);
						code($1);
						callcode(&parnum,STRARRAY,STOP,currfunc); }
		| STATVAR			{ code(ADDRSTAT);
						code($1);
						callcode(&parnum,STATVAR,STOP,currfunc); }
		| STATARRAY '[' expr ']'	{ code(ADDRSTATELEMENT);
						code($1);
						callcode(&parnum,STATVAR,STOP,currfunc); }
		| STATARRAY			{ code(ADDRSTATARRAY);
						code($1);
						callcode(&parnum,STATARRAY,STOP,currfunc); }
		| FILEVAR			{ code(LOADFILE);
						code($1);
						callcode(&parnum,FILEVAR,STOP,currfunc); }
/*
		| NUMBER			{ code(LOADVARCONST);
						code($1);
						callcode(&parnum,NUMBER,STOP,currfunc); }
		| STRING			{ code(LOADSTRCONST);
						code($1);
						callcode(&parnum,STRING,STOP,currfunc); }
*/
		| expr				{ callcode(&parnum,NUMBER,STOP,currfunc); }
		| strexpr			{ callcode(&parnum,STRING,STOP,currfunc); }
		;
expr:		NUMBER				{ code(LOADVARCONST); 
						code ($1); }
		| VAR				{ code(ADDRVAR); 
						code($1);
						code(LOADVAR); }
		| ARRAY '[' expr ']'		{ code(ADDRELEMENT);
						code($1);
						code(LOADVAR); }
		| STATVAR '.' FIELD		{ code(ADDRSTATFIELD);
						code($1); 
						code($3);
						code(LOADVAR); }
		| STATARRAY '[' expr ']' '.' FIELD
						{ code(ADDRSTATELEMENTFIELD);
						code($1);
						code($6);
						code(LOADVAR); }
		| LOBOUNDTOK '(' ARRAY ')'	{ code(LOBOUND);
						code($3); }
		| HIBOUNDTOK '(' ARRAY ')'	{ code(HIBOUND);
						code($3); }
		| LOBOUNDTOK '(' STRARRAY ')'	{ code(LOBOUND);
						code($3); }
		| HIBOUNDTOK '(' STRARRAY ')'	{ code(HIBOUND);
						code($3); }
		| LOBOUNDTOK '(' STATARRAY ')'	{ code(LOBOUND);
						code($3); }
		| HIBOUNDTOK '(' STATARRAY ')'	{ code(HIBOUND);
						code($3); }
		| func
		| expr '+' expr			{ code(PLUS); }
		| expr '-' expr			{ code(MINUS); }
		| expr '%' expr			{ code(MODULUS); }
		| expr '*' expr			{ code(TIMES); }
		| expr '/' expr			{ code(DIVIDE); }
		| '-' expr %prec UNARYMINUS	{ code(NEGATE); }
		| '(' expr ')'
		/* error trapping */
		| STATVAR			{ yyerror("illegal use of 'stat' variable"); }
		| STATARRAY '[' expr ']'	{ yyerror("illegal use of 'stat' array"); }
		;
condexpr:	expr				{ code(ERRCHECK); }
		| expr GT expr			{ code(GTCODE); }
		| expr GE expr			{ code(GECODE); }
		| expr LT expr			{ code(LTCODE); }
		| expr LE expr			{ code(LECODE); }
		| expr EQ expr			{ code(EQCODE); }
		| expr NE expr			{ code(NECODE); }
		| condexpr OR condexpr		{ code(ORCODE); }
		| condexpr AND condexpr		{ code(ANDCODE); }
		| NOT condexpr			{ code(NOTCODE); }
		| '(' condexpr ')'
		/* error trapping */
		| expr '=' expr			{ yyerror("incorrect equals operator"); }
		;
strexpr:	STRING				{ code(LOADSTRCONST);
						code($1); }
		| STRVAR			{ code (ADDRSTR); 
						code($1);
						code(LOADSTR); }
		| STRARRAY '[' expr ']'		{ code(ADDRSTRELEMENT); 
						code($1);
						code(LOADSTR); }
		| sfunc
		| strexpr ':' Strcut
		| strexpr CONCAT strexpr	{ code(STRCAT); }
		| strexpr SCONCAT strexpr	{ code(STRSCAT); }
		| '(' strexpr ')'
		/* error trapping */
		| strexpr '+' strexpr		{ yyerror("incorrect concatenation operator"); }
		;
Strcut:		expr				{ code(STRCUT); }
		| expr ':' expr			{ code(STRCUT2); }
		;
%%

/* push and pop routines for syntax variables */
int	ssp=0,sstack[40];
void ppush(i)
int i;
{
	sstack[ssp++]=i;
}
int	ppop()
{
	return(sstack[--ssp]);
}

/* global variables */
int	lineno=1;		/* start at source file line 1 */
int	globalflag=GLOBAL;	/* assume global data block at first */
int	vardecflag=UNDEF;	/* data block undefined */
int	filereport=1;		/* report file errors */
char	dictionary[80]="/usr/dbase/data/phon.dic";
				/* default phonetic dictionary */

/* main program */
void main(argc,argv)
int	argc;
char	*argv[];
{
	/* command line decoding */
	extern int	optind;
	extern char	*optarg;
	char		c;
	int		errflg=0;
	char		filename[80];
	int32		it;
	char		*ty;
	/* program options */
	int		symtreq=0;	/* symbol table not required */
	int		codereq=0;	/* code listing not required */
	int		execute=1;	/* execution required */
	int		statreq=0;	/* run time stats not required */
	/* timing variables */
	long		tbuf1[4],tbuf2[4],tbuf3[4];

	/* store program name */
	progname = argv[0];

	/* decode switches */
	while ( (c = getopt(argc,argv,"IsScCtTrfi:d:")) != EOF )
		switch (c) {
		case 'I' :	/* Identify */
			fprintf(stderr,"%s: Speech Measurement Language interpreter V%s\n",PROGNAME,PROGVERS);
			exit(0);
			break;
		case 's' :	/* symbol table dump required */
			symtreq++;
			execute=0;
			break;
		case 'S' :	/* full symbol table dump required */
			startnew=0;
			symtreq++;
			execute=0;
			break;
		case 'c' :	/* source+code listing required */
			codereq=2;
			execute=0;
			break;
		case 'C' :	/* code listing only required */
			codereq=1;
			execute=0;
			break;
		case 't' :	/* source trace mode */
			runtrace=1;
			break;
		case 'T' :	/* code trace mode */
			runtrace=2;
			break;
		case 'r' :	/* run-time stats required */
			statreq++;
			break;
		case 'f' :	/* file check reporting disabled */
			filereport=0;
			break;
		case 'i' :	/* input specification */
			if (itspec(optarg,&it,&ty) == 0)
				cltype[it]=ty;
			else
				error("illegal item spec. %s",optarg);
			break;
		case 'd' :	/* phonetic dictionary */
			strcpy(dictionary,optarg);
			break;
		case '?' :	/* unknown */
			errflg++;
	}
	if (errflg || (argc<2)) 
		error("usage: %s (-I) (-s|-S) (-c|-C) (-t|-T) (-r) (-f) (-i item) (-d dic) program dbfilelist",progname);

	/* get program filename */
	if (optind < argc)
		strcpy(filename,argv[optind]);
	else
		error("no program file specified",NULL);
	/* open program file */
	if ((ip=fopen(filename,"r")) == NULL) {
		fprintf(stderr,"cannot open %s\n",filename);
		exit(1);
	}
	/* rest of arguments are files for analysis */
	gargc=argc-optind;		/* number of dbase files + 1 */
	gargv=argv+optind;		/* gargv[1] = first file */
	/* start compile clock */
	times(tbuf1);
	/* initialise symbol table */
	init();
	/* compile program */
	if (yyparse())
		error("compilation of %s aborted",filename);
	else if (errors > 0)
		fprintf(stderr,"%s: %d error(s)\n",progname,errors);
	else if (errors == 0) {
		if (symtreq) dumpstab();
		if (codereq==1) dumpcode(); 
		else if (codereq==2) dumpscode(filename);
		if (!execute) exit(0);
		/* start run-time clock */
		times(tbuf2);
		/* run program */
		prepare();
		run(0);
		if (graphicson) digquit(1);
		times(tbuf3);
		if (statreq) {
			fprintf(stderr,"----- sml run complete -----\n");
			fprintf(stderr,"compile time = %.2g seconds\n",(tbuf2[0]-tbuf1[0]+tbuf2[1]-tbuf1[1])*1.0/60.0);
			fprintf(stderr,"run time     = %.2g seconds\n",(tbuf3[0]-tbuf2[0]+tbuf3[1]-tbuf2[1])*1.0/60.0);
			fprintf(stderr,"symbol table: used %d from %d.\n",scnt,MAXSYM);
			fprintf(stderr,"machine code: used %d from %d.\n",pc,MAXCODE);
		}
	}
	/* that's all folks */
	exit(0);
}

/* yacc error routine */
void yyerror(s)
char	*s;
{
	warning(s,(char *) 0);
}

/* print a warning message */
extern int c;
void warning(s,t)
char	*s,*t;
{
	errors++;
	fprintf(stderr,"%s: %s",progname,s);
	if (t) fprintf(stderr," \"%s\"",t);
	fprintf(stderr," near line %d\n",lineno);
/*
	while (c != '\n' && c != EOF) c=getc(ip);
	if (c == '\n') lineno ++;
*/
}

