{ dftuse - SPC DFT usage }
program dftuse;

{$I tools.inc }
{$I dft.inc }

const
     sampsize=64;          { # samples of sinewave }
     samprate=1000.0;      { sampling rate of sine }
     sinefreq=250.0;       { sinewave frequency }

var
     wv:waveform;          { sine waveform }
     rwv:realwave;         { real version of sine }
     spect:realspectrum;   { output spectrum }
     i:integer;            { counter }
     len:integer;          { # harmonics }

{$I sinewave.spc }

begin
     { get sine wave }
     wv := sinewave(sampsize,samprate,sinefreq);

     { copy into real variable }
     for i:=0 to sampsize-1 do
          rwv[i] := wv._data[i];

     { perform DFT }
     len := DFT(rwv,sampsize,spect);

     { print result }
     for i:=0 to len-1 do
                write(round(spect[i]):1,' ');
     writeln;
end.
