{ wordplay -- play sections of signal from word annotated file }
program wordplay;

{$I tools.inc }

var
	fname:string;
	sprate:real;
	ptr:annotation_record_ptr;
	wv:waveform;

begin
	write ('Enter SFS filename: ');
	readln(fname);
	if not SFSFile(fname) then
		abort(fname+' is not an SFS file.')
	else if not SFSItem('sp') then
		abort(fname+' does not contain a Speech item.')		
	else if not SFSItem('an') then
		abort(fname+' does not contain an Annotation item.')
	else begin
		sprate := SpeechRate;
		if not AnnotationLoad(sprate) then
			abort('could not load annotations');
	end;

	ptr := annot_base_ptr;
	if ptr <> nil then repeat
		if ptr^.next <> nil then begin
			write(ptr^.annot);
			wv := SpeechPart(ptr^.sample,ptr^.next^.sample);
			ReplayWaveform(wv);
			writeln;
		end;
		ptr := ptr^.next;
		if ptr <> nil then ptr := ptr^.next;
	until ptr = nil;
end.
