{ speech.inc -- SFS Speech Waveform interface for SPC 1.0 }

{ SFS Speech Item functions }
external function SpeechSize:integer;
external function SpeechRate:real;
external function SpeechLoad:waveform;
external function SpeechPart(first_sample,last_sample:integer):waveform;
external procedure SpeechSave(file_name:string;sp_history:string;var sp_wv:waveform);

{ readwave - simple read waveform function }
function ReadWave(file_name:string;sp_item:string):waveform;
begin
	if not SFSFile(file_name) then
		abort(file_name+' is not an SFS file');
	if not SFSItem(sp_item) then
		abort('could not find item "'+sp_item+'" in '+file_name);
	ReadWave := SpeechLoad;
end;

{ readwavean - simple read waveform and annotation function }
function ReadWaveAn(file_name:string;sp_item:string;an_item:string):waveform;
var
	wv:waveform;
begin
	if not SFSFile(file_name) then
		abort(file_name+' is not an SFS file');
	if not SFSitem(sp_item) then
		abort('could not find item "'+sp_item+'" in '+file_name);
	wv := SpeechLoad;
	if not SFSItem(an_item) then
		abort('could not find item "'+an_item+'" in '+file_name);
	if not LoadAnnotations(annot_base_ptr,wv._rate) then
		abort('could not load annotations from '+file_name);
	ReadWaveAn := wv;
end;

{ readwaveregion - simple read annotated waveform region function }
function ReadWaveRegion(file_name:string;sp_item:string;
		an_item:string;an_label:string):waveform;
var
	sprate:real;
	s1,s2:integer;
begin
	if not SFSFile(file_name) then
		abort(file_name+' is not an SFS file');
	if not SFSItem(sp_item) then
		abort('could not find item "'+sp_item+'" in '+file_name);
	sprate := SpeechRate;
	if not SFSItem(an_item) then
		abort('could not find item "'+an_item+'" in '+file_name);
	if not LoadAnnotations(annot_base_ptr,sprate) then
		abort('could not load annotations from '+file_name);
	if not AnnotationFind(an_label,s1,s2) then
		abort('could not find annotation "'+an_label+'" in '+file_name);
	if not SFSItem(sp_item) then
		abort('could not find item "'+sp_item+'" in '+file_name);
	ReadWaveAn := SpeechPart(s1,s2);
end;

