/* SFSCONFG -- configuration parameters for SFS implementation */

#ifndef SFSCONFG_H
#define SFSCONFG_H

/************ Special machine/compiler dependencies *************/
/* choose one */

#undef SUN4			/* SPARC with SUNOS 4.1.x */

#undef HP			/* HP-UX RISC */

#undef MASSCOMP			/* Masscomp RTU-4 */

#undef ALPHA			/* digital ALPHA */

#define LINUX			/* LINUX on x86 PC */

#undef DOS			/* MS-DOS with GNU C++ */

/****** define a 32-bit integer for this machine/compiler ********/
typedef int int32;

/* any machine/compiler specific defines */
#define __USE_FIXED_PROTOTYPES__

#if defined(SUN4) || defined(ALPHA) || defined(HP)
#define SFS_SWAP_HEADER 1		/* fix 32-bit alignment */
#endif

/********************* byte ordering **************************/
/* choose one */

#define SFSMACHINE	0x01010101 	/* 0x00000000 = big .. little */
					/* 0x01010101 = little .. big */

/********************* SFS Home Directory **********************/
/* specify, used when SFSBASE variable not set */

#define SFS_BASE_DIRECTORY	"c:/sfs"

/***************** Device-Independent Graphics ******************/
/* select graphics devices available on system */

#undef	EVm			/* Masscomp Medium Colour */
				/* needs -lmr */
#undef	EVb			/* BBC GTERM terminal */
#undef	EVt			/* Tektronix terminals */
#undef	EVa			/* UCl/ANSI terminals */
#undef	EVk			/* Kyocera laser printer */
#undef	EVs			/* Sun monochrome console & suntools */
				/* needs -lsunwindow -lsuntools -lpixrect */
#define	EVp			/* Postscript printer and EPS files */
#undef	EVv			/* PC VGA graphics with libgrx */
#undef	EVw			/* WordPerfect .WPG output */
#define EVB			/* GIF bitmap output */
#undef	EVx			/* X-Windows terminal using X-View */
				/* needs -lxview -lolgx -lX11 */
#undef EVX			/* X-Windows bare */
				/* needs -lX11 */
#define EVe			/* Epson colour stylus pro output */

/* default graphics types - when GTERM & GPRINT not set */
#define DIG_DEFAULT_DEVICE_TYPE	'X'
#define DIG_DEFAULT_DEVICE_SUB	0
#define DIG_DEFAULT_PRINT_TYPE	'p'
#define DIG_DEFAULT_PRINT_SUB	0

/* command line to send chars to printer */
#define DIGPIPE "lp"		/* may be used or separately defined
				   in device driver */

/***************** Data Acquisition System **********************/
/* select generic devices available on system */

#undef	ADC_AVAIL		/* Analogue-to-Digital Converter */
#define	DAC_AVAIL		/* Digital-to-Analogue Converter */
#undef	PIO_AVAIL		/* Parallel Input-Output */

/* DAC select supported devices */
#ifdef DAC_AVAIL
#undef	DAC_SUN8		/* Sun 8-bit ulaw converter */
#undef	DAC_SUN16		/* Sun 16-bit DBRI device */
#undef	DAC_MASSCOMP		/* Masscomp DA08 */
#undef	DAC_ANSI		/* character/stdout replay */
#undef	DAC_DOS_PP		/* PC parallel printer DAC */
#undef	DAC_DOS_DT2811		/* Data Translation 2811 board */
#undef	DAC_DOS_PCLX		/* Laryngograph PCLX board */
#undef	DAC_DOS_PP		/* UCL parallel printer 12-bit DAC */
#undef	DAC_DOS_EB12		/* UCL expansion bus 12-bit DAC */
#undef	DAC_DOS_BLAST8		/* SoundBlaster-8 compatible */
#undef	DAC_DOS_BLAST16		/* SoundBlaster-16 compatible */
#undef	DAC_EXTEND		/* replay using Vista Extend (X-terminal/PC) */
#define	DAC_PIPE                /* send to a script 'bin/dacpipe' */
#undef	DAC_WIN32		/* WIN32 API uses winmm.lib */
#define	DAC_LINUX               /* output to Linux Audio device */
#endif

/* default DAC device - when DAC not set */
#define DAC_DEFAULT_DEVICE "pipe"

/* DAC pathnames of channels */
#ifdef DAC_LINUX
#define DAC_LINUX_PATH	"/dev/dsp"
#endif

#ifdef DAC_SUN8
#define DAC_SUN8_PATH	"/dev/audio"
#endif
#ifdef DAC_SUN16
#define DAC_SUN16_PATH	"/dev/audio"
#endif
#ifdef DAC_MASSCOMP
#define DAC_MASSCOMP_CLK	"/dev/dacp0/clk0"	/* DAC Clock */
#define DAC_MASSCOMP_CHAN	"/dev/dacp0/daf0"	/* DAC channel */
#endif

/* ADC select supported devices */
#ifdef ADC_AVAIL
#define	ADC_SUN16		/* SPARC DBRI 16 bit interface */
#undef 	ADC_MASSCOMP		/* Masscomp AD12F */
#undef	ADC_DOS_BLAST16		/* SoundBlaster 16 */
#endif

/* ADC pathnames of channels */
#ifdef ADC_SUN16
#define ADC_SUN16_PATH		"/dev/audio"
#endif
#ifdef ADC_MASSCOMP
#define ADC_MASSCOMP_CLK	"/dev/dacp0/clk0"	/* ADC clock */
#define ADC_MASSCOMP_CHAN	"/dev/dacp0/adf0"	/* ADC channel */
#endif

/* PIO select supported devices */
#ifdef PIO_AVAIL
#define	PIO_MASSCOMP		/* Masscomp PF16 */
#endif

/* PIO pathnames of channels */
#ifdef PIO_MASSCOMP
#define PIO_MASSCOMP_CHAN	"/dev/dacp0/pfo0"	/* PIO channel */
#endif

/********************* Array processor **************************/

#undef	AP_AVAIL		/* Masscomp Array processor */

#endif
