/* glmode -- set line drawing mode */

#include "SFSCONFG.h"
#include <stdio.h>
#include <unistd.h>
#include "dig.h"
#include "digdata.h"
#include "digtable.h"

/* set line drawing mode to 'replace' or 'invert' */
int 	diglinemode(mode)
int	mode;			/* 0=replace, 1=xor */
{
	int	retcode;
	
	/* flush any existing lines */
	digflush();

	/* check device has raster modes */
	if (digtable[digdata.select].rasterop)
		/* ok - call it */
		retcode = (*digtable[digdata.select].rasterop)(mode);
	else if (mode)
		/* non-zero modes not supported */
		retcode = -1;
	else
		/* zero mode always supported */
		retcode = 0;
	return(retcode);
}

#ifdef EMO
main()
{
	digstart('\0',NULL,1);
	digscale(5.0,4.0,1);
	digclearscreen();

	digfont("triplro");

	if (diglinemode(1) >= 0) {
		digboxtext(24,2.5,1.0,5.0,3.0,0.0,"HELLO",1);
		sleep(2);
		digboxtext(20,2.5,1.0,5.0,3.0,0.0,"GOODBYE",1);
		sleep(2);
		digboxtext(24,2.5,1.0,5.0,3.0,0.0,"HELLO",1);
	}
	diglinemode(0);

	digtext(20,1.0,3.2,"Normal");
	digtext(20,2.0,3.2,"Inverted");
	diglinemode(1);
	digfillbox(0,2.0,3.2,
			2.0+8*digdata.chwidth/digdata.xscale,
			3.2+digdata.chheight/digdata.yscale);
	digline(15,0.5,3.95,4.0,3.95);
	digline(16,0.5,3.90,4.0,3.90);
	digline(17,0.5,3.85,4.0,3.85);
	digline(18,0.5,3.80,4.0,3.80);
	digline(19,0.5,3.75,4.0,3.75);
	digline(20,0.5,3.70,4.0,3.70);
	digline(21,0.5,3.65,4.0,3.65);
	digline(22,0.5,3.60,4.0,3.60);
	digline(23,0.5,3.55,4.0,3.55);
	digline(24,0.5,3.50,4.0,3.50);

	diglinemode(0);
	digquit(15);
}
#endif
