/* digprompt -- type string on top line of graphics window */

#include <stdio.h>
#include "SFSCONFG.h"
#include "dig.h"
#include "digdata.h"
#include "digtable.h"

void	digprompt (str)
char	*str;
{
	int	len=strlen(str);
	char	c;

	/* flush any graphics */
	digflush();

	/* see if device has special routine */
	if (digtable[digdata.select].prompt)
		(*digtable[digdata.select].prompt)(str);
	else {
		/* simulate it */
		digfillboxp(0,0,digdata.nvert-digdata.chheight-2,
				digdata.nhoriz,digdata.nvert);
		if (len > (digdata.nhoriz/digdata.chwidth)) {
			len = digdata.nhoriz/digdata.chwidth;
			c=str[len];
			str[len]='\0';
			digtextp(24,0,digdata.nvert-digdata.chheight-1,str);
			str[len]=c;
		}
		else
			digtextp(24,0,digdata.nvert-digdata.chheight-1,str);
		
	}

	digdata.xpen = strlen(str) * digdata.chwidth;	
}

#ifdef EMO
#include <stdio.h>
main()
{
	digstart('\0',NULL,1);
	digscale (4.0,4.0,1);
	digorigin(2.0,2.0);
	digclip(-1.0,-1.0,1.0,1.0);

	/* Draw the clip limit	*/
	digprompt("draw the clip limit :");
	getchar();
	digline(20,-1.0,-1.0,-1.0,1.0);
	digline(20,-1.0,1.0,1.0,1.0);
	digline(20,1.0,1.0,1.0,-1.0);
	digline(20,1.0,-1.0,-1.0,-1.0);

	/* Draw a rotated square	*/
	digprompt("draw a rotated square :");
	getchar();
	digline(21,-1.3,-0.6,-0.6,1.3);
	digline(21,-0.6,1.3,1.3,0.6);
	digline(21,1.3,0.6,0.6,-1.3);
	digline(21,0.6,-1.3,-1.3,-0.6);

	digprompt("RETURN to exit :");
	digquit(15);
}
#endif
