/* wp.h -- WordPerfect structures and definitions */

/* from prefix.inc in WordPerfect Toolkit */

/* M.A.Huckvale - Tundra Software Ltd. - August 1991 */

/* Product Names */
#define PFWP	1		/* WordPerfect */
#define PFSHELL	2		/* Shell */
#define PFNB	3		/* Notebook */
#define PFCALC	4		/* Calculator */
#define PFSDIR	5		/* File Manager (SDIR) */
#define PFCL	6		/* Calendar */
#define PFPE	7		/* P-Edit */
#define PFME	8		/* Macro editor */
#define PFMP	9		/* PlanPerfect (MathPlan) */
#define PFDP	10		/* DataPerfect */
#define PFML	11		/* Mail */
#define PFPP	12		/* Printer Program (PTR) */
#define PFSCH	13		/* Scheduler Program */
#define PFOFC	14		/* WordPerfect Office */
#define PFDR	15		/* DrawPerfect */
#define PFDM	19		/* Document Manager */

/* Below are the assignments for file types. */

/* The first 10 (0-9) are reserved for general purpose files. */
/* The naming convention for other file types is:  use the first 4 */
/* characters from the product name's equate and add up to 3 */
/* characters describing the file type. */

#define PFMAC	1		/* macro file */
#define PFHELP	2		/* help file */
#define PFKYBD	3		/* keyboard definition file */
#define PFVAXKB	4		/* vax specific keyboard definition file */

/* file types for WP */
#define PFWPDOC	10		/* wordperfect document */
#define PFWPDCT	11		/* dictionary - wordlist */
#define PFWPTH	12		/* thesaurus */
#define PFWPBLK	13		/* block */
#define PFWPRB	14		/* rectangular block */
#define PFWPCLM	15		/* column block */
#define PFWPPRN	16		/* .prs file */
#define PFWPSYS	17		/* {wp}sys.fil */
#define PFWPALL	19		/* .all file */
#define PFWPDRS	20		/* .drs file */
#define PFWPFIL	21		/* wp.fil file */
#define PFWPGIF	22		/* WPG graphics file */
#define PFWPHYC	23		/* hyphenation code module */
#define PFWPHYD	24		/* hyphenation data module */
#define PFWPMRS	25		/* .mrs files */

#define PFWPHYL	27		/* hyphenation lex module */
#define PFWPPQC	28		/* printer Q codes (used by VAX/DG) */
#define PFWPDCW	29		/* spell code module - wordlist */
#define PFWPQRS	30		/* 5.1 equation resource file (wp.qrs) */

#define PFWPDCA	33		/* spell code module - rules */
#define PFWPDSA	34		/* dictionary - rules */
#define PFWPVRS	36		/* .vrs files */

#define PFWPDCF	39		/* spell code module - Microlytics rules based */
#define PFWPDML	40		/* dictionary - Microlytics rules based */
#define PFWPINS	41		/* WP51.INS file  (install options file) */
#define PFWPIRS	42		/* .irs files */

#define PFWPSPX	46		/* spell code module - created external to WPCORP */
#define PFWPDSX	47		/* spell dictionary  - created external to WPCORP */

#define PFWPSPF	53		/* spell .lex and .spf - for WP rules based */
#define PFWPSPS	54		/* spell .lex and .spf - for Socrates rules based */

/* file types for Shell */
#define PFSHDEF	10		/* shell definition file */

/* file types for notebook */
#define PFNBSYS	10		/* notebook system file */

/* file types for calendar */
#define PFCLDAT	10		/* calendar data file */

/* file types for PlanPerfect */
#define PFMPDOC	10		/* planperfect worksheet */
#define PFMPPRN	15		/* printer definition file */
#define PFMPSYS	17		/* {mp}sys.fil */
#define PFMPGDF	18		/* graphics definition files (.GDF) */

#define PFMPMRS 25		/* .mrs macro resource file */

/* file types for DataPerfect */

/* file types for Mail */

/* file types for the printer program */
#define PFPPHLP	10		/* multi-screen context-sensitive help file */
#define PFPPTMP	11		/* temporary file. */
#define PFPPADD	12		/* file used to add fonts to all file */

/* file types for the scheduler */
#define PFSCHIN	10
#define PFSCHOUT 11
#define PFSORG	20
#define PFSEVNT	21
#define PFSUSR	22
#define PFSSET	23

/* file types for DrawPerfect */
#define PFDRPRS	10		/* presentation file */

/* File versions equates for major and minor file products/types */
#define WPDOCMJV 0		/* WP document major version */
#define WPDOCMNV 1		/* WP document minor version */

#define WPMACMJV 1		/* WP macro major version */
#define WPMACMNV 1		/* WP macro minor version */

#define WP5STMJV 0		/* 5.0 set file major version */
#define WPSETMJV 1		/* WP set/system file major version */
#define WPSETMNV 0		/* WP set/system file minor version */

#define WPVRSMJV 0		/* .vrs file version */
#define WPVRSMNV 0

#define WPIRSMJV 0		/* .irs file version */
#define WPIRSMNV 0

#define WPQRSMJV 1		/* .qrs file version */
#define WPQRSMNV 0

#define WPTHSMJV 0		/* thesarus file version */
#define WPTHSMNV 1

#define WPPTRMJV 3		/* ptr major version number */
#define WPPTRMNV 3		/* ptr minor version number (after decimal) */

#define WPDCTMJV 1		/* major dictionary version */
#define WPDCTMNV 0		/* minor dictionary version */

#define WPCODMJV 0		/* major ver dictionary code module */
#define WPCODMNV 0		/* minor */

#define WPMRSMJV 1		/* WP .mrs file major version */
#define WPMRSMNV 1		/* WP .mrs file minor version (same as wpmacmnv) */

#define WPHYFMJV 0		/* WP hyphenation major version */
#define WPHYFMNV 0		/* WP hyphenation minor version */

#define MPSETMJV 1		/* PL set/system file major version */
#define MPSETMNV 0		/* PL set/system file minor version */

#define MPMACMJV 1		/* PL macro major version */
#define MPMACMNV 1		/* PL macro minor version */

/* The file prefix should be included on all WPC files. */
/* This is and always will be 16 BYTES long! */

#ifndef byte
typedef unsigned char byte;
#endif
#define PFMAGIC	(byte)0xFF
#define PFNAME	"WPC"
typedef struct prefix {
	byte		pfmagic;	/* magic code - should contain 0xFF */
	char		pfname[3];	/* WordPerfect ID - should contain "WPC" */
	unsigned long	pfleng;		/* pointer to data */
	byte		pfprod;		/* product code - should be PFWP for WP document */
	byte		pftype;		/* file type - should be PFWPDOC for WP document */
	byte		pfmajv;		/* major version - should be 0 */
	byte		pfminv;		/* minor version - should be 0 */
	unsigned short 	pfcrpt;		/* encryption key (0=not locked) */
	unsigned short	pfreserved;	/* reserved for future use */
} prefix;

/* Additional prefix information follows the 16 required bytes.  The product, */
/* file type, major and minor version numbers indicate what information will be */
/* in the additional prefix area and data area of the file. */
/* The data follows the additional prefix information. */

/* The prefix data follows the first 16 bytes thus a prefixed document */
/* would be of the following format: */

/*    16 Byte Prefix Header. */
/*    The first Index Block consisting of Num_Of_Indicies (determined at */
/*     file creation time, indicated by caller) index structures each */
/*     consisting of a word type, dword length, and dword pointer to */
/*     its data.  The first index of each Index Block is a pointer to */
/*     the next Index Block, and also indicates the number of indicies */
/*     per Index Block and the Index Block's size. */
/*    Data belonging to packets in the first Index Block. */
/*    [ The next Index Block.  Same format as first block. ] */
/*    [ Data belonging to packets in the next Index Block. ] */
/*    The actual document.  (Text for WP; calendar data for Calendar, etc.) */

/* And would appear as diagrammed: */

/*    Ŀ */
/*      ͻ */
/*      -1  W  P  C   Prefix Size  PrdFilMjVMnV Crypt   RFU   */
/*      Ķ */
/*      pfx_ndx# IndxsIB SizePtr To Next Blk Type   Dword Length   */
/*      Ķ */
/*       Ptr To Data1   Type   Dword Length   Ptr To Data2   . . .  */
/*      Ķ */
/*       . . .  Data1     Data1     Data1    Data1     Data2   Data2  */
/*      Ķ */
/*       Data2   Data2   Data2   Data2  . . .                          */
/*                                      */
/*      :                             Prefix                            : */
/*    >͹ */
/*                                                                       */
/*       :                            Document                           : */
/*                                                                       */
/*       ͼ */


/* The following is the structure of prefix index block indices */
typedef struct pfxndx {
	unsigned short	pfxtype;	/* type of packet */
	unsigned long	pfxsize;	/* length of packet data */
	unsigned long	pfxptr;		/* offset in file of packet data */
} pfxndx;

/* ------ Equates for WordPerfect Documents' (& compatible) Index Blocks ------ */
#define PFIBNI	5			/* Number of indicies in Index Block */
#define PFIBSZ	(PFIBNI*sizeof(pfxndx))	/* Size of index block (in bytes) */
/* ---------------------------------------------------------------------------- */

/* special index block structure */
typedef struct spfxndx {
	unsigned short	spfxtype;	/* special index block = 0xFFFB */
	unsigned short	spfxnum;	/* number of indices */
	unsigned short	spfxsize;	/* length of index block */
	unsigned long	spfxptr;	/* pointer to next special index block */
} spfxndx;

/* The following is the structure of prefix Index Blocks parameter */
/* information control block (Index block Control Block - or ICB's) */
typedef struct pfxICB {
	unsigned short	pfxiptr;	/* ptr to user prefix Index Block buffer */
	unsigned short	pfxipsz;	/* size of user prefix Index Block buffer */
	unsigned short	pfxinui;	/* number of indicies per user Index Block buffer */
	unsigned short	pfxicin;	/* current Index Block index number */
	unsigned short	pfxisiz;	/* prefix Index Block size */
	unsigned short	pfxibin;	/* number of indicies per prefix Index Block */
	unsigned long 	pfxifpp;	/* file position after last Index Block read */
	unsigned long	pfxicib;	/* offset in file of start of current Index Block */
	unsigned long	pfxinib;	/* offset in file of start of next Index Block */
} pfxICB;

/* The following is the structure of the new prefix routines' parameter */
/* information control block (Prefix routine Control Block - or PCB's) */
typedef struct pfxPCB {
	unsigned short	pfxpoff;	/* offset of buffer for packet data */
	unsigned short	pfxpseg;	/* segment of buffer for packet data (0 for DATASEG) */
	unsigned short	pfxptyp;	/* packet type */
	unsigned long	pfxpsiz;	/* total size of info to read/write */
	unsigned short	pfxplen;	/* length of source/dest buffer */
	unsigned short	pfxpact;	/* action to be performed (for write, find) */
		/* pfx_1st - Set for 1st write only!!!  (Writes packet index) */
		/* pfx_nxt - Force append of packet to be written, for 1st */
		/*            write only!!!  (Writes packet index) */
} pfxPCB;

/*   Files can have additional prefix information.  This information will be */
/*   stored in packets.  Each packet consists of: */
/*              type (word), length of data (dword), data (length). */

/* *** Reserved type codes for use by all file types *** */
#define PFX_END	0x0000	/* end of prefix information */
#define PFX_DEL	0xFFFF	/* marks packet for deletion */
#define PFX_ANY	0xFFFE	/* matches any packet */
#define PFX_1ST 0xFFFD	/* find first */
#define PFX_NXT	0xFFFC	/* find next (read) / force append (write) */
#define PFX_NDX 0xFFFB	/* next prefix index block ptr type */
#define PFX_ABS 0xFFFA	/* search to an absolute packet number */


/*   E.G. An equate for WP 5.0 would look like PFWP_SUM (document summary) */

/* Word Perfect Packet Type Codes */
#define PFWP_SUM	0x01	/* Document summary packet */
#define PFWP_DEFAULT	0x03	/* Document default values */
#define PFWP_FLAGS	0x06	/* Document specific flags */
#define PFWP_FONTNAME	0x07	/* Font name string pool */
#define PFWP_GRAPHICS	0x08	/* Graphics information */
#define PFWP_FORM	0x09	/* Form hash table */
#define PFWP_PRINTER	0x0C	/* Document printer */
#define PFWP_SUPPDICT	0x0E	/* Supplemental dictionary */
#define PFWP_FONTLIST	0x0F	/* List of fonts used in document (WP5.1) */
#define PFWP_STYLE	0x100	/* first of 256 style packets */
#define PFWP_PSTABLE	0x200	/* first of 256 PS table packets */

/* WPG bitmap graphics */

#define WPG_START	0x0F	/* Start WPG data */
#define WPG_START2	0x19	/* Start WPG data part 2 */
#define WPG_BITMAP	0x0B	/* start WPG bitmap record */
#define WPG_BITMAP2	0x14	/* start WPG bitmap record type 2 */
#define WPG_POLYLINE	0x06	/* start WPG polyline record */
#define WPG_TEXT	0x0C	/* Graphics text */
#define WPG_TEXTATTR	0x0D	/* Graphics Text Attributes */
#define WPG_LINEATTR	0x02	/* Line attributes */
#define WPG_END		0x10	/* End WPG data */

typedef struct wpg_start_record {
	byte		wpgcode;	/* record type (0x0F) */
	byte		wpgsize;	/* record size (0x06) */
	byte		wpgversion;	/* version no (0x01) */
	byte		wpguseps;	/* uses postscript ? (0x00) */
	unsigned short	wpgwidth;	/* width of images space (1/1200") */
	unsigned short	wpgheight;	/* height of image space (1/1200") */
} wpg_start_record;

typedef struct wpg_start_record2 {
	byte		wpgcode;	/* record type (0x19) */
	byte		wpgsize;	/* record size (0x05) */
	byte		wpgsubtype;	/* subtype ID (0x00) */
	byte		wpgslen_lo;
	byte		wpgslen_hi;	/* subtype length (0x02) */
	byte		wpgbgcol;	/* background colour (0x0F) */
	byte		wpgfgcol;	/* foreground colour (0x00) */
} wpg_start_record2;

typedef struct wpg_bitmap {
	byte		wpgcode;	/* record type (0x0B) */
	byte		wpgsizeflag;	/* record size flag (0xFF) */
	unsigned short	wpgsizehi;	/* record size, high word (0x8000 bit set) */
	unsigned short	wpgsizelo;	/* record size, low word */
	unsigned short	wpgiwidth;	/* image width (pixels) */
	unsigned short	wpgiheight;	/* image height (pixels) */
	unsigned short	wpgbpp;		/* bits per pixel (0x01) */
	unsigned short	wpgxdpi;	/* X resolution (300) */
	unsigned short	wpgydpi;	/* Y resolution (300) */
	/* bit map data follows */
} wpg_bitmap;

typedef struct wpg_bitmap2 {
	byte		wpgcode;	/* record type (0x0B) */
	byte		wpgsizeflag;	/* record size flag (0xFF) */
	unsigned short	wpgsizehi;	/* record size, high word (0x8000 bit set) */
	unsigned short	wpgsizelo;	/* record size, low word */
	unsigned short	wpgangle;	/* bitmap angle */
	unsigned short	wpgxl;		/* x left */
	unsigned short	wpgyb;		/* y bottom */
	unsigned short	wpgxr;		/* x right */
	unsigned short	wpgyt;		/* y top */
	unsigned short	wpgiwidth;	/* image width (pixels) */
	unsigned short	wpgiheight;	/* image height (pixels) */
	unsigned short	wpgbpp;		/* bits per pixel (0x01) */
	unsigned short	wpgxdpi;	/* X resolution (300) */
	unsigned short	wpgydpi;	/* Y resolution (300) */
	/* bit map data follows */
} wpg_bitmap2;

typedef struct wpg_polyline {
	byte		wpgcode;	/* record type (0x0B) */
	byte		wpgsizeflag;	/* record size flag (0xFF) */
	unsigned short	wpgsizehi;	/* record size, high word (0x8000 bit set) */
	unsigned short	wpgsizelo;	/* record size, low word */
	unsigned short	wpgnumcoord;	/* number of coordinates (x,y pairs) */
	/* x,y pairs follow as shorts */
} wpg_polyline;

typedef struct wpg_gtextattr {
	byte		wpgcode;	/* record type (0x0D) */
	byte		wpgsize;	/* record size (0x16) */
	unsigned short	wpgcellwidth;	/* character width (wpu) */
	unsigned short	wpgcellheight;	/* character height (wpu) */
	unsigned short	wpgreserved[5];
	unsigned short	wpgfonttype;	/* font face */
	byte		wpgreserved2;
	byte		wpghalign;	/* horizontal alignment */
	byte		wpgvalign;	/* vertical alignment */
	byte		wpgcolour;	/* text colour */
	unsigned short	wpgangle;	/* text angle */
} wpg_gtextattr;

typedef struct wpg_lineattr {
	byte		wpgcode;	/* record type (0x02) */
	byte		wpgsize;	/* record size (4) */
	byte		wpgstyle;	/* line style */
	byte		wpgcolour;	/* line colour */
	unsigned short	wpgwidth;	/* line width */
} wpg_lineattr;

typedef struct wpg_gtext {
	byte		wpgcode;	/* record type (0x0B) */
	byte		wpgsizeflag;	/* record size flag (0xFF) */
	unsigned short	wpgsizehi;	/* record size, high word (0x8000 bit set) */
	unsigned short	wpgsizelo;	/* record size, low word */
	unsigned short	wpgtextlen;	/* text length */
	unsigned short	wpgx,wpgy;	/* text co-ordinates */
	/* characters follow */
} wpg_gtext;

typedef struct wpg_end {
	byte		wpgcode;	/* record type (0x10) */
	byte		wpgsize;	/* record size (0x00) */
} wpg_end;

/* WP5 - Document Code Structures */
typedef struct wpdcode_start {
	byte		wpdcode;	/* document code type */
	byte		wpdsubcode;	/* subcode type */
	unsigned short	wpdsize;	/* code length - 2 */
} wpdcode_start;
typedef struct wpdcode_end {
	unsigned short	wpdsize;	/* code length - 2 */
	byte		wpdsubcode;	/* subcode type */
	byte		wpdcode;	/* document code type */
} wpdcode_end;

/* WP Graphics Codes */
#define WPD_BOX			0xDA	/* Box Group */
#define WPD_BOX_FIGURE		0x00	/* subfunction - figure */
typedef struct wpd_figure {
	wpdcode_start	wfstart;	/* standard code prefix 0xDA007900 */
	unsigned short	wfboxno;	/* box number: bits 15-5 & bit 4-0 (=0x21) */
	byte		wfposition;	/* position/type flags (=0xE) */
	byte		wfalign;	/* alignment flags (=0x20) */
	unsigned short	wfboxwidth;	/* width of box in wpu (=0) */
	unsigned short	wfboxheight;	/* height of box in wpu (=0) */
	unsigned short	wfboxxpos;	/* x position of box (=0) */
	unsigned short	wfboxypos;	/* y position of box (=0) */
	unsigned short	wfoutlspace;	/* outside left space (=0) */
	unsigned short	wfoutrspace;	/* outside right space (=0) */
	unsigned short	wfouttspace;	/* outside top space (=0) */
	unsigned short	wfoutbspace;	/* outside bottom space (=0) */
	unsigned short	wfinlspace;	/* inside left space (=0) */
	unsigned short	wfinrspace;	/* inside right space (=0) */
	unsigned short	wfintspace;	/* inside top space (=0) */
	unsigned short	wfinbspace;	/* inside bottom space (=0) */
	unsigned short	wfhoffset;	/* horizontal offset (wpu) (=0) */
	unsigned short	wfvoffset;	/* vertical offset (wpu) (=0) */
	byte		wfxcol;		/* X column (=0) */
	byte		wfycol;		/* Y column (=0) */
	unsigned short	wfiwidth;	/* source image width (wpu) */
	unsigned short	wfiheight;	/* source image height (wpu) */
	unsigned short	wforient;	/* orientation flags (=0) */
	unsigned short	wfxscale;	/* width scaling % (=100) */
	unsigned short	wfyscale;	/* height scaling % (=100) */
	unsigned short	wfxcrop;	/* X crop offset (=0) */
	unsigned short	wfycrop;	/* Y crop offset (=0) */
	byte		wfformat;	/* image format type (2=disk, 128=wpg) */
	char		wffname[21];	/* graphics filename (null terminated) */
	char		wfreserved[28];	/* blank space */
	byte		wfjust;		/* justification flags (=0) */
	unsigned short	wfpageno;	/* box page number (=0) */
	byte		wfpagebump;	/* number of pages bumped (=0) */
	byte		wfpageoffset;	/* offset to page (=0) */
	unsigned short	wfdwidth;	/* desired width (wpu) */
	unsigned short	wfdheight;	/* desired height (wpu) */
	unsigned short	wfspextra;	/* extra space to caption (=0) */
	unsigned short	wfimindex;	/* image index in temp file (=0) */
	unsigned short	wfcaplines;	/* # caption lines (=0) */
	unsigned short	wfcaphash;	/* hash value for caption (=0) */
	unsigned short	wfcapsize;	/* length of caption (=0) */
	/* text of caption inserted here */
	wpdcode_end	wfend;		/* standard code suffix */
} wpd_figure;

/* WP5.1 Merge Codes */
#define	WPD_MERGE		0xDE	/* Merge Group */
#define WPD_MERGE_END_FIELD	0x31	/* subfunction - length 4 */
#define WPD_MERGE_END_RECORD	0x34	/* subfunction - length 6 - middle is # fields */

