/* digitemgraph -- general purpose graph display */

/* version 1.0 - M.A. Huckvale - March 2003 */

#include <stdio.h>
#include <fcntl.h>
#include "sfs.h"
#include "dig.h"
#include "digdata.h"
#include "digitem.h"
#include "math.h"

extern int	digit_ygrid[100];
extern int	digit_nygrid;
extern int	digit_xgrid[100];
extern int	digit_nxgrid;

#ifdef __STDC__
int    digitemgraph(int32  bundles,float  xl,float  yb,float xr,float  yt,float *x,float *y,int numf,int  flags,char *ptitle,char *xtitle,char *xunit,char *ytitle,char *yunit)
#else
int digitemgraph(bundles,xl,yb,xr,yt,x,y,nsamp,flags,ptitle,xtitle,xunit,ytitle,yunit)
int32		bundles;
float		xl,yb,xr,yt;
float		*x,*y;
int			numf;
int			flags;
char		*ptitle,*xtitle,*xunit,*ytitle,*yunit;
#endif
{
	int	i;
	float		hi,lo;
	float	*f;
	int		bmark,tmark;
	int		newx,newy,oldx,oldy;
	int		adj;
	float	yaxis,ytop;
	char	tbuf[128];

	/* sort out bundles */
	digitbundle(bundles);

	/* init box */
	ytop = (float)(yt - digdata.chheight/digdata.yscale);
	yaxis = (float)(yb + 2.5*(digdata.chheight/digdata.yscale));
	if (ytop <= yaxis) return(-1);

	/* plot x-axis */
	digitbox(xl,yaxis,xr,ytop,0,x[numf-1],flags);
	yt = yval(digitab.iyt);
	/* yaxis = yval(digitab.iyb); */
	digitemaxis(bundles,xl,yb,xr,yaxis,0,x[numf-1],DIGITEMINVERT,xtitle,xunit);
	xl += digitab.ixoff/digdata.xscale;
	/* digtext(digitab.lbun,xr-digtextlen(xtitle),yb,xtitle); */

	/* plot title */
	digtextp(digitab.lbun,(digitab.ixl+digitab.ixoff+digitab.ixr-strlen(ptitle)*digdata.chwidth)/2,ypix(ytop),ptitle);

	/* plot x axis line */
	diglinep(digitab.abun,digitab.ixl+digitab.ixoff,digitab.iyb,digitab.ixr,digitab.iyb);


	/* calculate y-coordinates for TR graph */
	bmark = digitab.iyb+1;
	tmark = digitab.iyt-1;

	/* plot graph */
	if (numf>0) {

		/* get max and min values */
		if (!(flags & DIGITEMFIX)) {
			f = y;
			lo = *f;
			hi = lo;
			for (i=0;i<numf;i++,f++) {
				if (*f < lo) lo = *f;
				if (*f > hi) hi = *f;
			}
			if (hi==lo) hi=lo+1;
			digitab.hi=hi;
			digitab.lo=lo;
		}

		/* plot y-axis */
		digitemfreq(bundles,bmark,tmark,digitab.lo,digitab.hi,0);

		/* write y-axis label */
		digfillboxp(0,digitab.ixl+digitab.ixoff-(strlen(ytitle)+1)*digdata.chwidth,digitab.iytitle,digitab.ixl+digitab.ixoff-digdata.chwidth,digitab.iytitle+digdata.chheight);
		digtextp(digitab.gbun,digitab.ixl+digitab.ixoff-(strlen(ytitle)+1)*digdata.chwidth,digitab.iytitle,ytitle);
		if (yunit && *yunit) {
			sprintf(tbuf,"(%s)",yunit);
			digfillboxp(0,digitab.ixl+digitab.ixoff-(strlen(tbuf)+1)*digdata.chwidth,digitab.iytitle-digdata.chheight,digitab.ixl+digitab.ixoff-digdata.chwidth,digitab.iytitle);
			digtextp(digitab.gbun,digitab.ixl+digitab.ixoff-(strlen(tbuf)+1)*digdata.chwidth,digitab.iytitle-digdata.chheight,tbuf);
		}

		/* draw grid, if required */
		if (flags & DIGITEMYGRID) {
			for (i=0;i<digit_nygrid;i++)
				diglinep(81,digitab.ixl+digitab.ixoff,digit_ygrid[i],digitab.ixr,digit_ygrid[i]);
		}
		if (flags & DIGITEMXGRID) {
			for (i=0;i<digit_nxgrid;i++)
				if (digit_xgrid[i]!=(digitab.ixl+digitab.ixoff))
					diglinep(81,digit_xgrid[i],digitab.iyb,digit_xgrid[i],digitab.iyt);
		}

		/* get scale factors */
		digitab.scalex = (digitab.ixr - digitab.ixl - digitab.ixoff)/x[numf-1];
		digitab.scaley = ((float)(tmark-bmark))/(digitab.hi-digitab.lo);
		adj=(int)(digitab.ixl+digitab.ixoff);

		/* draw graph */
		digclippush();
		digclip(xl,yb,xr,yt);
		oldx = (int)(adj + x[0] * digitab.scalex);
		oldy = (int)(bmark+(y[0]-digitab.lo)*digitab.scaley);
		for (i=1;i<numf;i++) {
			newx = (int)(adj + x[i]*digitab.scalex);
			newy = (int)(bmark+(y[i]-digitab.lo)*digitab.scaley);
			if (flags & DIGITEMTOPHAT) {
				diglinep(digitab.gbun,oldx,oldy,newx,oldy);
				diglinep(digitab.gbun,newx,oldy,newx,newy);
			}
			else
				diglinep(digitab.gbun,oldx,oldy,newx,newy);
			oldx=newx;
			oldy=newy;
		}
		digclippop();
	}

	/* that's it */
	digflush();
	return(0);
}

#ifdef EMO
char	*progname="digitemgra";
main(argc,argv)
int	argc;
char	*argv[];
{
	float	x[100];
	float	y[100];
	int		i;

#if 0
if (strcmp(argv[1],"-p")==0) {
		digstart(DIG_DEFAULT_PRINTER,NULL,1);
	}
	else {
#endif
digstart(DIG_DEFAULT_TERM,NULL,1);
#if 0
}
#endif

	digscale(10.0,10.0,0);
	digclearscreen();

	for (i=0;i<100;i++) {
		x[i] = (float)(i);
		y[i] = (float)(133+100*sin(2*3.14159*i/25.0));
	}

	digitemgraph(20201628,1.0,1.0,9.0,9.0,x,y,100,DIGITEMXGRID|DIGITEMYGRID,"X-axis","Y-axis");

	printf("lo=%g hi=%g\n",digitab.lo,digitab.hi);
	digquit(1);

	exit(0);
}
#endif
