/* DSP routines from Mike Brookes, Imperial College London */

#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include "libic.h"

#define TWOPI (2.0*3.1415926535)

void sintable(logn,table,inc)
int logn,*inc;
REAL **table;
{
/*
This subroutine calculates sin(2*PI*i/m) for i = 0,1,...,m
The successive values are stored in (*table)[] which is of
dimension m+1.

On entry logn specifies the minimum length of the table
(i.e. m >= 2**logn) .
On exit, *table points to the start of the table and inc
is set equal to m/(2**logn). Successive values are therefore
available as (*table)[0], (*table)[inc], (*table)[2*inc] etc.
The table is reused on successive calls so do not change its
contents.

Routine returns 0 or else exits with a message
*/

    static REAL *tab;
    static int logm = -1,m = 0;

    REAL *pm,*pn,*ps,*pc,*pc0;
    REAL theta,s,c;

    int rat,rat2,newm;
    int n2,n4,n34;
    int off2,off3,off4;


    if (logm < logn) {
	logm = (logn < 3) ? 3 : logn;
	newm = 1 << logm;
	tab = (REAL *) (tab ? realloc(tab,(newm+1)*sizeof(REAL)):
			      malloc((newm+1)*sizeof(REAL)));
	if (!tab) {
	    fprintf(stderr,"sintable: cannot allocate memory\n");
	    exit(1);
	    }
	if (!m) {
	    tab[0] = tab[4] = tab[8] = 0.0;
	    tab[6] = -(tab[2] = 1.0);
	    tab[7] = tab[5] = -(tab[3] = tab[1] = sqrt(0.5));
	    m = 8;
	    }
	rat = newm/m;
	pm = tab + m;
	pn = tab + newm;
	while (pm > tab) {
	    *pn = *pm--;
	    pn -= rat;
	    }
	    
	n4 = newm/4;
	n2 = n4 + n4;
	n34 = n2 + n4;
	pc0 = tab + n4;
	while (m < newm) {
	    m += m;
	    rat = newm/m;
	    rat2 = rat + rat;
	    off2 = n4 - rat;
	    off3 = n2 + rat;
	    off4 = n34 - rat;
	    theta = TWOPI/m;
	    s = sin(theta);
	    c = cos(theta);
	    ps = tab;
	    pc = pc0;
	    while (pc > tab) {
		pc[off4] = ps[off3] = -(pc[off2] = ps[rat] = s* *pc + c* *ps);
		ps += rat2;
		pc -= rat2;
		}
	    }
	}
    *table = tab;
    *inc = 1 << (logm - logn);
    return;
    }

#ifdef EMO
main()
{
    int logn,i,inc;
    int nmax = 8;
    REAL *table;

    printf ("Test for sin table\n\n");
    for(;;) {
	printf("Enter log of new length:");
	scanf("%d",&logn);
	sintable(logn,&table,&inc);
	if (nmax >= 34) nmax = 34;
	else if (nmax < (1 << logn)) nmax =  1 + (1 << logn);
	for (i=0; i<nmax; i++) printf("%d %8g\n",i,table[i]);
	printf("inc = %d\n\n",inc);
	}
    }
#endif
