/* window.c -- pre-emphasis and windowing routines */

/*
 * (c) 1994 Mark Huckvale
 * Search Systems Ltd
 * 52-54 High Holborn
 * London WC1E 6BT
 * Tel. 071-430 1685
 */

#include <stdio.h>
#include <math.h>
#include <malloc.h>
#include "window.h"

/* pre-emphasis using weak high-pass filter (+6dB octave > 100Hz) */
#define	PRE_EMP_FACTOR 0.96
void PreEmphasis(x,n)
float *x;
int n;
{
	int	i;
	float	m1,m2;
	m1 = *x;
	for (i=0;i<n;i++,x++) {
		m2 = *x;
		*x -= (float)PRE_EMP_FACTOR * m1;
		m1 = m2;
	}
}

/* Hamming Window */
void Hamming(x,n)
float *x;
int n;
{
	static int	holdsize=0;
	static float	*holdwin;
	int	i;

	if (n!=holdsize) {
		double	w;
		if (holdsize) free(holdwin);
		holdsize = n;
		holdwin = calloc(holdsize,sizeof(float));
		w = 8.0*atan(1.0)/(n-1);
		for (i=0;i<n;i++)
			holdwin[i] = (float)(0.54 - 0.46 * cos(w * i));
	}
	for (i=0;i<n;i++,x++)
		*x *= holdwin[i];
}
