/* putNitems -- update file with items stored in memory buffers */

/* sfs implementation - July 1987 */

#include "SFSCONFG.h"
#include <stdio.h>
#include "sfs.h"

void putNitems(filename,item,numf,buff,count)
const char	*filename;		/* database file to be updated */
struct	item_header *item;	/* item header to be written */
int32	numf;			/* # frames to write */
void	*buff;			/* memory buffer containing data */
int	count;			/* number of items to be written */
{
	int	fid;
	static int itemcount=0;

	/* create output channel */
	if ((fid=sfschannel(filename,item)) < 0)
		error("could not open output channel",NULL);

	/* write data to channel */
	if (sfswrite(fid,numf,buff) != numf)
		error("write error on temporary file",NULL);

	/* last time through - update */
	if (++itemcount == count) {
		if (!sfsupdate(filename))
			error("update error on %s",filename);
		itemcount=0;
	}
}
