/* sfsconvd -- convert data buffers */

/* version 1.0 - june 1987 */

#include "SFSCONFG.h"
#include <stdio.h>
#include "sfs.h"

/* macros to reverse shorts, ints, floats and doubles */
#define REVERSE2(x)	p = (unsigned char *)x; \
			t = *p; *p = *(p+1); *(p+1) = t;
#define REVERSE4(x)	p = (unsigned char *)x; \
			t = *p; *p = *(p+3); *(p+3) = t; \
			t = *++p; *p = *(p+1); *(p+1) = t;
#define REVERSE8(x)	p = (unsigned char *)x; \
			t = *p; *p = *(p+7); *(p+7) = t; \
			t = *++p; *p = *(p+5); *(p+5) = t; \
			t = *++p; *p = *(p+3); *(p+3) = t; \
			t = *++p; *p = *(p+1); *(p+1) = t;

void sfsconvd(machine,buff,len,range)
int32			machine;
char			*buff;
int32			len;
int			range;
{
	register unsigned char	*p,t;

	/* convert 8086 to 68000 */
	if ((machine & 0xFF) != (SFSMACHINE & 0xFF)) {
		if (range==1)
			return;
		else if (range==2) {
			while (len > 0) {
				REVERSE2(buff);
				buff += 2;
				len -= 2;
			}
		}
		else if (range==4) {
			while (len > 0) {
				REVERSE4(buff);
				buff += 4;
				len -= 4;
			}
		}
		else if (range==8) {
			while (len > 0) {
				REVERSE8(buff);
				buff += 8;
				len -= 8;
			}
		}
	}
}
