/* sfsfile -- find pathname for speech file from SFSPATH environment */

/* version 1.0 - June 1987 */

#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "sfs.h"

char *sfsfile(name)
const char *name;
{
	char 		*s,*t,*getenv();
	const char	*nm;
	static char	path[SFSMAXFILENAME];

	strncpy(path,name,SFSMAXFILENAME);
	s = getenv("SFSPATH");
	if (!s)
		return(path);
	else if ((*name=='/') || (*name=='\\'))
		return(path);
#ifdef DOS
	else if ((name[1]==':') && ((name[2]=='/') || (name[2]=='\\')))
		return(path);
#endif
	else {
		s--;
		do {
			t = path-1;
			while((*++t = *++s) && (*s != ';')) /* skip to next entry */;
			if ((path[0] == '.') && (t == path+1)) 
				t--;
			else 
				*t++ = '/';
			nm = name;
			while ((*t++ = *nm++)) /* copy in filename */;
			if (!access(path,0)) {
				return(path);
			}
		} while (*s);
	}
	strncpy(path,name,SFSMAXFILENAME);
	return(path);
}


#ifdef IAG
main()
{
	char name[SFSMAXFILENAME];

	for(;;) {
		printf("Enter file name: ");
		scanf("%s",name);
		strcpy(name,sfsfile(name));
		printf("Full name is %s\n",name);
		if (access(name,0)) printf("does not exist\n");
	}
}
#endif
