/* sfsread -- lowest level read on speech data file allowed in user programs */

/* M.A.Huckvale - July 1987 */

/* Sept 93 - fix for multi-channel data <> 2,4,8 channels */

/* June 1994 - support for 1 byte waveforms through links */

#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <ctype.h>
#include "sfs.h"
#include "sfsdata.h"

static sfssampread();
static netsampread();

int32 sfsread(fid,start,numf,buff)
int		fid;		/* file identifier for item */
int32		start;		/* # first frame requested */
int32		numf;		/* # frames requested */
void		*buff;		/* buffer of returned data */
{
	register int32	i,count;
	register char	*ptr,*buf;
	int		fsize,fhead;
	int32		pos,rcount;
	char		**buffdata,c;

	/* check everything ok */
	if (
	    (sfsdata[fid]==NULL) || 			/* file not opened */
	    (sfsdata[fid]->mode != SFSREAD) ||		/* not reading it */
	    (sfsdata[fid]->item.datatype > MAXDATATYPE) ||
	    (start < 0) ||
	    (sfsdata[fid]->item.numframes < start)	/* off end of data set */
		) 
		return(0);

	/* truncate ambition */
	if ((start+numf) > sfsdata[fid]->item.numframes)
		numf = sfsdata[fid]->item.numframes - start;
	if (numf <= 0) return(0);

	/* check for linked items */
	if (sfsdata[fid]->lfid > 0)
		fid = sfsdata[fid]->lfid;
	else if (sfsdata[fid]->item.datapresent==2) {
		/* need to open link */
		if ((sfsdata[fid]->lfid = sfsopenlink(fid)) < 0) {
			sfsdata[fid]->lfid=0;
			return(0);
		}
		fid = sfsdata[fid]->lfid;
	}

	/* simpler operation for arrays */
	fsize = sfsdata[fid]->item.datasize*sfsdata[fid]->item.framesize;
	if (sfsstruct[sfsdata[fid]->item.datatype]==0) {
		/* unstructured item */
		count = numf * fsize;
		/* see if data is in internal buffer */
		if ((start >= sfsdata[fid]->start) &&
		    ((start+numf) <= (sfsdata[fid]->start + sfsdata[fid]->numf))) {
			start -= sfsdata[fid]->start;
			ptr = sfsdata[fid]->buff + start * fsize;
			buf = (char *)buff;
			for (i=count;i>0;i--) *buf++ = *ptr++;
		}
		else {
			/* find location of data in file */
			if (sfsdata[fid]->shift >=16)
				pos = sfsdata[fid]->datastart + start * (sfsdata[fid]->multiplex+1);
			else if (sfsdata[fid]->multiplex)
				pos = sfsdata[fid]->datastart + start * fsize * (sfsdata[fid]->multiplex+1);
			else
				pos = sfsdata[fid]->datastart + start * fsize;
			/* need to read file */
			if (count < 512) {
				/* read into internal buffer */
				if (sfsdata[fid]->mode==NETREAD) {
					sfsdata[fid]->currpos=pos;
					rcount=netsampread(fid,sfsdata[fid]->buff,512,sfsdata[fid]->multiplex,sfsdata[fid]->swab,sfsdata[fid]->dcoffset,sfsdata[fid]->shift);
				}
				else {
					if (pos != lseek(fid,0L,1)) lseek(fid,pos,0);
					rcount=sfssampread(fid,sfsdata[fid]->buff,512,sfsdata[fid]->multiplex,sfsdata[fid]->swab,sfsdata[fid]->dcoffset,sfsdata[fid]->shift);
				}
				if (rcount < count) count = rcount;
				sfsdata[fid]->start=start;
				sfsdata[fid]->numf=rcount/fsize;
				/* convert if necessary */
				if (sfsdata[fid]->item.machine != SFSMACHINE)
					sfsconvd(sfsdata[fid]->item.machine,sfsdata[fid]->buff,
						rcount,sfsdata[fid]->item.datasize);
				/* copy data out */
				ptr = sfsdata[fid]->buff;
				buf = (char *)buff;
				for (i=count;i>0;i--) *buf++ = *ptr++;
			}
			else {
				/* read into external buffer */
				if (sfsdata[fid]->mode==NETREAD) {
					sfsdata[fid]->currpos=pos;
					rcount=netsampread(fid,buff,count,sfsdata[fid]->multiplex,sfsdata[fid]->swab,sfsdata[fid]->dcoffset,sfsdata[fid]->shift);
				}
				else {
					if (pos != lseek(fid,0L,1)) lseek(fid,pos,0);
					rcount=sfssampread(fid,buff,count,sfsdata[fid]->multiplex,sfsdata[fid]->swab,sfsdata[fid]->dcoffset,sfsdata[fid]->shift);
				}
				if (rcount < count) count = rcount;
				/* convert if necessary */
				if (sfsdata[fid]->item.machine != SFSMACHINE)
					sfsconvd(sfsdata[fid]->item.machine,buff,
						rcount,sfsdata[fid]->item.datasize);
			}
			if (sfsdata[fid]->mode==SFSREAD) sfsdata[fid]->currpos = lseek(fid,0L,1);
		}
		return((int)(count/fsize));
	}
	else if (sfsdata[fid]->item.framesize > 0) {
		/* fixed length structured item */
		/* seek to place in file */
		pos = sfsdata[fid]->datastart + start * fsize;
		if (pos != lseek(fid,0L,1)) lseek(fid,pos,0);
		/* read data record by record into buffer */
		fhead = sfsstruct[sfsdata[fid]->item.datatype];
		for (i=0;i<numf;i++) {
			if (read(fid,buff,fhead) != fhead) return(0);
			/* convert if necessary */
			if (sfsdata[fid]->item.machine != SFSMACHINE)
				sfsconvd(sfsdata[fid]->item.machine,buff,
					fhead,sizeof(int32));
			buff = (void *)((char *)buff+fhead);
			buffdata = (char **) buff;
			if (*buffdata==NULL) return(0);
			if (read(fid,*buffdata,fsize-fhead) != (fsize-fhead))
				return(0);
			/* convert if necessary */
			if (sfsdata[fid]->item.machine != SFSMACHINE)
				sfsconvd(sfsdata[fid]->item.machine,*buffdata,
					fsize-fhead,sfsdata[fid]->item.datasize);
			buff = (void *)((char *)buff+sizeof(char *));
		}
		sfsdata[fid]->currpos = lseek(fid,0L,1);
		return(numf);
	}
	else {
		/* variable length structured item */
		/* restart if required */
		if (start==0) {
			lseek(fid,sfsdata[fid]->datastart,0);
			sfsdata[fid]->start=0;
		}
		/* check place in file -- must be sequential */
		if (start != sfsdata[fid]->start) return(0);
		/* read data record by record into buffer */
		fhead = sfsstruct[sfsdata[fid]->item.datatype];
		ptr = (char *)buff + numf * (fhead + sizeof(char *));
		for (i=0;i<numf;i++) {
			read(fid,&c,1);
			if (read(fid,buff,fhead) != fhead) return(0);
			/* convert if necessary */
			if (sfsdata[fid]->item.machine != SFSMACHINE) {
				if (sfsdata[fid]->item.datatype==WD_TYPE)
					sfsconvd(sfsdata[fid]->item.machine,buff,
						12,sizeof(int32));
				else
					sfsconvd(sfsdata[fid]->item.machine,buff,
						fhead,sizeof(int32));
			}
			buff = (void *)((char *)buff+fhead);
			buffdata = (char **) buff;
			*buffdata = ptr;
			if (read(fid,ptr,(int)c-fhead) != ((int)c-fhead))
				return(0);
			/* convert if necessary */
			if (sfsdata[fid]->item.machine != SFSMACHINE)
				sfsconvd(sfsdata[fid]->item.machine,ptr,
					c-fhead,sfsdata[fid]->item.datasize);
			buff = (void *)((char *)buff+sizeof(char *));
			ptr += (int)c - fhead;
			sfsdata[fid]->start++;
		}
		sfsdata[fid]->currpos = lseek(fid,0L,1);
		return(numf);
	}
}

#define BUFSIZE 4096
#define MIN(x,y) (((x)<(y))?(x):(y))
static int sfssampread(fid,buff,num,multi,swab,dcoffset,shift)
int		fid;
char		*buff;
int		num;
int		multi;
int		swab;
int		dcoffset;
int		shift;
{
	int	count,left,bufsize;
	char	*hold;
	register char	*s,*e;
	short	samp;
	int	multoffset=0;
	int	inp8=0;

	if (shift >= 16) {
		/* 8-bit input */
		inp8 = 1;
		shift -= 16;
	}
	if (inp8 || multi) {
		/* data needs massaging */
		hold = (char *)malloc(BUFSIZE);
		bufsize = BUFSIZE;
	}
	else {
		/* can read directly into buffer */
		hold = buff;
		bufsize = num;
	}
	/* calculate # bytes to read */
	left = num * (multi + 1);
	if (inp8) left = left >> 1;

	/* read in the data */
	num = 0;
	if (!inp8) multi = 2*multi;
	while (left > 0) {
		if ((count = read(fid,hold,MIN(bufsize,left)))==0) {
			if (multi || inp8) free(hold);
			return(num);
		}
		s = &hold[multoffset];
		e = &hold[count];
		if (swab || dcoffset || shift) {
			while (s < e) {
				samp = *s++ & 0xFF;
				if (inp8)
					/* nothing */;
#if SFSMACHINE==0
				else if (swab)
					samp |= (*s++ & 0xFF) << 8;
				else
					samp = (samp << 8) | (*s++ & 0xFF);
#else
				else if (swab)
					samp = (samp << 8) | (*s++ & 0xFF);
				else
					samp |= (*s++ & 0xFF) << 8;
#endif
				samp -= dcoffset;
				if (shift > 0)
					samp = samp << shift;
				else
					samp = samp >> -shift;
#if SFSMACHINE==0
				*buff++ = (samp >> 8) & 0xFF;
				*buff++ = samp & 0xFF;
#else
				*buff++ = samp & 0xFF;
				*buff++ = (samp >> 8) & 0xFF;
#endif
				num += 2;
				s += multi;
			}
			multoffset = s - e;
		}
		else if (inp8 || multi) {
			while (s < e) {
				if (inp8) {
#if SFSMACHINE==0
					*buff++ = '\0';
					*buff++ = *s++;
#else
					*buff++ = *s++;
					*buff++ = '\0';
#endif
				}
				else {
					*buff++ = *s++;
					*buff++ = *s++;
				}
				num += 2;
				s += multi;
			}
			multoffset = s - e;
		}
		else
			num += count;

		left -= count;
	}
	if (multi || inp8) free(hold);
	return(num);
}

static int netsampread(fid,buff,num,multi,swab,dcoffset,shift)
int		fid;
char		*buff;
int		num;
int		multi;
int		swab;
int		dcoffset;
int		shift;
{
	int	count,left,bufsize;
	char	*hold;
	register char	*s,*e;
	short	samp;
	int	multoffset=0;

	if (multi) {
		hold = (char *)malloc(BUFSIZE);
		bufsize=BUFSIZE;
	}
	else {
		hold=buff;
		bufsize=num;
	}
	left = num * (multi + 1);
	num = 0;
	multi = 2*multi;
	while (left > 0) {
		if ((count = netread(sfsdata[fid]->ofilename,
				     sfsdata[fid]->filename,
				     sfsdata[fid]->currpos,
				     hold,
				     MIN(bufsize,left)))==0) {
			if (multi) free(hold);
			return(num);
		}
		sfsdata[fid]->currpos += count;
		s = &hold[multoffset];
		e = &hold[count];
		if (swab || dcoffset || shift) {
			while (s < e) {
				samp = *s++ & 0xFF;
				if (swab)
					samp |= (*s++ & 0xFF) << 8;
				else
					samp = (samp << 8) | (*s++ & 0xFF);
				samp -= dcoffset;
				if (shift > 0)
					samp = samp << shift;
				else
					samp = samp >> -shift;
				*buff++ = (samp >> 8) & 0xFF;
				*buff++ = samp & 0xFF;
				num += 2;
				s += multi;
			}
			multoffset = s - e;
		}
		else if (multi) {
			while (s < e) {
				*buff++ = *s++;
				*buff++ = *s++;
				num += 2;
				s += multi;
			}
			multoffset = s - e;
		}
		else
			num += count;

		left -= count;
	}
	if (multi) free(hold);
	return(num);
}

#ifdef IAG
main()
{
	char    filename[80];
	struct item_header item;
	int     it,fid,i,cnt;
	char    match[80];
	char	*buff,*sfsbuffer();

	printf("Enter filename : "); fflush(stdout);
	scanf("%s",filename);
	if ((fid=sfsopen(filename,"r",NULL)) <= 0) exit(1);

	while (sfsnextitem(fid,&item)) {
		printf("\nitem %ld.%02ld history=%s\n\n",
			item.datatype,
			item.subtype,
			item.history);
		if ((buff = sfsbuffer(&item,1)) == NULL)
			printf("no buffer allocated\n");
		else {
			i=0;
			while ((i<10) && (sfsread(fid,i++,1,buff)==1)) 
				dmpframe(&item,buff);
			free(buff);
		}
	}
}

dmpframe(item,buff)
struct item_header *item;
char	*buff;
{
	int		i,fsize,dsize;
	char		*cp;
	short		*sp;
	int32		*ip;
	float		*fp;
	struct lp_rec	*lp;
	struct an_rec	*an;
	struct co_rec	*co;
	struct fm_rec	*fm;

	fsize = item->datasize * item->framesize;
	dsize = item->datasize;

	if (item->framesize==1) {
		switch (item->datasize) {
		case 1:
			cp = (char *) buff;
			printf("%d\n",*cp);
			break;
		case 2:
			sp = (short *) buff;
			printf("%d\n",*sp);
			break;
		case 4:
			switch (item->floating) {
			case 0:
				ip = (int32 *) buff;
				printf("%ld\n",*ip);
				break;
			case 1:
				fp = (float *) buff;
				printf("%g\n",*fp);
				break;
			}
			break;
		}
	}
	else {
		switch (item->datatype) {
		case AN_TYPE:
			an = (struct an_rec *) buff;
			printf("posn=%ld size=%ld label=%s\n",
				an->posn,
				an->size,
				an->label);
			break;
		case LP_TYPE:
			lp = (struct lp_rec *) buff;
			printf("sname=%s length1=%ld pitch1=%ld length2=%ld pitch2=%ld alist=",
				lp->sname,
				lp->length1,
				lp->pitch1,
				lp->length2,
				lp->pitch2);
			for (i=0;i<(fsize-sfsstruct[LP_TYPE])/dsize;i++)
				printf("%d ",lp->alist[i]);
			printf("\n");
			break;
		case SY_TYPE:
			sp = (short *) buff;
			for (i=0;i<item->framesize;i++) printf("%d ",sp[i]);
			printf("\n");
			break;
		case WD_TYPE:
			printf("?\n");
			break;
		case DI_TYPE:
			printf("?\n");
			break;
		case VU_TYPE:
		case EN_TYPE:
		case CO_TYPE:
		case PC_TYPE:
			co = (struct co_rec *) buff;
			printf("posn=%ld size=%ld flag=%ld mix=%g gain=%g data=",
				co->posn,
				co->size,
				co->flag,
				co->mix,
				co->gain);
			for (i=0;i<(fsize-sfsstruct[item->datatype])/dsize;i++)
				printf("%g ",co->data[i]);
			printf("\n");
			break;
		case FM_TYPE:
			fm = (struct fm_rec *) buff;
			printf("posn=%ld size=%ld flag=%ld gain=%g npeaks=%ld ",
				fm->posn,
				fm->size,
				fm->flag,
				fm->gain,
				fm->npeaks);
			for (i=0;i<(fsize-sfsstruct[item->datatype])/(3*dsize);i++)
				printf("(%g %g %g) ",
					fm->formant[i].freq,
					fm->formant[i].amp,
					fm->formant[i].band);
			printf("\n");
			break;
		default:
			printf("unknown framed data\n");
		}
	}
}
#endif
