#ifndef _UNISTD_H
#define _UNISTD_H

#include <fcntl.h>
#include <io.h>

#define SEEK_SET	0
#define SEEK_CUR	1
#define SEEK_END	2

#define F_OK	0x00
#define W_OK	0x02
#define R_OK	0x04
#define X_OK	0x08
#define D_OK	0x10

extern char *optarg;
extern int optind, opterr, optopt;
int		getopt(int _argc, char * _argv[], char *_optstring);

_CRTIMP int __cdecl access(const char *, int);
_CRTIMP int __cdecl chmod(const char *, int);
_CRTIMP int __cdecl chsize(int, long);
_CRTIMP int __cdecl close(int);
_CRTIMP int __cdecl creat(const char *, int);
_CRTIMP int __cdecl dup(int);
_CRTIMP int __cdecl dup2(int, int);
_CRTIMP int __cdecl eof(int);
_CRTIMP long __cdecl filelength(int);
_CRTIMP int __cdecl isatty(int);
_CRTIMP int __cdecl locking(int, int, long);
_CRTIMP long __cdecl lseek(int, long, int);
_CRTIMP char * __cdecl mktemp(char *);
_CRTIMP int __cdecl open(const char *, int, ...);
_CRTIMP int __cdecl read(int, void *, unsigned int);
_CRTIMP int __cdecl setmode(int, int);
_CRTIMP int __cdecl sopen(const char *, int, int, ...);
_CRTIMP long __cdecl tell(int);
_CRTIMP int __cdecl umask(int);
_CRTIMP int __cdecl unlink(const char *);
_CRTIMP int __cdecl write(int, const void *, unsigned int);

#include <direct.h>
#define getcwd(buffer,maxlen) _getcwd(buffer,maxlen)
  
#include <sys/types.h>

#ifdef	_MSC_VER
#pragma pack(push,8)
#endif	/* _MSC_VER */

struct stat {
	_dev_t st_dev;
	_ino_t st_ino;
	unsigned short st_mode;
	short st_nlink;
	short st_uid;
	short st_gid;
	_dev_t st_rdev;
	_off_t st_size;
	time_t st_atime;
	time_t st_mtime;
	time_t st_ctime;
	};

#ifdef	_MSC_VER
#pragma pack(pop)
#endif	/* _MSC_VER */

_CRTIMP int __cdecl fstat(int, struct stat *);
_CRTIMP int __cdecl stat(const char *, struct stat *);

/* call SFS copy files routine to replace link */
#define link(src,dst) upd_cpfiles(src,dst)

/* simple sleep routine */
#include <time.h>
static void sleep(int nsec)
{
	time_t tend=time((time_t *)0)+nsec;
	while (time((time_t *)0) < tend) /* loop */;
}

#ifndef M_PI
#define M_PI		3.14159265358979323846
#endif

_CRTIMP int __cdecl spawnvp(int, const char *, const char * const *);
#define _P_WAIT 	0

/* some renaming */
#ifndef putch
#define putch _putch
#endif
#ifndef popen
#define popen _popen
#endif
#ifndef pclose
#define pclose _pclose
#endif
#ifndef alloca
#define alloca _alloca
#endif

#endif
