/* header file for dgraph external variables	*/

typedef struct {
	 int    savexmode,saveymode;	/* saved modes */
	 double  xmin,xmax;	/* x axis range		*/
	 double ymin,ymax;	/* y axis range		*/
	 double  xscale,xoffset;	/* x scale factors	*/
	 double  yscale,yoffset;	/* y scale factors	*/
	 double  left,right,bot,top;	/* plot area */

       } DGRAPHP;	/* dgraph parameters	*/
    
#ifdef DGRAPH
static DGRAPHP dgraphp0;	/* default parameter block	*/
DGRAPHP *dgraphp = &dgraphp0;	/* references are made via this pointer	*/
#else
extern DGRAPHP *dgraphp;	/* references are made via this pointer	*/
#endif

/* Now come the constants used for mode specifications */

#define DGfloat 0
#define DGdouble 1
#define DGshort  2
#define DGint    3

#define DGlast   4	/* Give first and last points */
#define DGnext   8	/* Give first and one after last */
#define DGinc	12	/* Give first point and increment */
#define DGfirst 16	/* Give first only: increment = 1 */
#define DGmult  20	/* Give first point and multiple */

#define DGnoaxis 32	/* Don't draw axis */
#define DGlowax  64	/* Axis at bottom or left */
#define DGhighax 96	/* Axis at top or right */

#define DGlogax 128	/* Logarithmic axis */

#define DGzero  256	/* Force axis to include 0 */

#define DGlowlab 512	/* put label below axis */
#define DGhighlab 1024  /* put label above axis */

#define DGnoscale 2048  /* Don't draw scale markings */
#define DGunit    4096  /* Last word of label is a unit */

#define DGprev  8192	/* Use previous axis */
#define DGsame  16384	/* draw on same graph */
#define DGgrid  32768

#define DGline 0	/* line graph */
#define DGaxonly 1	/* axes only */
#define DGpoints 2	/* points only */
#define DGhist 3	/* histogram */
#define DGhistend 4	/* histogram with ends */
#define DGhistdiv 5	/* histogram with descenders */
#define DGbar 6		/* bar graph */

#define DGequal 16	/* make scales equal */

/* Structure for labelling axes */

typedef struct digaxlab { double left,right; 
		       struct digaxlab *next; } DIGSPACE;

#define DAlog 1
#define DAint 2
#define DAnoaxis 4
#define DAtickdown 8
#define DAtickup 16
#define DAlabeldown 32
#define DAlabelup 64
#define DAtitledown 128
#define DAtitleup 256
#define DAgridx 512
#define DAgridy 1024

/* function prototypes */
#ifdef __cplusplus
extern "C" {
#endif
#ifdef __STDC__
void	digaxis(int,float,float,char *,char *,int,float,float,float,float,float,float,DIGSPACE *);
void	dgraph(short *x,short *y,int n,int xmode,int ymode,int type,int bun,char *ptitle,char *xtitle,char *ytitle);
int mappoint(double xpos,double ypos,double *xval,double *yval);
#endif
#ifdef __cplusplus
}
#endif

