/* digfillcircle -- fill a DIG circle given centre and radius */

#include <stdio.h>
#include <math.h>
#include "SFSCONFG.h"
#include "dig.h"
#include "digdata.h"
#include "digtable.h"

#ifdef __STDC__
void   digfillcircle(int  bundle,float  xc,float  yc,float  radius)
#else
void	digfillcircle(bundle,xc,yc,radius)
int	bundle;
float	xc,yc,radius;
#endif
{
	int	x,y,r;

	x = xpix(xc);
	y = ypix(yc);
	r = xpix(xc+radius) - x;	/* radius using x co-ordinates */

	digfillcirclep(bundle,x,y,r);
}

void	digfillcirclep(bundle,xc,yc,r)
int	bundle;
int	xc,yc,r;
{
	int	x,y;

	/* see if device has special routine */
	if (digtable[digdata.select].fillcircle)
		(*digtable[digdata.select].fillcircle)(bundle,xc,yc,r);
	else {
		/* construct from lines */
		for (x = -r;x <= r; x++) {
			y = (int)(sqrt((float)r*r-(float)x*x)/digdata.aspect + 0.5);
			if (y > 0)
				diglinep(bundle,xc+x,yc+y,xc+x,yc-y);
		}
	}

}


#ifdef EMO
main()
{
	int	i;

	digstart('\0',NULL,0) ;
	digscale (21.0,21.0,1);
	digclearscreen();
	for (i=1;i<10;i++)
		digfillcircle(20+i,(float)2*i,10.0,(float)0.5*i);
	digquit(15);
}
#endif
