/* diginitmouse,digkillmouse -- initialise device independent pointing device */

#include "SFSCONFG.h"
#include <stdio.h>
#include <fcntl.h>
#include "dig.h"
#include "digdata.h"
#include "digtable.h"

#ifdef __STDC__
int    diginitmouse(float  xm,float  ym)
#else
int	diginitmouse(xm,ym)
float 	xm,ym ;
#endif
{
	return(diginitmousep(xpix(xm),ypix(ym)));
}

int	diginitmousep(xm,ym)
int 	xm,ym ;
{
	/* check digstart has been called */
	if (!digdata.setup) {
		fprintf (stderr,"diginitmouse : digstart not called\n") ;
		return(-1);
	}

	/* check device supports mouse */
	if (digtable[digdata.select].pointer==NULL) {
		fprintf (stderr,"diginitmouse : output device unsuitable\n" ) ;
		return(-1);
	}

	/* save initial mouse co-ordinates */
	digdata.xmouse = xm;
	digdata.ymouse = ym;

	/* start up mouse */
	return((*digtable[digdata.select].pointer)(1,xm,ym));

}

/* digkillmouse -- disable pointing device */
void	digkillmouse()
{

	/* check device supports mouse */
	if (digtable[digdata.select].pointer)
		(*digtable[digdata.select].pointer)(0,0,0);

}
