/* gtext -- draw hardware text at graphics position */

#include <stdio.h>
#include "SFSCONFG.h"
#include "dig.h"
#include "digdata.h"
#include "digtable.h"

#ifdef __STDC__
void   digtext(int bundle,float xstr,float ystr,char    *word)
#else
void	digtext (bundle,xstr,ystr,word)
float 	xstr,ystr;	/* coords of bottom left corner */
int 	bundle;
char 	*word;
#endif
{
	int	x,y;

	x = xpix(xstr);
	y = ypix(ystr);

	digtextp(bundle,x,y,word);
}

#ifdef __STDC__
void	digtextp(int bundle,int x,int y,char *word)
#else
void	digtextp(bundle,x,y,word)
int 	bundle;
int 	x,y;	/* coords of bottom left corner */
char 	*word;
#endif
{
	(*digtable[digdata.select].text)(bundle,x,y,word);
}

#ifdef EMO
main()
{
	float	len;
	
	digstart('\0',NULL,1);
	digscale(2.0,2.0,0);
	digorigin(1.0,1.0);
	digline(20,-0.5,0.0,0.5,0.0);
	digline(20,0.0,-0.5,0.0,0.5);
	digtext(21,0.0,0.0,"HELLO");
	digtext(22,0.25,0.25,"\"quotes\", 'quoth he', \"quotin'im\"....");
	digtext(23,-0.9,-0.7,"a");
	digtext(23,-0.9,-0.8,"ab");
	digtext(23,-0.9,-0.9,"abc");

	digline(20,-0.9,-0.6,-0.7,-0.6);
	digflush();
	digtext(20,-0.85,-0.6-digdata.chheight/(2*digdata.yscale),"StrikeouT");
	digline(20,-0.85,-0.55,-0.85,-0.5);
	len = 9*digdata.chwidth/digdata.xscale;
	digline(20,len-0.85,-0.55,len-0.85,-0.5);

	digline(20,len-0.85,-0.6+digdata.chheight/(2*digdata.yscale),len-0.8,-0.6+digdata.chheight/(2*digdata.yscale));
	digline(20,len-0.85,-0.6-digdata.chheight/(2*digdata.yscale),len-0.8,-0.6-digdata.chheight/(2*digdata.yscale));
	
	
	digquit(1);
}
#endif

