/* sun -- first attempt at Sun Console driver - monochrome */

/* Mark Huckvale - May 1990 */

#include <stdio.h>
#include <math.h>
#include <ctype.h>
#include <malloc.h>   
#include "SFSCONFG.h"
#include "dig.h"
#include "digdata.h"

#ifdef EVs

/* global data */
struct {
	short mode;		/* 0=s, 1=initialised */
	short invert;		/* 0=normal mode, 1 = invert */
	short rop;		/* raster operation */
} digDEVs;

#include <suntool/gfx_hs.h>
#include <fcntl.h>

#define	SUNHOME		"\033[H"
#define	SUNCLEAREOL	"\033[0K"
#define DEFAULTFONT "/usr/lib/fonts/fixedwidthfonts/serif.r.14"

static struct gfxsubwindow *gfx;
static struct rect		pwrect;
static struct rect		disprect;

Notify_value	eventfunc();
Notify_value	destroyfunc();
static int		doabort,restart;
#define MOUSEQ	16
static int		msb[MOUSEQ],msx[MOUSEQ],msy[MOUSEQ],chr[MOUSEQ],msrd=0,mswt=0;
static  int		lastx,lasty;

/* device characteristics */
sun_params(subtype,digdev)
int	subtype;
struct digdevice *digdev;
{
	if (!(digDEVs.mode)) {
		digDEVs.mode++;

		/* initialise graphics */	
		gfx = gfxsw_init(0,0);

	}

	/* show window */
	pw_exposed(gfx->gfx_pixwin);

	/* get clipping rectangle */
	win_getrect(gfx->gfx_pixwin->pw_clipdata->pwcd_windowfd, &pwrect);

	digdev->nhoriz = pwrect.r_width;
	digdev->nvert  = pwrect.r_height;
	digdev->aspect = 1.0;
	digdev->chwidth = 8;
	digdev->chheight = 14;
	digdev->greylevels = 10;
	digdev->greypixwidth = 3;
	digdev->greypixheight = 3;
}

/* open graphics */
sun_open()
{
	struct screen	scr;
	Inputmask	kmask,mmask;
	char		cmsname[CMS_NAMESIZE];
	static u_char	rmap[2],gmap[2],bmap[2];

	/* initialise colour map */
	sprintf(cmsname,"cms%d",getpid());
	pw_setcmsname(gfx->gfx_pixwin,cmsname);
	rmap[0] = 255; rmap[1] = 0;
	gmap[0] = 255; gmap[1] = 0;
	bmap[0] = 255; bmap[1] = 0;
	pw_putcolormap(gfx->gfx_pixwin,0,2,rmap,gmap,bmap);

	/* show window */
	pw_exposed(gfx->gfx_pixwin);

	/* get clipping rectangle */
	win_getrect(gfx->gfx_pixwin->pw_clipdata->pwcd_windowfd, &pwrect);

	/* register event functions */
	win_register(gfx->gfx_windowfd,
		gfx->gfx_pixwin,
		eventfunc,
		destroyfunc,
		PW_RETAIN);

	win_getsize(gfx->gfx_windowfd,&disprect);
	sun_clear();

	digDEVs.rop = PIX_SRC | PIX_COLOR(0);

}

/* interrupt graphics */
sun_inter()
{
	fprintf(stderr,"Interrupt\n");
	fflush(stderr);
}

/* close graphics - return to text mode */
sun_close()
{
	if (digDEVs.mode) {
		sun_clear();
		gfxsw_done(gfx);
	}
	digDEVs.mode = 0;
}

/* check window */
sun_check()
{
	int	redo=0;
	struct rect newrect;

        if (gfx->gfx_flags & GFX_DAMAGED) {
		gfxsw_handlesigwinch(gfx);
		win_getsize(gfx->gfx_windowfd,&newrect);
                if ((disprect.r_width != newrect.r_width) ||
                    (disprect.r_height != disprect.r_height)) {
                    	win_getsize(gfx->gfx_windowfd,&disprect);
			redo=1;
		}
	}
        if (gfx->gfx_flags & GFX_RESTART) {
		gfx->gfx_flags &= ~GFX_RESTART;
		redo=1;
	}
	return(redo);
}

/* wait for user */
sun_pause()
{
	if (sun_check())
		return(DIG_REDRAW);
	else
		return(diggetkeypress());
}

/* clear screen */
sun_clear()
{
/*
	pw_lock(gfx->gfx_pixwin, &pwrect);
*/
	pw_rop(gfx->gfx_pixwin,
		0,0,
		pwrect.r_width,
		pwrect.r_height,
		PIX_CLR,0,0,0);
/*
	pw_unlock(gfx->gfx_pixwin);
*/
}

/* set up colour from bundle */
static sun_colour(bundle)
int	bundle;
{
	if (digDEVs.invert)
		digDEVs.rop = PIX_SRC ^ PIX_DST;
	else if (bundle==0)
		digDEVs.rop = PIX_CLR;
	else
		digDEVs.rop = PIX_SRC | PIX_DST | PIX_COLOR(0);
}


/* draw a poly-line */
sun_polyline(bundle,buff,len)
int	bundle;
short	*buff;
int	len;
{
	int	oldx,oldy;
	int	x,y;

	/* sort out colours */
	sun_colour(bundle);

	/* position to first point */
	oldx = *buff++;
	oldy = disprect.r_height - *buff++;
	len -= 2;

	/* plot rest of points */
	while (len > 0) {
		x = *buff++;
		y = disprect.r_height - *buff++;
		pw_vector(gfx->gfx_pixwin,
				oldx,oldy,x,y,
				digDEVs.rop,1);
		oldx = x;
		oldy = y;
		len -= 2;
	}

}

static Pixfont	*font=NULL;

/* draw 'hardware' text */
sun_text(bundle,x,y,str)
int	bundle;
int	x,y;
char	*str;
{

	/* sort out colours */
	sun_colour(bundle);

	/* open font */
	if (!font) {
		if ((font=pf_open(DEFAULTFONT))==0)
			error("cannot open '%s'",DEFAULTFONT);
	}
	
	/* write string */
	pw_lock(gfx->gfx_pixwin, &pwrect);
	pw_text(gfx->gfx_pixwin,
		x,
		pwrect.r_height - y - 4,
		digDEVs.rop, 
		font,
		str);
	pw_unlock(gfx->gfx_pixwin);

}

/* draw a filled rectangle */
sun_fillrect(bundle,x1,y1,x2,y2)
int	bundle;
int	x1,y1,x2,y2;
{
	int	tmp;

	/* check co-ordinates */
	if (x1 > x2) {
		tmp = x1;
		x1 = x2;
		x2 = tmp;
	}
	y1 = pwrect.r_height - y1;
	y2 = pwrect.r_height - y2;
	if (y1 > y2) {
		tmp = y1;
		y1 = y2;
		y2 = tmp;
	}

	/* draw filled box */
	pw_lock(gfx->gfx_pixwin, &pwrect);
	if (digDEVs.invert)
		pw_rop(gfx->gfx_pixwin,
			x1,y1,
			x2-x1,y2-y1,
			PIX_NOT(PIX_DST),0,0,0);
	else if (bundle==0)
		pw_rop(gfx->gfx_pixwin,
			x1,y1,
			x2-x1,y2-y1,
			PIX_CLR,0,0,0);
	else
		pw_rop(gfx->gfx_pixwin,
			x1,y1,
			x2-x1,y2-y1,
			PIX_SET,0,0,0);
	
	pw_unlock(gfx->gfx_pixwin);
}

/* change line/text raster operation */
sun_rasterop(mode)
int	mode;
{
	int	ret;
	digflush();
	ret=digDEVs.invert;
	digDEVs.invert=mode;		
	sun_colour(1);
	return(ret);
}

/* add a mouse event to queue */
static queuemouse(b,x,y,c)
int	b,x,y,c;
{
	if (((mswt + 1) % MOUSEQ) != msrd) {
		msb[mswt] = b;
		msx[mswt] = x;
		msy[mswt] = y;
		chr[mswt] = c;
		mswt = (mswt + 1) % MOUSEQ;
	}
}

/* get a mouse event from queue */
static queuecheck(b,x,y,c)
int	*b,*x,*y,*c;
{
	if (msrd != mswt) {
		*b = msb[msrd];
		*x = msx[msrd];
		*y = msy[msrd];
		if (chr[msrd]) *c = chr[msrd];
		msrd = (msrd + 1) % MOUSEQ;
		return(1);
	}
	return(0);
}

Notify_value eventfunc(client,event,arg,when)
Notify_client	client;
Event		*event;
Notify_arg	arg;
Notify_event_type	when;
{
/*
	char messg[80];
	sprintf(messg,"event code = %04X @ (%4d,%4d)",
		event->ie_code,event->ie_locx,event->ie_locy);
	digprompt(messg);
*/

	switch (event_id(event)) {
	case WIN_STOP:
	case 3:
		doabort=1;
		break;
	case MS_LEFT:
		queuemouse(4,event_x(event),event_y(event),0);
		queuemouse(0,event_x(event),event_y(event),0);
		break;
	case MS_MIDDLE:
		queuemouse(2,event_x(event),event_y(event),0);
		queuemouse(0,event_x(event),event_y(event),0);
		break;
	case MS_RIGHT:
		queuemouse(1,event_x(event),event_y(event),0);
		queuemouse(0,event_x(event),event_y(event),0);
		break;
	default:
		if ((event_id(event) > ' ') && (event_id(event) < 0x80))
			queuemouse(0,event_x(event),event_y(event),event_id(event));
		else if ((event_id(event)==0x0A) || (event_id(event)==0x0D))
			queuemouse(0,event_x(event),event_y(event),event_id(event));
		else
			return(NOTIFY_IGNORED);
	}
	return(NOTIFY_DONE);
}

Notify_value destroyfunc(client,event,arg,when)
Notify_client	client;
Event		*event;
Notify_arg	arg;
Notify_event_type	when;
{
/*
	printf("destroy: event code = %04X @ (%d,%d)\n",
		event->ie_code,event->ie_locx,event->ie_locy);
*/
	doabort=1;
	return(NOTIFY_DONE);
}

/* initialise pointing device */
sun_pointer(flag,xm,ym)
int	flag;
int	xm,ym;
{
	static struct screen	scr;
	static Inputmask	kmask,mmask;
	struct termio		newmode;

	if (flag) {
		/* mouse on */
		/* open channel to terminal in raw mode */
		if (digdata.tty == -1) {
			if ((digdata.tty = open ("/dev/tty",O_RDONLY|O_NDELAY)) >= 0) {
				ioctl(digdata.tty,TCGETA,&digdata.oldmode);
				newmode = digdata.oldmode;
				newmode.c_lflag = newmode.c_lflag & ~ICANON;
				newmode.c_lflag = newmode.c_lflag & ~ECHO;
				newmode.c_cc[4]=1;		/* 1 character burst */
				newmode.c_cc[5]=2;		/* wait */
				ioctl(digdata.tty,TCSETA,&newmode);
			}
			else {
				fprintf(stderr,"diginitmouse: unable to open keyboard, errno=%d\n",errno);
				return(-1);
			}
		}

		/* get screen and mouse */
		win_screenget(gfx->gfx_windowfd,&scr);
		win_setms(gfx->gfx_windowfd,&scr);

		/* request mouse events */
		input_imall(&mmask);
		win_setinputcodebit(&mmask,WIN_STOP);
		win_setinputcodebit(&mmask,MS_LEFT);
		win_setinputcodebit(&mmask,MS_MIDDLE);
		win_setinputcodebit(&mmask,MS_RIGHT);
		win_set_pick_mask(gfx->gfx_windowfd,&mmask);

		input_imnull(&mmask);
		win_set_kbd_mask(gfx->gfx_windowfd,&mmask);
		
/* this was a joke - it's better to ignore mouse set position
		win_setmouseposition(gfx->gfx_windowfd,xm,pwrect.r_height-ym);
*/
		msrd=mswt=0;
	}
	else {
		/* restore keyboard */
		if (digdata.tty >= 0) {
			ioctl(digdata.tty,TCFLSH,0);
			ioctl(digdata.tty,TCSETA,&digdata.oldmode) ;
			close(digdata.tty);
		}
		digdata.tty = -1;

		/* mouse off */
		notify_stop();

		/* cancel mouse events */
		input_imnull(&mmask);
		win_set_pick_mask(gfx->gfx_windowfd,&mmask);
	}
}
 
/* get mouse status */
sun_mouse(but,xm,ym,ich)
int	*but;
int	*xm;
int	*ym;
int	*ich;
{
	char		ch;
	static int	butold=0,xmold=0,ymold=0;

	/* check channel opened */
	if (digdata.tty < 0) {
		fprintf(stderr,"diggetmousech: diginitmouse not called\n");
		return(DIG_QUIT);
	}
do {
	/* check for window movement etc */
	if (sun_check())
		return(DIG_REDRAW);

	/* process pending events */
	notify_dispatch();

	/* check for a mouse button event */
	if (queuecheck(but,xm,ym,ich)) {
		/* save new values */
		butold = *but;
		xmold = *xm;
		ymold = *ym;
		*ym = pwrect.r_height - *ym;
		if (*ich)
			/* can get keys this way in suntools */
			return(DIG_KEY);
		else
			return(DIG_MOUSE);
		
	}
	else {
		/* set up last known values */
		*but = butold;
		*xm = xmold;
		*ym = ymold;
		*ym = pwrect.r_height - *ym;
	}

	/* get a character from TTY */
	*ich = 0;
	fcntl(digdata.tty,F_SETFL,O_NDELAY);
	if (read(digdata.tty,&ch,1)==1) {
		ch = ch & 127;		/* zap parity bit */
		*ich = ch;
		return(DIG_KEY);
	}

	/* check for STOP or ctrl/c */
	if (doabort || (*ich==3)) {
		sun_inter();
		digend();
		exit(0);
	}
} while (1);

}

/* display text on prompt line */
sun_prompt(str)
char	*str;
{
	int	len;

	sun_check();

	/* open font */
	if (!font) {
		if ((font=pf_open(DEFAULTFONT))==0)
			error("cannot open '%s'",DEFAULTFONT);
	}

	/* write string */
	pw_lock(gfx->gfx_pixwin, &pwrect);
	pw_rop(gfx->gfx_pixwin,
		0,0,pwrect.r_width,14,
		PIX_CLR,0,0,0);
	pw_text(gfx->gfx_pixwin,
		0,
		10,
		PIX_SRC | PIX_DST | PIX_COLOR(0), 
		font,
		str);
	pw_unlock(gfx->gfx_pixwin);
}

/* dot dithers for 10-level grey scale */
static unsigned short dither[10][3] =
{
	0x0000,0x0000,0x0000,  /* 0 (white) */
	0x8000,0x0000,0x0000,  /* 1 */
	0xA000,0x0000,0x0000,  /* 2 */
	0xA000,0x0000,0x8000,  /* 3 */
	0xA000,0x0000,0xA000,  /* 4 */
	0xA000,0x4000,0xA000,  /* 5 */
	0xE000,0x4000,0xA000,  /* 6 */
	0xE000,0xC000,0xA000,  /* 7 */
	0xE000,0xE000,0xA000,  /* 8 */
	0xE000,0xE000,0xE000  /* 9 (black) */
};

/* storage for one column of grey scale */
struct pixrect *prcol;
unsigned short	*sdcol;

/* grey-level display */
sun_gscale(x,y,height,buff)
int	x,y;
int	height;
unsigned char	*buff;
{
	register int		i;
	register unsigned short	*pix;
	register unsigned char	*p;

	sun_check();

	/* first time around, initialise pixrect */
	if (!prcol) {
		sdcol = (unsigned short *)calloc(pwrect.r_height,2);
		prcol = mem_point(3,pwrect.r_height,1,sdcol);
	}

	pix = sdcol;
	p = buff;
	for (i=0;i<height;i++,p++) {
		*pix++ = dither[*p][0];
		*pix++ = dither[*p][1];
		*pix++ = dither[*p][2];
	}

	pw_rop(gfx->gfx_pixwin,
		x,pwrect.r_height-y-3*height+1,3,3*height,
		PIX_SRC,prcol,0,0);

}

#endif

