/* lab_gettext -- get text description from item history */

/* global declarations */
#include "SFSCONFG.h"
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <malloc.h>
#include "sfs.h"
#include "label.h"

static isproghist();

char	*lab_gettext(hist)
char	*hist;
{
	char	*getenv(),*lab_text();
	char	*p,path[256];
	char	*t,*m,*s0,*s1;

	/* get list of label files */
	if ((p = getenv("SFSLABEL")) != NULL) {
		/* process list of label files */
		strncpy(path,p,256);
	}
	else {
		/* process default label file only */
		strcpy(path,sfsbase());
		strcat(path,LABELFILE);
		strcat(path,";");
	}

	/* get memory for strings */
	m = malloc(strlen(hist));
	s0 = malloc(strlen(hist));
	s1 = malloc(strlen(hist));

	/* process each label file in turn */
	p = strtok(path,";");
	while (p) {

		/* get text description from file */
		if ((t = lab_text(p,hist,s0,s1)) != NULL) {

			/* save text in main strig */
			m = realloc(m,strlen(t)+1);
			strcpy(m,t);

			/* check out first substring recursively */
			if (isproghist(s0)) {
				if ((t = lab_gettext(s0)) != NULL) {
					s0 = realloc(s0,strlen(t)+1);
					strcpy(s0,t);
				}
			}

			/* check out second substring recursively */
			if (isproghist(s1)) {
				if ((t = lab_gettext(s1)) != NULL) {
					s1 = realloc(s1,strlen(t)+1);
					strcpy(s1,t);
				}
			}

			/* put together main- with sub- strings */
			sprintf(lab_hold2,m,s0,s1);
			free(m);
			free(s0);
			free(s1);
			return(lab_hold2);
		}
		p=strtok(0,";");
	}
	free(m);
	free(s0);
	free(s1);
	return(NULL);
}

/* check to see if string looks like a item history */
static int isproghist(s)
char	*s;
{
	if (!isalpha(*s)) return(0);
	while (isalnum(*s)) s++;
	if ((*s != '(') && (*s != '/')) return(0);
	return(1);
}

#ifdef IAG
main()
{
	char	code[80];
	char	*match;

	for (;;) {
		printf("Enter item history : ");
		fflush(stdout);
		scanf("%s",code);
		match = lab_gettext(code);
		printf("match='%s'\n",match);
	}
}
#endif
