/* pick -- operate program on data file by menu selection of items */

/* m.a.huckvale */

/* version 1 - december 1986 */
/* version 1.1 - November 1987
	- SFS version
*/

/*--------------------------------------------------------------------------*/
/**MAN
.TH PICK SFS1 UCL
.SH NAME
pick - menu item selection for program execution
.SH SYNOPSIS
.B pick
(-I) program file
.br
.B pick
(-I) program itemtype file
.SH DESCRIPTION
.I pick
is a program to make item selections from a data file with a menu, it can
simplify comparative execution of a program against different items.  
.PP
.I pick
operates in two modes, in the first, the first argument is the name of the
program to be executed (in quotes if program switches are included) and the
second argument is a data file.  In this mode, a menu of all items in the file
is presented and the user may make several selections.  The entry of a null selection
causes the program to be called with the selected items, and 
.I pick
exits.
.PP
In the second mode, the first argument is the program name as before, but the 
second argument is an item number or item short code (the two character code "SP", "LX", etc),
the third argument is the data file.  In this mode, a menu of only items of the required
type is presented, and each menu selection causes the program to be executed with an
individual item selection.  The entry of a null selection causes
.I pick
to exit.
.PP
.I Options
and their meanings are:
.TP 11
.B -I
Identify program and version.
.PP
.nf
Example usage:
	pick "Ds -p" acha.db
and
	pick replay 1 acha.db
.fi
.SH VERSION/AUTHOR
1.1 - Mark Huckvale.
.SH SEE ALSO
apply
*/
/*--------------------------------------------------------------------------*/
#define PROGNAME "pick"
#define PROGVERS "1.1s"
char	*progname=PROGNAME;

#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <malloc.h>
#include "sfs.h"
#include <ctype.h>

/* global data */
int	entab[MAXITEM],ecnt=0;

#ifdef __STDC__
int maketable(int,int);
void print_menu(int,int);
void execsel(char *pname,int *entab,int ecnt,char *fname);
#else
int maketable();
void print_menu();
void execsel();
#endif

/* main program */
void main(argc,argv)
int argc;
char *argv[];
{
	/* local variables */
	extern int	optind;
	int		errflg=0;
	char		c;
	char		filename[SFSMAXFILENAME];
	char		execname[80];
	int		fid;
	int32		itemtype=0,cnt,entry;
	char		*dummy,ans[80];

	/* decode switches */
	while ( (c = getopt(argc,argv,"I")) != EOF )
		switch (c) {
		case 'I' :	/* Identify */
			fprintf(stderr,"%s: Choose from SFS item menu V%s\n",PROGNAME,PROGVERS);
			exit(0);
			break;
		case '?' :	/* unknown */
			errflg++;
	}
	if (errflg || (argc<2))
		error("usage: %s (-I) program (itemno) file",PROGNAME);

	/* get program name */
	if (optind < argc)
		strcpy(execname,argv[optind]);
	else
		error("no program specified",NULL);
	optind++;

	/* get item number */
	if (argc==4) {
		if (itspec(argv[optind],&itemtype,&dummy) != 0)
			error("bad item specification : %s",argv[optind]);
		optind++;
	}
	else
		itemtype=0;

	/* get filename */
	if (optind < argc)
		strcpy(filename,sfsfile(argv[optind]));
	else
		error("no database file specified",NULL);

	/* open datafile */
	if (strcmp(filename,argv[optind]) != 0)
		printf("file %s:\n",filename);
	if ((fid=sfsopen(filename,"r",NULL)) < 0)
		error("access error on %s",filename);

	/* process data items */
	cnt = maketable(fid,itemtype);
	if (cnt == 0)
		error("no items of given type in %s",filename);
	sfsclose(fid);

	/* menu selection loop */
	do {
		print_menu(itemtype,cnt);
		getline(ans,80);
		entry=atoi(ans);
		if (itemtype==0) {
			if (entry==0)
				execsel(execname,entab,ecnt,filename);
			else
				entab[ecnt++]=entry-1;
		}
		else if ((entry > 0) && (entry <= cnt)) {
			entab[0] = entry-1;
			execsel(execname,entab,1,filename);
		}
	} while (entry > 0);

	/* that's all folks */
	exit(0);
}

/* data tables */
struct {
	char	itemnum[8];
	char	*history;
} table[MAXITEM];

/* make item tables */
int maketable(fid,type)
int	fid;
int	type;
{
	struct item_header item;
	int	tcnt=0,j,flag;
	char	*exphist,*hist;

	/* scan file */
	while (sfsnextitem(fid,&item)) {
		/* add item header to label database */
		exphist=lab_store(&item);

		/* if type ok, add to tables */
		if (((type==0) && (item.datatype > 0)) || (item.datatype == type)) {
			sprintf(table[tcnt].itemnum,"%d.%02d",item.datatype,item.subtype);
			hist=lab_gettext(exphist); 
			if (hist == NULL) {
				/* no label found */
				if ((table[tcnt].history=malloc(strlen(item.history)+1))==NULL)
					error("could not get memory buffer",NULL);
				strcpy(table[tcnt].history,item.history);
			}
			else {
				/* check for item with identical label */
				flag=0;
				for (j=0;(j<tcnt) && !flag;j++) 
					if (strcmp(hist,table[j].history)==0) flag++;
				if (flag) {
					/* identical match - use history instead */
					if ((table[tcnt].history=malloc(strlen(item.history)+1))==NULL)
						error("could not get memory buffer",NULL);
					strcpy(table[tcnt].history,item.history);
				}
				else {
					/* unique label found */
					if ((table[tcnt].history=malloc(strlen(hist)+1))==NULL)
						error("could not get memory buffer",NULL);
					strcpy(table[tcnt].history,hist);
				}
			}				
			tcnt++;
		}

	}
	return(tcnt);
}

extern char *sfsname[];

/* print menu */
void print_menu(type,num)
int	type,num;
{
	int	i;
	static int once=0;
	if (!once) {
		if (type==0)
			printf("\nItem menu\n");
		else
			printf("\n%s item menu\n",sfsname[type]);
		for (i=0;i<num;i++) 
			printf("%2d. %5s %s\n",i+1,table[i].itemnum,table[i].history);
		if (type==0) once++;
	}
	printf("Enter selection : ");
	fflush(stdout);
}


/* execute program with item selection */
void execsel(pname,entab,ecnt,fname)
char	*pname,*fname;
int	*entab,ecnt;
{
	int	i;
	char	sel[10],com[1024];
	if (ecnt==0) return;
	strcpy(com,pname);
	for (i=0;i<ecnt;i++) {
		sprintf(sel," -i%s",table[entab[i]].itemnum);
		strcat(com,sel);
	}
	strcat(com," ");
	strcat(com,fname);
	printf("executing: %s\n",com);
	if (system(com) != 0)
		error("execution failure on: %s",com);
}
