/* syload -- load SY item from formant listing produced by sylist */

/* m.a.huckvale - march 1989 */

/* recreated after old syload lost */

#define PROGNAME "syload"
#define PROGVERS "2.0s"
char *progname=PROGNAME;

/*--------------------------------------------------------------------------*/
/**MAN
.TH SYLOAD SFS1 UCL
.SH NAME
syload - load synthesizer control data text listing
.SH SYNOPSIS
.B syload
(-I) listfile dbfile
.SH DESCRIPTION
.I syload
creates a new SY item in the file
.I dbfile
from synthesizer control specifications listed in the text file
.I listfile.
Input format is that written by 
.I sylist,
namely data values every 10ms in Hertz and dB.
Interspersed annotations (lines not beginning with space or digit) are ignored.
.PP
.I Options
and their meanings are:
.TP 11
.B -I
Identify program and version.
.SH OUTPUT ITEMS
.IP SY 11
Edited SY item.
.SH VERSION/AUTHOR
2.0s - Mark Huckvale
.SH SEE ALSO
fmlist
*/
/*--------------------------------------------------------------------------*/

/* global declarations */
#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "sfs.h"		/* database filing system structures */

/* global data */
struct item_header syitem;	/* filing system item header for new item */

#include <ctype.h>

/* get control data from text file */
int getframe(sy,ip)
short			*sy;		/* returned data */
FILE			*ip;		/* input file */
{
	char		line[256];
	int		fx,f1,f2,f3,f4,fn,v;
	float		a1,a2,a3,a4,an;
	static int	lin=0;
	char		lineno[10];
	int		i;

	/* get next data line */
	do {
		if (fgets(line,256,ip) == NULL) return(1);
		lin++;
	} while (!isdigit(line[0]) && (line[0] != ' '));
	sprintf(lineno,"%d",lin);

	/* find basic parameters of frame */
	if (sscanf(line,"%d %d %f %d %f %d %f %d %f %d %f %d",
			&fx,&f1,&a1,&f2,&a2,&f3,&a3,&f4,&a4,&fn,&an,&v) != 12)
		error("text file format error at line %s",lineno);

	/* clear frame */
	for (i=0;i<syitem.framesize;i++) sy[i]=0;

	/* store data values */
	sy[0]=fx;
	sy[3]=f1;
	sy[4]=(int)a1*10;
	sy[6]=f2;
	sy[7]=(int)a2*10;
	sy[9]=f3;
	sy[10]=(int)a3*10;
	sy[12]=f4;
	sy[13]=(int)a4*10;
	sy[15]=fn;
	sy[16]=(int)an*10;
	sy[18]=v;

	return(0);
}

/* main program */
void main(argc,argv)
int	argc;
char	*argv[];
{
	/* option decoding */
	extern int	optind;		/* option index */
	int		errflg = 0;	/* option error flag */
	int		c;		/* option switch */
	/* file variables */
	char		filename[SFSMAXFILENAME];	/* dbase file name */
	char		textname[SFSMAXFILENAME];	/* text file name */
	FILE		*ip;		/* text file variable */
	int		ofid;
	/* processing variables */
	short		*sy;		/* input SY frame */

	/* decode switches */
	while ( (c = getopt(argc,argv,"I")) != EOF )
		switch (c) {
		case 'I' :	/* Identify */
			fprintf(stderr,"%s: Load synthesizer control data V%s\n",PROGNAME,PROGVERS);
			exit(0);
			break;
		case '?' :	/* unknown */
			errflg++;
	}

	/* check for option decoding error */
	if (errflg || (argc<2))
		error("usage: %s (-I) textfile file",PROGNAME);

	/* get text filename */
	if (optind < argc)
		strcpy(textname,argv[optind]);
	else
		error("no listing file specified",NULL);
	optind++;

	/* get data filename */
	if (optind < argc)
		strcpy(filename,sfsfile(argv[optind]));
	else
		error("no database file specified",NULL);

	/* open text file */
	if ((ip=fopen(textname,"r")) == NULL)
		error("unable to open text file %s",textname);

	/* create SY item header */
	sfsheader(&syitem,SY_TYPE,0,2,19,0.01,0.0,1,0,0);
	sprintf(syitem.history,"%s(file=%s)",PROGNAME,textname);

	/* open output channel */
	if ((ofid=sfschannel(filename,&syitem)) < 0)
		error("unable to create temporary file",NULL);

	/* get input buffer */
	if ((sy=(short *)sfsbuffer(&syitem,1))==NULL)
		error("could not get memory buffer",NULL);

	/* load frames from text file */
	while (getframe(sy,ip) == 0) {
		if (sfswrite(ofid,1,sy) != 1)
			error("write error on temporary file",NULL);
	}

	/* update data file */
	if (!sfsupdate(filename))
		error("update error on %s",filename);

	/* that's all folks */
	exit(0);
}

