function fx2an(fname,item)
% FX2N Creates annotations from FX contour in SFS file
%
%   FX2AN(fname,item) loads an FX item from the SFS file fname.
%   It then builds an annotation item that indicates the starts
%   and ends of each voiced region, with the mean FX in each region.
%
%   FX2AN(fname) performs the same operation on the last FX item
%   in the file fname.

% load FX data
if (nargin<2) item='fx'; end;
[h,d]=sfsgetitem(fname,item);
% put the starts and lengths of regions into an array
rcnt=1;
r(rcnt,1)=1;
r(rcnt,2)=0;
for i=2:h.numframes
    if (d(i-1)==0) & (d(i)>0)
        % end of voiceless region
        r(rcnt,2)=i-r(rcnt,1);
        rcnt=rcnt+1;
        r(rcnt,1)=i;
    elseif (d(i-1)>0) & (d(i)==0)
        % end of voiced region
        r(rcnt,2)=i-r(rcnt,1);
        rcnt=rcnt+1;
        r(rcnt,1)=i;
    end;
end;
r(rcnt,2)=h.numframes-r(rcnt,1);
% find mean values of each section
for i=1:rcnt
    m(i)=mean(d(r(i,1):r(i,1)+r(i,2)-1));
end;
% build output annotations
[oh,od]=sfsnewitem(5,h.frameduration,h.offset,1,rcnt);
oh.history=sprintf('matlab/AN(%d.%02d;script=fx2an)',h.datatype,h.subtype);
for i=1:rcnt
    od(i).posn = r(i,1)-1;
    od(i).size = r(i,2);
    od(i).label= num2str(m(i),'%.2fHz');
end;
sfsputitem(fname,oh,od);
