function sfsfilter(fname,item,hertz,ftype)
% SFSFILTER Applies a filter to a speech signal
%
%   SFSFILTER(fname,item,hertz,ftype) applies an 8th-order
%   Butterworth filter to the speech signal 'item' in the SFS
%   file fname.  The hertz parameter gives the cut-off frequency
%   (or frequencies) in hertz.  The ftype parameter selects the
%   filter type from: 'low'=low-pass, 'high'=high-pass, 'band'=
%   band-pass, 'stop'=band-stop.  The filtered speech is saved
%   back into the SFS file.
%
%   For example:
%      sfsfilter('file.sfs','1.01',1000,'low');
%      sfsfilter('file.sfs','sp',[1000 2000],'band');

%
% get item from SFS file (h=header, d=data set)
%
[h,d]=sfsgetitem(fname,item);
%
% make filter (uses butter() design from signal-processing toolbox)
%
if strcmp(ftype,'low') | strcmp(ftype,'band')
    [b,a]=butter(8,2*hertz*h.frameduration);
else
    [b,a]=butter(8,2*hertz*h.frameduration,ftype);
end;
%
% make a new item header as copy of input item header
%
oh=sfsnewitem(h.datatype,h.frameduration,h.offset,h.framesize,h.numframes);
%
% create a suitable processing history string
%
if (length(hertz)==2)
    oh.history=sprintf('matlab/SP(%d.%02d;script=signalfilter,hertz=%g:%g,ftype=%s)',...
    	h.datatype,h.subtype,hertz(1),hertz(2),ftype);
else
    oh.history=sprintf('matlab/SP(%d.%02d;script=signalfilter,hertz=%g,ftype=%s)',...
    	h.datatype,h.subtype,hertz,ftype);
end;
%
% apply filter to input signal
%
od=filter(b,a,d);
%
% save filtered signal to file
%
sfsputitem(fname,oh,od);
