/* antx -- convert an item into tx data */

/* M.A.Huckvale - December 1986 */

/* version 1.1 - March 1988
	- SFS version
*/

#define PROGNAME "antx"
#define PROGVERS "1.1s"
char	*progname=PROGNAME;

/*--------------------------------------------------------------------------*/
/**MAN
.TH ANTX 1 UCL
.SH NAME
antx -- convert annotations to a tx item
.SH SYNOPSIS
.B antx
(-i item) file
.SH DESCRIPTION
.I antx
is a program to use the position of annotations as the basis for a tx item.
Each annotation in the input item is used to locate an excitation pulse.
.PP
.I Options
and their meanings are:
.TP 11
.B -I
Identify program and version number.
.TP 11
.BI -i item
Select input item number.
.SH INPUT ITEMS
.IP 5.xx 11
Any annotations item.
.SH OUTPUT ITEMS
.IP 3 11
Edited Tx.
.SH VERSION/AUTHOR
1.1 - Mark Huckvale
*/
/*--------------------------------------------------------------------------*/

/* standard definitions */
#include "SFSCONFG.h"
#include <stdio.h>		/* standard io library */
#include <stdlib.h>
#include <unistd.h>
#include "sfs.h"		/* database structures */

/* global data */
struct item_header txitem;	/* item header for tx data */
int		*txbuff;	/* buffer for tx data */
struct item_header anitem;	/* item header for an data */

/* main program */
void main(argc,argv)
int	argc;
char	*argv[];
{
	/* option decoding */
	extern int	optind;		/* option index */
	extern char	*optarg;	/* option argument ptr */
	int		errflg = 0;	/* option error flag */
	int		c;		/* option switch */
	int		it;		/* item selections */
	char		*ty;
	char		*antype = "0";	/* default sub-type = last */
	/* file variables */
	char		filename[SFSMAXFILENAME];	/* dbase file name */
	int		fid;
	/* data variables */
	int		i,last,txcount;
	struct an_rec	*anrec;		/* annotation record */

	/* decode switches */
	while ( (c = getopt(argc,argv,"Ii:")) != EOF ) switch (c) {
		case 'I' :	/* Identify */
			fprintf(stderr,"%s: Convert annotations to Tx markers V%s\n",PROGNAME,PROGVERS);
			exit(0);
			break;
		case 'i' :	/* specific item */
			if (itspec(optarg,&it,&ty) == 0) {
				if (it == AN_TYPE)
					antype = ty;
				else
					error("unsuitable item specifier %s",optarg);
			}
			else
				error("illegal item specifier %s",optarg);
			break;
		case '?' :	/* unknown */
			errflg++;
	}
	if (errflg || (argc<2))
		error("usage: %s (-I) (-i item) file",PROGNAME);

	/* get filename */
	if (optind < argc)
		strcpy(filename,sfsfile(argv[optind]));
	else
		error("no database file specified",NULL);

	/* locate input an item */
	if ((fid=sfsopen(filename,"w",NULL)) < 0) {
		if (fid==-1)
			error("cannot find file '%s'",filename);
		else
			error("access error on '%s'",filename);
	}
	if (!sfsitem(fid,AN_TYPE,antype,&anitem))
		error("unable to locate input AN item in '%s'",filename);

	/* get annotation buffer */
	anrec = (struct an_rec *)sfsbuffer(&anitem,1);

	/* create new item header */
	sfsheader(&txitem,TX_TYPE,0,4,1,
		anitem.frameduration,anitem.offset,0,0,1);
	sprintf(txitem.history,"%s(%d.%02d)",PROGNAME,anitem.datatype,anitem.subtype);

	/* get buffer for tx */
	txbuff = (int *)sfsbuffer(&txitem,anitem.numframes+1);

	/* create tx values from annotations */
	last = 0;
	txcount = 0;
	for (i=0;sfsread(fid,i,1,anrec);i++) {
		/* create tx entry */
		txbuff[txcount] = anrec->posn - last;
		if (txbuff[txcount] > 0) txcount++;
		last = anrec->posn;
	}
	/* put in last value */
	txbuff[txcount] = anrec->size;
	if (txbuff[txcount] > 0) txcount++;

	/* update original file */
	putitem(filename,&txitem,txcount,txbuff);

	/* that's all folks ... */
	exit(0);
}

