/* phonetic.h -- acoustic definitions for phonetic symbols */

/* Mark Huckvale - University College London */

/* version 1.0 - February 2000 */

/* parameters */
#define FN_PARAM	0
#define F1_PARAM	1
#define F2_PARAM	2
#define F3_PARAM	3
#define AL_PARAM	4
#define A1_PARAM	5
#define A2_PARAM	6
#define A3_PARAM	7
#define AH_PARAM	8
#define VR_PARAM	9
#define NUM_PARAM	10

/* record structure */
struct phone_rec {
	char	*label;
	int	rank;			/* segment rank */
	int	mindur;			/* minimum duration (ms) */
	int	inhdur;			/* inherent duration (ms) */
	int	target[NUM_PARAM];	/* target values (Hz/dB) */
	int	boundfix[NUM_PARAM];	/* fixed contrib to boundary (Hz/dB) */
	int	boundvar[NUM_PARAM];	/* variable contrib to boundary (%) */
	int	externdur[NUM_PARAM];	/* external transition duration (ms) */
	int	interndur[NUM_PARAM];	/* internal transition duration (ms) */
};

/* phone table */
struct phone_rec phone_tab[]={
{ "&",   2, 40, 140,		/* old version of symbol '{' */
	{ 250, 750, 1700, 2740,  42,  42,  50,  49,  46, 248 },
	{ 125, 375,  850, 1370,  21,  21,  25,  24,  23, 124 },
	{  50,  50,   50,   50,  50,  50,  50,  50,  50,  50 },
 	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 },
	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 }
},
{ "3:",  2, 50, 240,
	{ 250, 550, 1400, 2600,  42,  43,  44,  45,  50, 248 },
	{ 125, 275,  700, 1300,  21,  21,  22,  22,  25, 124 },
	{  50,  50,   50,   50,  50,  50,  50,  50,  50,  50 },
 	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 },
	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 }
},
{ "5",  10, 40,  80,		/* alias of l~ */
	{ 250, 350,  880, 2800,  39,  40,  41,  39,  39, 248 },
	{ 125, 175,  440, 1400,  19, -14, -10,  -7,  -7, 124 },
	{  50,  50,   50,   50,  50, 100, 100, 100, 100,  50 },
	{   0,  60,   60,   60,  20,  20,  20,  20,  20,   0 },
	{   0,   0,    0,    0,  20,   0,   0,   0,   0,   0 }
},
{ "@",   2, 40,  90,
	{ 250, 550, 1420, 2600,  42,  43,  44,  46,  50, 248 },
	{ 125, 275,  710, 1300,  21,  21,  22,  23,  25, 124 },
	{  50,  50,   50,   50,  50,  50,  50,  50,  50,  50 },
 	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 },
	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 }
},
{ "@U", 2, 40, 130,
	{ 250, 600, 1400, 2600,  42,  43,  45,  45,  46, 248 },
	{ 125, 300,  700, 1300,  21,  21,  22,  22,  23, 124 },
	{  50,  50,   50,   50,  50,  50,  50,  50,  50,  50 },
 	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 },
	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 }
},
{ "@U2", 2, 35, 100,
	{ 250, 340, 1000, 2400,  42,  43,  34,  28,  33, 248 },
	{ 125, 170,  500, 1200,  21,  21,  17,  14,  16, 124 },
	{  50,  50,   50,   50,  50,  50,  50,  50,  50,  50 },
 	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 },
	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 }
},
{ "A:",  2, 70, 220,
	{ 250, 700, 1060, 2950,  42,  45,  48,  41,  44, 248 },
	{ 125, 350,  530, 1475,  21,  22,  24,  20,  22, 124 },
	{  50,  50,   50,   50,  50,  50,  50,  50,  50,  50 },
 	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 },
	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 }
},
{ "D",   6, 35, 100,
	{ 250, 280, 1300, 2680,  27,  27,  26,  28,  35, 140 },
	{ 125, 140,  650, 2680,  13,  13,  13,  14,  17,  70 },
	{  50,  50,   50,    0,  50,  50,  50,  50,  50,  50 },
	{   0,  50,   50,   50,  20,  20,  20,  20,  20,  20 },
	{   0,  20,   20,   20,  20,  20,  20,  20,  20,  20 }
},
{ "I",   2, 40, 100,
	{ 250, 400, 2000, 2800,  42,  42,  42,  47,  45, 248 },
	{ 125, 200, 1000, 1400,  21,  21,  21,  23,  22, 124 },
	{  50,  50,   50,   50,  50,  50,  50,  50,  50,  50 },
 	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 },
	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 }
},
{ "I@", 2, 55, 100,
	{ 250, 310, 2200, 2920,  42,  42,  40,  45,  43, 248 },
	{ 125, 155, 1100, 1460,  21,  21,  20,  22,  21, 124 },
	{  50,  50,   50,   50,  50,  50,  50,  50,  50,  50 },
 	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 },
	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 }
},
{ "I@2", 2, 45, 110,
	{ 250, 520, 1550, 2650,  42,  42,  43,  45,  50, 248 },
	{ 125, 260,  775, 1325,  21,  21,  21,  22,  25, 124 },
	{  50,  50,   50,   50,  50,  50,  50,  50,  50,  50 },
 	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 },
	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 }
},
{ "N",   15, 50, 130,
	{ 250, 850, 2080, 2500,  42,  14,  30,  35,   0, 248 },
	{ 125,   0, 2080, 2500,   0, -10, -10, -10, -10, 124 },
	{  50, 100,    0,    0, 100, 100, 100, 100, 100,  50 },
	{   0,  30,   50,   30,  30,  30,  30,  30,  30,  20 },
	{   0,   0,    0,    0,   0,   0,   0,   0,   0,   0 }
},
{ "O:",  2, 70, 210,
	{ 250, 500,  750, 2850,  42,  46,  44,  32,  35, 248 },
	{ 125, 250,  375, 1425,  21,  23,  22,  16,  17, 124 },
	{  50,  50,   50,   50,  50,  50,  50,  50,  50,  50 },
 	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 },
	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 }
},
{ "OI", 2, 50, 120,
	{ 250, 550,  880, 2620,  42,  41,  43,  31,  39, 248 },
	{ 125, 275,  440, 1310,  21,  20,  21,  15,  19, 124 },
	{  50,  50,   50,   50,  50,  50,  50,  50,  50,  50 },
 	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 },
	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 }
},
{ "OI2", 2, 45, 120,
	{ 250, 400, 2300, 2800,  42,  40,  38,  42,  43, 248 },
	{ 125, 200, 1150, 1400,  21,  20,  19,  21,  21, 124 },
	{  50,  50,   50,   50,  50,  50,  50,  50,  50,  50 },
 	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 },
	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 }
},
{ "Q",   2, 40, 140,
	{ 250, 610,  880, 2875,  42,  46,  47,  35,  40, 248 },
	{ 125, 305,  440, 1437,  21,  23,  23,  17,  20, 124 },
	{  50,  50,   50,   50,  50,  50,  50,  50,  50,  50 },
 	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 },
	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 }
},
{ "S",   6, 80, 180,
	{ 250, 400, 1780, 2320,   0,   0,  42,  49,  51,   0 },
	{ 125, 200,  890, 1160,   0,   0,  21,  24,  25,   0 },
	{  50,  50,   50,   50,  50,  50,  50,  50,  50,  50 },
	{   0,  50,   50,   60,  20,  20,  20,  20,  20,   0 },
	{   0,  20,   20,   20,  20,  20,  20,  20,  20,   0 }
},
{ "T",   10, 60, 160,
	{ 250, 400, 1300, 2680,   0,   0,  26,  28,  35,   0 },
	{ 125, 200,  650, 2680,   0,   0,  13,  14,  17,   0 },
	{  50,  50,   50,    0,  50,  50,  50,  50,  50,  50 },
	{   0,  50,   50,   50,  20,  20,  20,  20,  20,   0 },
	{   0,  20,   20,   20,  20,  20,  20,  20,  20,   0 }
},
{ "U",   2, 50, 100,
	{ 250, 450,  880, 2700,  42,  44,  40,  37,  40, 248 },
	{ 125, 225,  440, 1350,  21,  22,  20,  18,  20, 124 },
	{  50,  50,   50,   50,  50,  50,  50,  50,  50,  50 },
 	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 },
	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 }
},
{ "U@", 2, 40, 130,
	{ 250, 450,  880, 2700,  42,  43,  45,  45,  46, 248 },
	{ 125, 225,  440, 1350,  21,  21,  22,  22,  23, 124 },
	{  50,  50,   50,   50,  50,  50,  50,  50,  50,  50 },
 	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 },
	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 }
},
{ "U@2", 2, 35, 100,
	{ 250, 600, 1400, 2600,  42,  43,  43,  45,  50, 248 },
	{ 125, 300,  700, 1300,  21,  21,  21,  22,  25, 124 },
	{  50,  50,   50,   50,  50,  50,  50,  50,  50,  50 },
 	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 },
	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 }
},
{ "V",   2, 40, 155,
	{ 250, 750, 1200, 2800,  42,  42,  46,  40,  42, 248 },
	{ 125, 375,  600, 1400,  21,  21,  23,  20,  21, 124 },
	{  50,  50,   50,   50,  50,  50,  50,  50,  50,  50 },
	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 },
	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 }
},
{ "Z",   6, 40,  70,
	{ 250, 280, 1780, 2320,  27,  27,  42,  49,  51, 140 },
	{ 125, 140,  890, 1160,  13,  13,  21,  24,  25,  70 },
	{  50,  50,   50,   50,  50,  50,  50,  50,  50,  50 },
	{   0,  50,   50,   50,  20,  20,  20,  20,  20,  20 },
	{   0,  20,   20,   20,  20,  20,  20,  20,  20,  20 }
},
{ "_",   31, 100, 100,
	{ 250, 400, 1300, 2080,   0,   0,   0,   0,   0,   0 },
	{   0,   0,    0,    0,   0,   0,   0,   0,   0,   0 },
	{ 100, 100,  100,  100, 100, 100, 100, 100, 100, 100 },
	{   0,   0,    0,    0,   0,   0,   0,   0,   0,   0 },
	{  50,  50,   50,   50,   0,   0,   0,   0,   0,   0 }
},
{ "aI", 2, 30, 130,
	{ 250, 730, 1060, 2800,  42,  42,  49,  37,  48, 248 },
	{ 125, 365,  530, 1400,  21,  21,  24,  18,  24, 124 },
	{  50,  50,   50,   50,  50,  50,  50,  50,  50,  50 },
 	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 },
	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 }
},
{ "aI2", 2, 30,  90,
	{ 250, 400, 2300, 2800,  42,  40,  38,  42,  43, 248 },
	{ 125, 200, 1150, 1400,  21,  20,  19,  21,  21, 124 },
	{  50,  50,   50,   50,  50,  50,  50,  50,  50,  50 },
 	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 },
	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 }
},
{ "aU", 2, 50, 120,
	{ 250, 790, 1550, 2650,  42,  43,  51,  49,  50, 248 },
	{ 125, 395,  775, 1325,  21,  21,  25,  24,  25, 124 },
	{  50,  50,   50,   50,  50,  50,  50,  50,  50,  50 },
 	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 },
	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 }
},
{ "aU2", 2, 45, 120,
	{ 250, 340, 1000, 2400,  42,  43,  34,  28,  33, 248 },
	{ 125, 170,  500, 1200,  21,  21,  17,  14,  16, 124 },
	{  50,  50,   50,   50,  50,  50,  50,  50,  50,  50 },
 	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 },
	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 }
},
{ "b",  26, 55,  90,
	{ 250, 190, 1100, 2500,  33,  36,   0,   0,   0, 248 },
	{ 125, 116,  308, 1250,  31,  34, -10, -10, -10, 124 },
	{  50,  39,   72,   50,   0,   0, 100, 100, 100,  50 },
	{   0,  30,   30,   50,  30,  30,  30,  30,  30,  20 },
	{   0,   0,    0,    0,   0,   0,   0,   0,   0,   0 },
},
{ "b2",  29, 10,  25,
	{ 250, 190, 1100, 2500,  41,  42,  43,  38,  38, 124 },
	{ 125, 116,  308, 1250,  39, -10, -10, -10, -10,  62 },
	{  50,  39,   73,   50,   0, 100, 100, 100, 100,  50 },
	{   0,  30,   30,   30,  30,  30,  30,  30,  30,  20 },
	{   0,   0,    0,    0,   0,   0,   0,   0,   0,   0 }
},
{ "d",  26, 35,  50,
	{ 250, 190, 1780, 2680,  33,  36,   0,   0,   0, 248 },
	{ 125, 116,  815,  804,  31,  34, -10, -10, -10, 124 },
	{  50,  39,   54,   70,   0,   0, 100, 100, 100,  50 },
	{   0,  30,   30,   30,  30,  30,  30,  30,  30,  20 },
	{   0,   0,    0,    0,   0,   0,   0,   0,   0,   0 }
},
{ "d2",  29, 10,  25,
	{ 250, 190, 1780, 2680,  41,  42,  34,  31,  43, 124 },
	{ 125, 116,  815,  804,  31, -10, -10, -10, -10,  62 },
	{  50,  39,   54,   70,   0, 100, 100, 100, 100,  50 },
	{   0,  30,   30,   30,  30,  30,  30,  30,  30,  20 },
	{   0,   0,    0,    0,   0,   0,   0,   0,   0,   0 }
},
{ "dZ", 10, 50,  70,
	{ 250, 190, 1780, 2680,  33,  36,   0,   0,   0, 248 },
	{ 125,  95,  890, 1340,  16,  18,   0,   0,   0, 124 },
	{  50,  50,   50,   50,  50,  50,  50,  50,  50,  50 },
 	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 },
	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 }
},
{ "dZ2", 10, 30, 100,
	{ 250, 280, 1780, 2320,  27,  27,  42,  49,  51, 140 },
	{ 125, 140,  890, 1160,  13,  13,  21,  24,  25,  70 },
	{  50,  50,   50,   50,  50,  50,  50,  50,  50,  50 },
 	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 },
	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 }
},
{ "e",   2, 50, 125,
	{ 250, 580, 1900, 2750,  42,  42,  47,  48,  46, 248 },
	{ 125, 290,  950, 1375,  21,  21,  23,  24,  23, 124 },
	{  50,  50,   50,   50,  50,  50,  50,  50,  50,  50 },
 	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 },
	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 }
},
{ "e@", 2, 55, 145,
	{ 250, 580, 1900, 2750,  42,  42,  47,  48,  46, 248 },
	{ 125, 290,  950, 1375,  21,  21,  23,  24,  24, 124 },
	{  50,  50,   50,   50,  50,  50,  50,  50,  50,  50 },
 	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 },
	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 }
},
{ "e@2", 2, 45, 125,
	{ 250, 640, 1600, 2600,  42,  42,  47,  46,  45, 248 },
	{ 125, 320,  800, 1300,  21,  21,  23,  23,  22, 124 },
	{  50,  50,   50,   50,  50,  50,  50,  50,  50,  50 },
 	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 },
	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 }
},
{ "eI", 2, 40, 130,
	{ 250, 640, 1600, 2500,  42,  39,  41,  32,  43, 248 },
	{ 125, 320,  800, 1250,  21,  19,  20,  16,  21, 124 },
	{  50,  50,   50,   50,  50,  50,  50,  50,  50,  50 },
	{  30,  30,   30,   30,  30,  30,  30,  30,  30,  30 },
	{  60,  60,   60,   60,  60,  60,  60,  60,  60,  60 }
},
{ "eI2", 2, 35, 100,
	{ 250, 400, 2300, 2800,  42,  40,  38,  42,  43, 248 },
	{ 125, 200, 1150, 1400,  21,  20,  19,  21,  21, 124 },
	{  50,  50,   50,   50,  50,  50,  50,  50,  50,  50 },
	{  60,  60,   60,   60,  60,  60,  60,  60,  60,  60 },
	{  30,  30,   30,   30,  30,  30,  30,  30,  30,  30 }
},
{ "f",   6, 50, 130,
	{ 250, 400, 1360, 2560,   0,   0,  32,  32,  37,   0 },
	{ 125, 200,  680, 1280,   0,   0,  16,  16,  18,   0 },
	{  50,  50,   50,   50,  50,  50,  50,  50,  50,  50 },
	{   0,  50,   50,   50,  20,  20,  20,  20,  20,   0 },
	{   0,  20,   20,   20,  20,  20,  20,  20,  20,   0 }
},
{ "g",  26, 50,  65,
	{ 250, 190, 1650, 2300,  33,  41,   0,   0,   0, 248 },
	{ 125, 116,  231,  851,  31,  39, -10, -10, -10, 124 },
	{  50,  39,   86,   63,   0,   0, 100, 100, 100,  50 },
	{   0,  30,   50,   30,  30,  30,  30,  30,  30,  20 },
	{   0,   0,    0,    0,   0,   0,   0,   0,   0,   0 }
},
{ "g2",  29, 10,  25,
	{ 250, 190, 1650, 2300,  41,  41,  45,  43,  32, 124 },
	{ 125, 116,  231,  851,  39, -10, -10, -10, -10,  62 },
	{  50,  39,   86,   63,   0, 100, 100, 100, 100,  50 },
	{   0,  30,   50,   30,  30,  30,  30,  30,  30,  20 },
	{   0,   0,    0,    0,   0,   0,   0,   0,   0,   0 }
},
{ "h",   4, 40, 160,
	{ 250, 760, 1720, 2800,  28,  34,  45,  43,  43,   0 },
	{   0,   0,    0,    0,   5,  14,  26,  34,  43,   0 },
	{ 100, 100,  100,  100,  80,  60,  40,  20,   0, 100 },
	{   0,   0,    0,    0,  20,  40,  60,  80, 100, 100 },
	{   0, 400,  400,  400,  80,  60,  40,  20,   0,  80 }
},
{ "i:",  2, 45, 140,
	{ 250, 270, 2450, 3220,  42,  43,  38,  45,  43, 248 },
	{ 125, 135, 1225, 1610,  21,  21,  19,  22,  21, 124 },
	{  50,  50,   50,   50,  50,  50,  50,  50,  50,  50 },
 	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 },
	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 }
},
{ "j",   8, 55, 110,
	{ 250, 250, 2320, 2980,  42,  36,  37,  47,  42, 176 },
	{ 125, 125, 1160, 1490,  21,  18,  18,  23,  21,  88 },
	{  50,  50,   50,   50,  50,  50,  50,  50,  50,  50 },
	{   0,  40,   40,   40,  40,  40,  40,  40,  40,   0 },
	{   0,  40,   60,   40,  40,  40,  40,  40,  40,  30 }
},
{ "k",  23, 60,  80,
	{ 250, 190, 1650, 2300,   0,   0,   0,   0,   0,   0 },
	{ 125, 116,  231,  851, -10, -10, -10, -10, -10,   0 },
	{  50,  39,   86,   63, 100, 100, 100, 100, 100,  50 },
	{   0,  30,   50,   30,  30,  30,  30,  30,  30,  20 },
	{   0,   0,    0,    0,   0,   0,   0,   0,   0,   0 }
},
{ "k2",  29, 20,  20,
	{ 250, 190, 1650, 2300,   0,  32,  42,  39,  20,   0 },
	{ 125, 116,  231,  851, -10, -10, -10, -10, -10,   0 },
	{  50,  39,   86,   63, 100, 100, 100, 100, 100,  50 },
	{   0,  30,   50,   30,  30,  30,  30,  30,  30,  20 },
	{   0,   0,    0,    0,   0,   0,   0,   0,   0,   0 }
},
{ "k3",  23, 30,  40,
	{ 250, 190, 1650, 2300,   0,  22,  31,  31,  13,   0 },
	{ 125, 116,  231,  851, -10, -10, -10, -10, -10,   0 },
	{  50,  39,   86,   63, 100, 100, 100, 100, 100,  50 },
	{   0,  30,   50,   30,  30,  30,  30,  30,  30,  20 },
	{   0,   0,    0,    0,   0,   0,   0,   0,   0,   0 }
},
{ "l",   11, 40,  80,
	{ 250, 350, 1380, 2800,  39,  40,  41,  39,  39, 248 },
	{ 125, 175,  690, 1400,  19, -14, -10,  -7,  -7, 124 },
	{  50,  50,   50,   50,  50, 100, 100, 100, 100,  50 },
	{   0,  60,   60,   60,  20,  20,  20,  20,  20,   0 },
	{   0,   0,    0,    0,  20,   0,   0,   0,   0,   0 }
},
{ "l~",  10, 40,  80,
	{ 250, 350,  880, 2800,  39,  40,  41,  39,  39, 248 },
	{ 125, 175,  440, 1400,  19, -14, -10,  -7,  -7, 124 },
	{  50,  50,   50,   50,  50, 100, 100, 100, 100,  50 },
	{   0,  60,   60,   60,  20,  20,  20,  20,  20,   0 },
	{   0,   0,    0,    0,  20,   0,   0,   0,   0,   0 }
},
{ "m",   15, 50, 110,
	{ 250, 355, 1100, 2400,  42,  20,  30,  33,   0, 248 },
	{ 125, 131,  308, 1200,   0, -10, -10, -10, -10, 124 },
	{  50,  63,   72,   50, 100, 100, 100, 100, 100,  50 },
	{   0,  30,   30,   50,  30,  30,  30,  30,  30,  20 },
	{   0,   0,    0,    0,   0,   0,   0,   0,   0,   0 }
},
{ "n",   15, 55, 130,
	{ 250, 265, 1600, 2500,  42,  24,  35,  35,  20, 248 },
	{ 125, 172,  736, 2500,   0, -10, -10, -10, -10, 124 },
	{  50,  35,   54,    0, 100, 100, 100, 100, 100,  50 },
	{   0,  30,   30,   30,  30,  30,  30,  30,  30,  20 },
	{   0,   0,    0,    0,   0,   0,   0,   0,   0,   0 }
},
{ "p",  23, 60,  80,
	{ 250, 190, 1100, 2500,   0,   0,   0,   0,   0,   0 },
	{ 125, 116,  308, 1250, -10, -10, -10, -10, -10,   0 },
	{  50,  39,   72,   50, 100, 100, 100, 100, 100,  50 },
	{   0,  20,   20,   50,  30,  30,  30,  30,  30,  20 },
	{   0,   0,    0,    0,   0,   0,   0,   0,   0,   0 },
},
{ "p2",  29, 20,  20,
	{ 250, 145, 1100, 2500,   0,  24,  38,  31,  38,   0 },
	{ 125,  88,  308, 1200, -10, -10, -10, -10, -10,   0 },
	{  50,  39,   72,   50, 100, 100, 100, 100, 100,  50 },
	{   0,  20,   20,   20,  30,  30,  30,  30,  30,  20 },
	{   0,   0,    0,    0,   0,   0,   0,   0,   0,   0 }
},
{ "p3",  23, 20,  30,
	{ 250, 190, 1100, 2500,   0,  24,  32,  28,  27,   0 },
	{ 125, 116,  308, 1250, -10, -10, -10, -10, -10,   0 },
	{  50,  39,   72,   50, 100, 100, 100, 100, 100,  50 },
	{   0,  20,   20,   20,  30,  30,  30,  30,  30,  20 },
	{   0,   0,    0,    0,   0,   0,   0,   0,   0,   0 }
},
{ "r",   8, 30,  80,
	{ 250, 250, 1130, 1600,  42,  45,  47,  43,   0, 248 },
	{ 125, 125,  565,  800,  21,  22,  23,  21,   0, 124 },
	{  50,  50,   50,   50,  50,  50,  50,  50,  50,  50 },
	{   0,  50,   50,   50,  50,  50,  50,  50,  50,   0 },
	{   0,  50,   50,   70,  50,  50,  50,  50,  50,   0 }
},
{ "s",   6, 80, 125,
	{ 250, 400, 1720, 2620,   0,   0,  31,  31,  50,   0 },
	{ 125, 200,  860, 1310,   0,   0,  15,  15,  25,   0 },
	{  50,  50,   50,   50,  50,  50,  50,  50,  50,  50 },
	{   0,  50,   50,   50,  20,  20,  20,  20,  20,   0 },
	{   0,  20,   20,   20,  20,  20,  20,  20,  20,   0 }
},
{ "t",  23, 40,  80,
	{ 250, 190, 1780, 2680,   0,   0,   0,   0,   0,   0 },
	{ 125, 116,  819,  804, -10, -10, -10, -10, -10,   0 },
	{  50,  39,   54,   70, 100, 100, 100, 100, 100,  50 },
	{   0,  30,   30,   30,  30,  30,  30,  30,  30,  20 },
	{   0,   0,    0,    0,   0,   0,   0,   0,   0,   0 }
},
{ "t2",  29, 20,  20,
	{ 250, 190, 1780, 2680,   0,   0,  25,  36,  43,   0 },
	{ 125, 116,  819,  804, -10, -10, -10, -10, -10,   0 },
	{  50,  39,   54,   70, 100, 100, 100, 100, 100,  50 },
	{   0,  20,   20,   20,  30,  30,  30,  30,  30,  20 },
	{   0,   0,    0,    0,   0,   0,   0,   0,   0,   0 }
},
{ "t3",  23, 20,  30,
	{ 250, 190, 1780, 2680,   0,   0,  17,  22,  34,   0 },
	{ 125, 116,  819,  804, -10, -10, -10, -10, -10,   0 },
	{  50,  39,   54,   70, 100, 100, 100, 100, 100,  50 },
	{   0,  20,   20,   20,  30,  30,  30,  30,  30,  20 },
	{   0,   0,    0,    0,   0,   0,   0,   0,   0,   0 }
},
{ "tS", 10, 50,  70,
	{ 250, 190, 1780, 2680,   0,   0,   0,   0,   0,   0 },
	{ 125,  95,  890, 1340,   0,   0,   0,   0,   0,   0 },
	{  50,  50,   50,   50,  50,  50,  50,  50,  50,  50 },
	{   0,   0,    0,    0,   0,   0,   0,   0,   0,   0 },
	{   0,   0,    0,    0,   0,   0,   0,   0,   0,   0 }
},
{ "tS2", 10, 60, 140,
	{ 250, 400, 1780, 2320,   0,   0,  42,  49,  51,   0 },
	{ 125, 200,  890, 1160,   0,   0,  21,  24,  25,   0 },
	{  50,  50,   50,   50,  50,  50,  50,  50,  50,  50 },
	{   0,   0,    0,    0,   0,   0,   0,   0,   0,   0 },
	{   0,   0,    0,    0,   0,   0,   0,   0,   0,   0 }
},
{ "u:",  2, 30, 155,
	{ 250, 310, 1000, 2100,  42,  43,  33,  28,  32, 248 },
	{ 125, 155,  500, 1050,  21,  21,  16,  14,  16, 124 },
	{  50,  50,   50,   50,  50,  50,  50,  50,  50,  50 },
 	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 },
	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 }
},
{ "v",   6, 50,  85,
	{ 250, 280, 1360, 2560,  27,  27,  32,  32,  37, 140 },
	{ 125, 140,  680, 1280,  13,  13,  16,  16,  18,  70 },
	{  50,  50,   50,   50,  50,  50,  50,  50,  50,  50 },
	{   0,  50,   50,   50,  20,  20,  20,  20,  20,  20 },
	{   0,  20,   20,   20,  20,  20,  20,  20,  20,  20 }
},
{ "w",   8, 60,  80,
	{ 250, 280,  760, 2200,  42,  38,  37,  30,  33, 176 },
	{ 125, 140,  380, 1100,  21,  19,  18,  15,  16,  88 },
	{  50,  50,   50,   50,  50,  50,  50,  50,  50,  50 },
	{   0,  40,   40,   40,  40,  40,  40,  40,  40,   0 },
	{   0,  40,   40,   40,  40,  40,  40,  40,  40,  30 }
},
{ "z",   6, 40, 140,
	{ 250, 280, 1720, 2620,  27,  27,  31,  31,  50, 140 },
	{ 125, 140,  860, 1310,  13,  13,  15,  15,  25,  70 },
	{  50,  50,   50,   50,  50,  50,  50,  50,  50,  50 },
	{   0,  50,   50,   50,  20,  20,  20,  20,  20,  20 },
	{   0,  20,   20,   20,  20,  20,  20,  20,  20,  20 }
},
{ "{",   2, 40, 140,
	{ 250, 750, 1700, 2740,  42,  42,  50,  49,  46, 248 },
	{ 125, 375,  850, 1370,  21,  21,  25,  24,  23, 124 },
	{  50,  50,   50,   50,  50,  50,  50,  50,  50,  50 },
 	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 },
	{   0,  30,   30,   30,  30,  30,  30,  30,  30,   0 }
},
};

#define NUM_PHONE (sizeof(phone_tab)/sizeof(struct phone_rec))
