/* trscale.c -- program to scale track data */
/* A.P.Breen - Jan 1988 */
/* version 1.0 */
/*------------------------------------------------------------*/
/**MAN
.TH TRSCALE.C UCL SPAR
.SH NAME
trscale.c - scale track item
.SH SYNOPSIS
takes a track item and scales it between max and min
.BI trscale x
(-I) (-i item) (-M maximum) (-m minimum)
(-O oldmaximum) (-o oldminimum) file
.SH DESCRIPTION
This program takes as input a track item and creates as output a track 
item which has been scaled to lie between the max and min values specified 
on the command line.  The original range of the data my be entered on the 
command line or calculated from within the program.
.PP
.I Options:
.TP 11
.B -I
Identify program name version.
.TP 11
.B -M
Enter integer Max value.
.TP 11
.B -m
Enter integer min value.
.TP 11
.BI -i item
Select input item number.
.SH INPUT ITEMS
.IP TR.xx
.SH OUTPUT ITEMS
.IP TR.xx
.SH VERSION/AUTHOR
1.0 - A.P.Breen
*/
/*---------------------------------------------------------------*/

/* program name and version */
#define PROGNAME "trscale"
#define PROGVERS "1.0s"

/* global declarations */
#include "SFSCONFG.h"
#include <stdio.h>     /* starndard i/o routines */
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include "sfs.h"	/* database filing sysyem structures */

/* global data */
char		   *progname = PROGNAME;
struct item_header     trinitem;	/* input item header */
struct item_header     troutitem;      /* output item header */
char		   filename[SFSMAXFILENAME]; /* dbase file */
int		    fid;	    /* file id */
int		    ofid;	   /* output channel id */
int			oflag = 0;     /* old scale flag */
float		  buffer;	/* input item buffer */

/* subroutine to scale TR item */
void scale(max,min,oldmax,oldmin)
float  max; /* maximum scale value */
float  min; /* minimum scale value */
float  oldmax; /* old max value */
float  oldmin; /* old min value */

{
int    i;	      /*count variable */

	/* find old min and old max if not given */
	if(oflag < 2){
		for(i=0;i<trinitem.numframes;i++){
		  sfsread(fid,i,1,&buffer);
		  if(buffer > oldmax)oldmax = buffer;
		  if(buffer < oldmin)oldmin = buffer;
		}
	}
	/* scale data */
	for(i=0;i<trinitem.numframes;i++){
		if(sfsread(fid,i,1,&buffer) != 1)
		error("cannot read input data",NULL);
		buffer = ((buffer - oldmin)/(oldmax-oldmin))
			*(max - min) + min;
		if(sfswrite(ofid,1,&buffer) != 1)
		 error("cannot write back to file",NULL);
	}
}

/* main program */
void main (argc,argv)
int    argc;
char   *argv[];
{
	/* option decoding */
	extern  int     optind;	 /* option index */
	extern char     *optarg;	/* optin argument ptr */
	int	     errflg = 0;     /* option error flag */
	int	     it;	     /* item type */
	char	    *ty = "0";	    /* sub type */
	int	     c;	      /* switch variable */
	float	   max = 1.0;	    /* maximum value */
	float	   min = 0.0 ;	    /* minimum value */
	float	   oldmax = -32767.0;  /* old maximum value */
	float	   oldmin = 32767.0;   /* old minmum value */
	double		atof();		   /* returns doubles */
     
	/* decode switches */
	while((c=getopt(argc,argv,"Ii:M:m:O:o:")) != EOF)
		switch(c) {
		case 'I' :      /* Identify */
			fprintf(stderr,"%s: Scale track item V%s\n",PROGNAME,PROGVERS);
			exit(0);
			break;
		case 'i' :      /* specific item */
			if(itspec(optarg,&it,&ty) == 0) {
				if(it != TR_TYPE)
				      error("unsuitable item specifier %s",optarg);
			}
			else
				error("unsuitable item specifier %s",optarg);
			break;
		case 'M':	/* Maximum value */
			max = (float)atof(optarg);
			break;
		case 'm':	/* minimum value */
			min = (float)atof(optarg);
			break;
		case 'O' :      /* Original maximum value */
			oldmax = (float)atof(optarg);
			oflag++;
			break;	
		case 'o' :      /* Original minimum value */
			oldmin = (float)atof(optarg);
			oflag++;
			break;
		case '?' :      /* unknown */
			errflg++;
		}

	/* check command line */
	if(errflg || (argc<2) || (oflag > 0 && oflag < 2))
		error("usage:  %s (-I) (-i item) (-M max value) (-m min value) (-O old max value) (-o old min value) dbase file",PROGNAME);

	/* get filename */
	if(optind >= argc)
		error("no database file specified",NULL);
	else
		strcpy(filename,sfsfile(argv[optind]));

	/* open file */
	if((fid = sfsopen(filename,"w",NULL))<0)
		error("access error on %s",filename);

	/* get input item header */
	if(!sfsitem(fid,TR_TYPE,ty,&trinitem))
		error("no input item",NULL);

	/* create sfs item header */
	sfsheader(&troutitem,TR_TYPE,1,4,1,trinitem.frameduration,
		trinitem.offset,1,0,0);
	sprintf(troutitem.history,"%s(%d.%02d;max=%g,min=%g)",
		PROGNAME,trinitem.datatype,trinitem.subtype,max,min);

	/* open output channel */
	if((ofid = sfschannel(filename,&troutitem)) < 0)
		error("cannot open temporary file",NULL);

	/* scale input data */
	scale(max,min,oldmax,oldmin);

	/* update file */
	if(!sfsupdate(filename))
		error("update error on temporary file",NULL);

	exit(0);
}

