// annot.h -- SFS annotations class

struct Annotation {
	char	*name;
	double	posn;
	double	size;
};

class AnnotationList
{
private:
	Annotation	*table;
	int		num;
public:
	// access
	int size() const { return num; };
	// constructors
	AnnotationList(int size=1);
	AnnotationList(const AnnotationList& an);
	~AnnotationList();
	AnnotationList& operator=(const AnnotationList& an);
	// access an element
	Annotation& operator[] (const int idx);
	const Annotation& operator[] (const int idx) const;
	// find a matching annotation
	Annotation& find(const char *match);
	// file I/O
	int load(const char *fname,const char *anitem);
	int save(const char *fname,const char *anitem);
};
