// cdft.cpp -- implementation of complex-to-complex Discrete Fourier Transform
//
// C++ (c) 1996 Mark Huckvale University College London

#include "tools.h"
#include "cdft.h"

// The ComplexDFT function implements a general complex to
// complex discrete fourier transform

Spectrum ComplexDFT(const ComplexWaveform& x)
{
	Spectrum s(x.count(),x.count()/x.rate());

	// for each output harmonic
	for (int i=0;i<x.count();i++) {
		// get frequency
		double f = (2 * PI * i) / x.count();
		// compute complex sum
		Complex sum=0.0;
		for (int j=0;j<x.count();j++)
			sum += x[j+1] * exp(Complex(0.0,-f*j));
		// scale
		s[i] = sum/x.count();
	}
	return s;
}

// The ComplexIDFT function implements a general complex to
// complex inverse discrete fourier transform

ComplexWaveform ComplexIDFT(const Spectrum& s)
{
	ComplexWaveform x(s.count(),s.count()/s.rate());

	// for each output sample
	for (int i=0;i<x.count();i++) {
		// get frequency
		double f = (2 * PI * i) / x.count();
		// compute complex sum
		Complex sum=0.0;
		for (int j=0;j<x.count();j++)
			sum += s[j] * exp(Complex(0.0,f*j));
		x[i+1] = sum;
	}
	return x;
}

